package lu.tudor.santec.gecamed.letter.ejb.session.interfaces;

import java.util.Collection;
import java.util.List;

import lu.tudor.santec.gecamed.letter.ejb.entity.beans.LetterPlaceholder;


public interface LetterPlaceholderInterface
{
	/**
	 * @return All existing placeholder types
	 */
	public List<String> getPlaceholderTypes ();
	
	/**
	 * @param type The type to search the placeholder names for
	 * @return The names of the placeholders of the given type
	 */
	public List<String> getPlaceholderNamesByType (String type);
	
	/**
	 * @param type The type to search the placeholder names for
	 * @return The placeholders of the given type
	 */
	public List<LetterPlaceholder> getPlaceholdersByType (String type);
	
	/**
	 * @param names The names of the placeholders to fetch
	 * @return All placeholders, that fit to one of the given names
	 */
	public List<LetterPlaceholder> getPlaceholdersByName (Collection<String> names);
	
	/**
	 * @param names The names of the placeholders to fetch
	 * @return All placeholder names, that fit to one of the given names
	 */
	public List<String> getPlaceholderNamesByName (Collection<String> names);

	/**
	 * @return All placeholder names that belong to the type 'CONTACT', <br>
	 * or whose type starts with 'CONTACT_'  
	 */
	public List<String> getContactPlaceholderNames();
	
	
	public List<LetterPlaceholder> getFunctions (Collection<String> types);

	public String getFunctions (String type);
	
	/*
	 * Will be needed later, to manage the placeholders
	 */
//	public LetterPlaceholder getPlaceholder (Integer id);
//
//	public LetterPlaceholder getPlaceholder (String name);
//	
//	public LetterPlaceholder savePlaceholder (LetterPlaceholder placeholder);
//	
//	public LetterPlaceholder savePlaceholder (List<LetterPlaceholder> placeholders);
	
	/**
	 * Performs a HQL query on the GECAMed DB. Only SELECTs are allowed,<br>
	 * no UPDATEs.
	 * 
	 * @param query The HQL query
	 * @return The result of the given HQL query
	 */
	public List<?> doHqlQuery (String query, Integer firstResult, Integer maxResults, Object ... parameters);
	
	/**
	 * Performs a SQL query on the GECAMed DB. Only SELECTs are allowed,<br>
	 * no UPDATEs.
	 * 
	 * @param query The SQL query
	 * @return The result of the given SQL query
	 */
	public List<?> doNativeQuery (String query, Object ... parameters);
}
