/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.ejb.session.interfaces;

import java.util.Collection;
import java.util.List;

import lu.tudor.santec.gecamed.letter.ejb.entity.beans.LetterTemplate;

/*
 Interface for the LetterTemplateBean
 */


public interface LetterTemplateInterface {

	public LetterTemplate addTemplate(LetterTemplate template);
	
	public String saveFile(byte[] b, String name, Integer patientId);
	
	public List<LetterTemplate> getFilteredTemplates (Integer physicianId, String typeFilter, String nameFilter);
		
	public List<LetterTemplate> getTemplatesByPhysycian(int id);
	
	public byte[] getTemplateBinary(LetterTemplate template) throws Exception;
	
	public String setTemplateBinary(String fileName, byte[] binData) throws Exception;

	public boolean removeTemplate(LetterTemplate template);
	
	public Collection<String> getTypes();
	
	public Collection<String> getTypesByPhysician(int id);

	public byte[] getFile(String originalFilename, Integer id);
	
	public String getServerTemplateDir();
	
	public String getServerLetterDir();
	
	public LetterTemplate saveDetails (LetterTemplate template);
	
	public boolean doesTemplateNameAlreadyExist (String name);
}
