/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.gui.components;

import java.util.ArrayList;

import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.letter.ejb.session.beans.LetterBean;
import lu.tudor.santec.gecamed.letter.ejb.session.beans.LetterTemplateBean;
import lu.tudor.santec.gecamed.letter.ejb.session.interfaces.LetterInterface;
import lu.tudor.santec.gecamed.letter.ejb.session.interfaces.LetterTemplateInterface;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 *  Comboox model that can contain letter oder template types or both.
 */

public class ComboBoxTypeModel implements ComboBoxModel
{
	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(ComboBoxTypeModel.class.getName());
	
	
	private ArrayList<String>				types;
	
	private ArrayList<ListDataListener>		listeners;
	
	private String							selectedItem;
	
	
	
	public ComboBoxTypeModel()
	{
		types = new ArrayList<String>();
		listeners = new ArrayList<ListDataListener>();
		
//		PhysicianListenerRegister.addPhysicianListener(this);
	}
	
	
	public void queryTemplateTypes()
	{
		Integer physicianId;
		LetterTemplateInterface templateManager = (LetterTemplateInterface) 
				ManagerFactory.getRemote(LetterTemplateBean.class);
		
		
		try
		{
			if (GECAMedModule.getCurrentPhysician() != null)
				physicianId = GECAMedModule.getCurrentPhysician().getId();
			else 
				physicianId = null;
			
			if (templateManager != null && physicianId != null ) {
				types = new ArrayList<String>(templateManager.getTypesByPhysician(physicianId));				
			}
		}
		catch (Exception e)
		{
			logger.log(Level.ERROR, "Couldn't load letter template types", e);
			types = new ArrayList<String>();
		}
		fireModelChanged();
	}
	
	
	public void queryAllTemplateTypes ()
	{
		LetterTemplateInterface templateManager = (LetterTemplateInterface) 
				ManagerFactory.getRemote(LetterTemplateBean.class);
		
		
		try
		{
			types = new ArrayList<String>(templateManager.getTypes());
		}
		catch (Exception e)
		{
			logger.log(Level.ERROR, "Couldn't load letter template types", e);
			types = new ArrayList<String>();
		}
		fireModelChanged();
	}
	
	
//	public void queryAllTypes()
//	{
//		Collection<String> types_template = templateManager.getTypes();
//		Collection<String> types_letters = letterManager.getTypes();
//		types_template.removeAll(types_letters);
//		types_template.addAll(types_letters);
//		types = (ArrayList<String>) types_template;
//		fireModelChanged();
//	}
	
	
	public void queryLetterTypes()
	{
		LetterInterface	letterManager = (LetterInterface) 
				ManagerFactory.getRemote(LetterBean.class);
		try
		{
			types = new ArrayList<String>(letterManager.getTypes());
		}
		catch (Exception e)
		{
			logger.log(Level.ERROR, "Couldn't load letter template types", e);
			types = new ArrayList<String>();
		}
		fireModelChanged();
	}
	
	
	public Object getSelectedItem()
	{
		return this.selectedItem;
	}
	
	
	public void setSelectedItem(Object anItem)
	{
		this.selectedItem = (String) anItem;
		fireModelChanged();
	}
	
	
	public void addListDataListener(ListDataListener l)
	{
		listeners.add(l);
	}
	
	
	public Object getElementAt(int index)
	{
		return types.get(index);
	}
	
	
	public int getSize()
	{
		return types.size();
	}
	
	
	public void removeListDataListener(ListDataListener l)
	{
		listeners.remove(l);
	}
	
	
	public ArrayList<String> getTypes()
	{
		return types;
	}
	
	
	public void setTypes(ArrayList<String> types)
	{
		this.types = types;
	}
	
	
	public void addElement(String type)
	{
		boolean	found = false;
		String	t;
		
		
		if (type == null)
			return;
		
		for (int i = 0; i < types.size(); i++)
		{
			t = types.get(i);
			if (t != null && t.equalsIgnoreCase(type))
				found = true;
		}
		if (!found)
		{
			this.types.add(type);
			fireModelChanged();
		}
	}
	
	
	public void fireModelChanged()
	{
		for (int i = 0; i < listeners.size(); i++)
		{
			listeners.get(i).contentsChanged(new ListDataEvent(this, ListDataEvent.INTERVAL_ADDED, 0, getSize())
			{
				
				@Override
				public int getIndex0()
				{
					// TODO Auto-generated method stub
					return super.getIndex0();
				}
				
				
				@Override
				public int getIndex1()
				{
					// TODO Auto-generated method stub
					return super.getIndex1();
				}
				
				
				@Override
				public int getType()
				{
					// TODO Auto-generated method stub
					return super.getType();
				}
				
				
				@Override
				public String toString()
				{
					// TODO Auto-generated method stub
					return super.toString();
				}
				
				
				@Override
				public Object getSource()
				{
					// TODO Auto-generated method stub
					return super.getSource();
				}
				
				/**
						 * 
						 */
				private static final long	serialVersionUID	= 1L;
			});
		}
	}


//	public void physicianChanged(Physician physician)
//	{
//		queryLetterTypes();
//	}
}
