package lu.tudor.santec.gecamed.letter.gui.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataListener;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: SortedListModel.java,v $
 * <br>Revision 1.1  2012-12-14 14:57:07  ferring
 * <br>Entries in placeholder type combo box are now alphabetically sorted
 * <br>
 */

public class SortedListModel implements MutableComboBoxModel
{
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private TreeSet<String>			sortedData			= new TreeSet<String>();
	
	private ArrayList<String>		data				= null;
	
	private int						selection			= -1;
	
	private List<ListDataListener>	listDataListener	= new LinkedList<ListDataListener>();
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public int getSize()
	{
		return sortedData.size();
	}
	
	
	public Object getElementAt(int index)
	{
		return getData().get(index);
	}
	
	
	public void addListDataListener(ListDataListener l)
	{
		listDataListener.add(l);
	}
	
	
	public void removeListDataListener(ListDataListener l)
	{
		listDataListener.remove(l);
	}
	
	
	public void setSelectedItem(Object anItem)
	{
		if (anItem == null)
			selection = -1;
		else
			selection = getData().indexOf(anItem);
	}
	
	
	public Object getSelectedItem()
	{
		if (selection < 0 || selection >= getData().size())
			 return null;
		else return getData().get(selection);
	}
	
	
	public void addElement(Object obj)
	{
		if (obj == null)
			return;
		
		sortedData.add(String.valueOf(obj));
		data = null;
		if (selection == -1)
			selection = indexOf(String.valueOf(obj));
	}
	
	
	public void removeElement(Object obj)
	{
		remove(obj, indexOf(obj));
	}
	
	
	public void insertElementAt(Object obj, int index)
	{
		addElement(obj);
	}
	
	
	public void removeElementAt(int position)
	{
		remove (get(position), position);
	}
	
	
	public void addAll(Collection<String> items)
	{
		if (items == null || items.isEmpty())
			return;
		
		for (String item : items)
			addElement(item);
	}
	
	
	
	/* ======================================== */
	// 		HELP METHODS
	/* ======================================== */
	
	private ArrayList<String> getData ()
	{
		if (data == null)
			data = new ArrayList<String>(sortedData);
		
		return data;
	}
	
	
	private boolean remove (Object item, int index)
	{
		if (item == null)
			return false;
		
		if (index == selection)
			selection = -1;
		
		item = String.valueOf(item);
		
		if (sortedData.remove(item))
		{
			data = null;
			return true;
		}
		else
			return false;
	}
	
	
	private int indexOf (Object item)
	{
		int					i;
		Iterator<String>	iter;
		
		
		if (item == null)
			return -1;
		
		item = String.valueOf(item);
		
		iter	= sortedData.iterator();
		for (i = 0; iter.hasNext(); i++)
		{
			if (item.equals(iter.next()))
				return i;
		}
		
		return -1;
	}
	
	
	private String get (int position)
	{
		Iterator<String>	iter;
		int					i;
		

		if (data != null)
			return data.get(position);
		
		iter = sortedData.iterator();
		for (i = 0; i < position && iter.hasNext(); i++)
			iter.next();
		
		if (!iter.hasNext())
			return null;
		
		return iter.next();
	}
}
