/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
//package lu.tudor.santec.gecamed.letter.gui.dialogs;
//
//import java.awt.Color;
//import java.awt.Container;
//import java.awt.event.ActionEvent;
//import java.awt.event.ActionListener;
//import java.io.File;
//import java.util.ArrayList;
//import java.util.Date;
//
//import javax.swing.JButton;
//import javax.swing.JCheckBox;
//import javax.swing.JComboBox;
//import javax.swing.JDialog;
//import javax.swing.JFileChooser;
//import javax.swing.JFrame;
//import javax.swing.JLabel;
//import javax.swing.JOptionPane;
//import javax.swing.JPanel;
//import javax.swing.JScrollPane;
//import javax.swing.JTextArea;
//import javax.swing.JTextField;
//import javax.swing.border.LineBorder;
//
//import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
//import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
//import lu.tudor.santec.gecamed.core.gui.MainFrame;
//import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
//import lu.tudor.santec.gecamed.letter.ejb.entity.beans.LetterTemplate;
//import lu.tudor.santec.gecamed.letter.ejb.session.beans.LetterTemplateBean;
//import lu.tudor.santec.gecamed.letter.ejb.session.interfaces.LetterTemplateInterface;
//import lu.tudor.santec.gecamed.letter.gui.ControllerConfig;
//import lu.tudor.santec.gecamed.letter.gui.LetterTemplateModule;
//import lu.tudor.santec.gecamed.letter.gui.PlaceholdersConfig;
//import lu.tudor.santec.gecamed.letter.gui.components.ComboBoxTypeModel;
//import lu.tudor.santec.gecamed.letter.gui.components.LimitedTextArea;
//import lu.tudor.santec.gecamed.letter.gui.controller.IController;
//import lu.tudor.santec.gecamed.letter.gui.controller.utils.FileUtils;
//import lu.tudor.santec.gecamed.letter.gui.controller.word.WordController;
//import lu.tudor.santec.gecamed.letter.gui.controller.writer.WriterController;
//import lu.tudor.santec.gecamed.letter.gui.settings.LetterTemplateSettings;
//import lu.tudor.santec.gecamed.letter.gui.templatelist.TemplateDetailsPanel;
//import lu.tudor.santec.i18n.Translatrix;
//
//import com.jgoodies.forms.layout.CellConstraints;
//import com.jgoodies.forms.layout.FormLayout;
//
///*
// * Allows to select the place holders for the template, naming the template and describing the template
// * After confirming the dialog the ActionListener of the Dialog will create the template.
// */
//
//public class AddTemplateDialog extends JDialog implements ActionListener {
//	/**
//	 * 
//	 */
//	private static final long serialVersionUID = 1L;
//
//	private static final int FRAME_WIDTH = 900;
//
//	private JPanel pPlaceHolders;
//
//	private JTextField name;
//
//	private JTextArea description;
//
//	private JPanel contentPane;
//
//	private Container parentPane;
//
//	private LetterTemplateInterface manager;
//
//	private JComboBox cbType;
//
//	private JCheckBox share;
//
//	private ArrayList<JCheckBox> cbBoxes;
//
//	private String insertPlaceholders;
//
//	protected File importFile;
//
//	public AddTemplateDialog(Container parentPane) {
//		super(MainFrame.getInstance(), true);
//		setTitle(Translatrix
//				.getTranslationString("LetterTemplateModule.dialog.title.addtemplate"));
//		manager = (LetterTemplateInterface) ManagerFactory
//				.getRemote(LetterTemplateBean.class);
//		init();
//		this.parentPane = parentPane;
//	}
//
//	public void init() {
//		this.setSize(FRAME_WIDTH, 550);
//
//		// Creating content of the dialog
//		contentPane = new JPanel();
//		contentPane
//				.setLayout(new FormLayout("fill:90dlu:grow,50dlu:grow",
//						"10dlu,fill:250:grow,10dlu,fill:50dlu,10dlu,20dlu,10dlu,20dlu,20dlu"));
//
//		CellConstraints cc = new CellConstraints();
//
//		JLabel lPlaceholders = new JLabel(
//				Translatrix
//						.getTranslationString("LetterTemplateModule.dialog.fields.placeholders"));
//
//		contentPane.add(lPlaceholders, cc.xy(1, 1));
//		pPlaceHolders = new JPanel();
//
//		// Drawing placholders on the panel
//		initPlaceholders();
//
//		pPlaceHolders.setBorder(new LineBorder(Color.black, 1));
//		JScrollPane scPane = new JScrollPane(pPlaceHolders);
//		contentPane.add(scPane, cc.xyw(1, 2, 2));
//
//		String[] param = { TemplateDetailsPanel.DESC_MAX_LENGTH + "" };
//		JLabel lDescriptions = new JLabel(Translatrix.getTranslationString(
//				"LetterTemplateModule.dialog.fields.description", param));
//		contentPane.add(lDescriptions, cc.xy(1, 3));
//
//		description = new LimitedTextArea(TemplateDetailsPanel.DESC_MAX_LENGTH);
//		description.setBorder(new LineBorder(Color.BLACK, 1));
//		JScrollPane scrollpane = new JScrollPane(description);
//		contentPane.add(scrollpane, cc.xy(1, 4));
//
//		final JLabel lImport = new JLabel();
//		lImport.setIcon(GECAMedModule.getMediumIcon(GECAMedIconNames.CANCEL));
//
//		JPanel pfileImport = new JPanel();
//		JButton bImport = new JButton(
//				Translatrix
//						.getTranslationString("LetterTemplateModule.dialog.fields.import"));
//		
//		final JFileChooser chooser = new JFileChooser();
//		chooser.setFileFilter(ControllerConfig.getExtensionFilter());
//		bImport.addActionListener(new ActionListener() {
//			public void actionPerformed(ActionEvent e) {
//				int returnVal = chooser.showOpenDialog(AddTemplateDialog.this);
//				if (returnVal == JFileChooser.APPROVE_OPTION) {
//					importFile = chooser.getSelectedFile();
//					lImport.setIcon(GECAMedModule
//							.getMediumIcon(GECAMedIconNames.OK));
//				}
//			}
//		});
//		pfileImport.add(bImport);
//
//		pfileImport.add(lImport);
//
//		contentPane.add(pfileImport, cc.xy(2, 4));
//
//		JLabel lType = new JLabel(
//				Translatrix
//						.getTranslationString("LetterTemplateModule.dialog.fields.type"));
//		contentPane.add(lType, cc.xy(1, 5));
//
//		ComboBoxTypeModel cbModel = new ComboBoxTypeModel();
//		cbModel.queryAllTypes();
//		cbType = new JComboBox(cbModel);
//		cbType.setModel(cbModel);
//		try {
//			cbType.setSelectedIndex(0);
//		} catch (Exception e) {
//		}
//		cbType.setEditable(true);
//		contentPane.add(cbType, cc.xy(1, 6));
//
//		share = new JCheckBox(
//				Translatrix
//						.getTranslationString("LetterTemplateModule.dialog.fields.share"));
//		share.setSelected(true);
//		contentPane.add(share, cc.xy(2, 6, CellConstraints.CENTER,
//				CellConstraints.CENTER));
//
//		JLabel lName = new JLabel(
//				Translatrix
//						.getTranslationString("LetterTemplateModule.dialog.fields.name_letter"));
//		contentPane.add(lName, cc.xy(1, 7));
//
//		name = new JTextField();
//		contentPane.add(name, cc.xy(1, 8));
//
//		JButton add_template = new JButton(
//				Translatrix
//						.getTranslationString("LetterTemplateModule.dialog.fields.addletter"));
//		add_template.addActionListener(this);
//		contentPane.add(add_template, cc.xy(2, 8));
//
//		JLabel text = new JLabel(
//				Translatrix
//						.getTranslationString("LetterTemplateModule.dialog.fields.optional"));
//		contentPane.add(text, cc.xy(1, 9));
//		this.setLocationRelativeTo(MainFrame.getInstance());
//		this.setContentPane(contentPane);
//		this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
//		this.setVisible(true);
//	}
//
//	private void initPlaceholders() {
//
//		// Getting all placeholders
//		String[] placeholders = PlaceholdersConfig.getPlaceholders();
//		int size = placeholders.length;
//		cbBoxes = new ArrayList<JCheckBox>();
//
//		// Initialising number of columns to show the placholders
//		final double column_count = 3;
//
//		// Calculating the number of rows from the amount of placholders and
//		// columns
//		double row_count = Math.floor(size / column_count) + 1;
//
//		// Calculating the with of a column
//		double width = FRAME_WIDTH / column_count;
//
//		// Itialising the columns for the layout (FormLayout)
//		String columns = width - 40 + "px";
//		for (int i = 1; i < column_count; i++) {
//			columns += (", " + width + "px");
//		}
//
//		// Itilialising the rows for the layout (FormLayout)
//		String rows = "pref";
//		for (int i = 1; i < row_count; i++) {
//			rows += (",pref");
//		}
//
//		pPlaceHolders.setBackground(new Color(163, 186, 208));
//		pPlaceHolders.setLayout(new FormLayout(columns, rows));
//		CellConstraints cc = new CellConstraints();
//		JCheckBox cb = null;
//
//		// Adding the placholders to the panel
//		for (int i = 1; i <= size; i++) {
//			cb = new JCheckBox(
//					"<html><font color=\"#FFFFFF\"><b>"
//							+ Translatrix
//									.getTranslationString("LetterTemplateModule.placeholders."
//											+ placeholders[i - 1])
//							+ "</b></font><br><font size=\"2\"><i>["
//							+ placeholders[i - 1] + "]</i></font></html>");
//			cb.setName(placeholders[i - 1]);
//			cb.setOpaque(false);
//			cbBoxes.add(cb);
//
//			int row = (int) (Math.ceil(i / column_count));
//			int column = (int) (((i - 1) % column_count) + 1);
//
//			pPlaceHolders.add(cb, cc.xy(column, row));
//		}
//
//	}
//
//	public void actionPerformed(ActionEvent e) {
//
//		// New Thread that creates a new file on the disk of the client, opens
//		// it and when it's saved
//		// the Thread will store it in the database. Similar to :
//		// CreateLetterListener
//		insertPlaceholders = null;
//		for (int i = 0; i < cbBoxes.size(); i++) {
//			if (cbBoxes.get(i).isSelected()) {
//				if (insertPlaceholders != null)
//					insertPlaceholders += cbBoxes.get(i).getName() + "\n";
//				else
//					insertPlaceholders = cbBoxes.get(i).getName() + "\n";
//			}
//		}
//
//		// Initiating the controller for the text processing software
//
//		if (cbType.getSelectedItem() != null) {
//
//			new Thread() {
//				public void run() {
//
//					IController controller = ControllerConfig.getController();
//					try {
//						// Create a new document on the client-side
//						MainFrame.getInstance().setWaitCursor(true);
//
//						if (!ControllerConfig.getLocalTemplatePath()
//								.equalsIgnoreCase(
//										LetterTemplateSettings.DEFAULT)) {
//							if (importFile != null && importFile.exists())
//								controller.setDocument(FileUtils
//										.readFile(importFile), ControllerConfig
//										.getLocalLetterPath());
//							else
//								controller.createNewDocument(ControllerConfig
//										.getLocalTemplatePath());
//						} else {
//							if (importFile != null && importFile.exists())
//								controller.setDocument(FileUtils
//										.readFile(importFile));
//							else
//								controller.createNewDocument();
//						}
//						controller.open();
//
//						if (insertPlaceholders != null)
//							controller.insert(insertPlaceholders);
//
//						MainFrame.getInstance().setWaitCursor(false);
//						controller.waitForUserInput();
//						lu.tudor.santec.gecamed.letter.gui.controller.data.State state = controller
//								.getState();
//						if (state.isSaved()) {
//							// When saved getting the session bean to store the
//							// file
//							// on the server
//
//							// Getting the filename of the local document
//							File document = controller.getDocumentbyFile();
//
//							// Saving the document on the server
//							String filename = manager.setTemplateBinary(
//									document.getName(), controller
//											.getDocument());
//
//							if (ControllerConfig.deleteDocuments()) {
//								// Delete the local document
//								controller.deleteDocument();
//							}
//
//							String tpl_description = description.getText();
//
//							// Saving the filename when no name was provided by
//							// the user
//							String tpl_name;
//							if (name.getText().equals("")
//									|| name.getText().equals(" ")) {
//								tpl_name = document.getName();
//							} else {
//								tpl_name = name.getText();
//							}
//
//							// Creating the template and storing in the database
//							LetterTemplate template = new LetterTemplate();
//							template.setCreatedOn(new Date());
//							template.setCreatedBy(GECAMedModule
//									.getCurrentPhysician().getId());
//							template.setDescription(tpl_description);
//							template.setModifiedOn(new Date());
//							template.setModifiedBy(GECAMedModule
//									.getCurrentPhysician().getId());
//							template.setName(tpl_name);
//
//							template.setType(cbType.getSelectedItem()
//									.toString());
//
//							template.setShare(!share.isSelected());
//							template.setGeneratedFileName(filename);
//							template.setPhysicianId(GECAMedModule
//									.getCurrentPhysician().getId());
//							if (controller instanceof WordController) {
//								template
//										.setMimetype(ControllerConfig.MIME_WORD);
//							} else if (controller instanceof WriterController) {
//								template
//										.setMimetype(ControllerConfig.MIME_WRITER);
//							} else {
//								template
//										.setMimetype(ControllerConfig.MIME_LETTER);
//							}
//							manager.addTemplate(template);
//
//							// Update the list of all templates in the
//							// LetterTemplateModule
//							LetterTemplateModule.getInstance().updateList(0);
//
//							LetterTemplateModule
//									.getInstance()
//									.getCbModel()
//									.addElement(
//											cbType.getSelectedItem().toString());
//							LetterTemplateModule
//									.getInstance()
//									.getDetails()
//									.getCbModel()
//									.addElement(
//											cbType.getSelectedItem().toString());
//
//						} else {
//							if (ControllerConfig.deleteDocuments()) {
//								// Delete the local document
//								controller.deleteDocument();
//							}
//						}
//					} catch (Throwable e) {
//						MainFrame.getInstance().setWaitCursor(false);
//						JOptionPane
//								.showMessageDialog(
//										parentPane,
//										Translatrix
//												.getTranslationString("LetterTemplateModule.dialog.error.templatecreating"),
//										Translatrix
//												.getTranslationString("LetterTemplateModule.dialog.error.title"),
//										JOptionPane.ERROR_MESSAGE);
//						System.out.println(e.getLocalizedMessage());
//					}
//				}
//			}.start();
//			this.dispose();
//		} else {
//			JOptionPane
//					.showMessageDialog(
//							parentPane,
//							Translatrix
//									.getTranslationString("LetterTemplateModule.dialog.error.type"),
//							Translatrix
//									.getTranslationString("LetterTemplateModule.dialog.error.title"),
//							JOptionPane.ERROR_MESSAGE);
//		}
//	}
//}
