/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.gui.dialogs;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.core.gui.widgets.SearchField;
import lu.tudor.santec.gecamed.patient.gui.fileimport.ChooseIncidentBox;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.form.FormInputComponent;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author martin.heinemann@tudor.lu
 * 02.09.2008
 * 14:02:34
 *
 *
 * @version
 * <br>$Log: NewLetterDialogPanel.java,v $
 * <br>Revision 1.7  2013-03-22 10:49:35  ferring
 * <br>store position and size of the dialog by user
 * <br>minimum size added
 * <br>scroll pane grows now, when resizing
 * <br>
 * <br>Revision 1.6  2013-02-14 08:15:18  ferring
 * <br>incident selection added to new letters and improved for files
 * <br>
 * <br>Revision 1.5  2012-11-26 07:56:14  ferring
 * <br>New placeholders are introduced to the letter module
 * <br>The replacement algorithm in Word- and WriterCotnroller has been changed
 * <br>Multicontacts are prepared, but not yet implemented
 * <br>
 * <br>Revision 1.4  2008-12-05 17:34:23  heinemann
 * <br>moved some basic classes to lu.tudor.santec.widgets
 * <br>
 * <br>Revision 1.3  2008-11-12 17:16:33  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-09-03 10:24:14  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class NewLetterDialogPanel extends JPanel {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	protected SearchField searchField;
	protected JComboBox categoryBox;
	protected ChooseIncidentBox	incidentBox;
	protected JList templateList;
	protected JLabel contactLabel;
	protected FormInputComponent contactPanel;
	protected JTextField nameField;
	private FormInputComponent namePanel;
	private JScrollPane scroll;
	private JLabel incidentLabel;
	private JLabel categoryLabel;
	
	
	
	public NewLetterDialogPanel() {
		/* ================================================== */
		initComponents();
		buildPanel();
		
		this.setOpaque(false);
		/* ================================================== */
	}

	/**
	 * 
	 */
	private void buildPanel() {
		/* ====================================================== */
		CellConstraints	cc			= new CellConstraints();
		JPanel 			topPanel	= new JPanel(new FormLayout(
				"f:p, 3px, f:p, f:p:g, 5px, f:p, 5px, f:p", 
				"f:p, 5px, f:p"));
		
		
		setLayout(new FormLayout("5px, f:p:g, 5px", 
				" 5px,f:p," +	// top panel
				" 5px,f:p:g," +	// letters (scroll)
//				" 5px,f:p," +	// contact panel
				"10px,f:p," +	// name panel
				" 5px"));
		
		topPanel.setOpaque(false);
		topPanel.add(this.incidentLabel,	cc.xy (1, 1));
		topPanel.add(this.incidentBox,		cc.xy (3, 1));
		topPanel.add(this.searchField,		cc.xyw(1, 3, 4));
		topPanel.add(this.categoryLabel,	cc.xy (6, 3));
		topPanel.add(this.categoryBox,		cc.xy (8, 3));
		
		add(topPanel,		cc.xy(2, 2));
		add(scroll,			cc.xy(2, 4));
//		add(contactPanel,	cc.xy(2, 6));
		add(namePanel,		cc.xy(2, 6));
		/* ====================================================== */
	}

	/**
	 * 
	 */
	private void initComponents() {
		/* ====================================================== */
		this.searchField			= new SearchField(15);
		this.incidentBox			= new ChooseIncidentBox();
		this.categoryBox	= new JComboBox();
		
		this.categoryLabel	= new JLabel(
				Translatrix.getTranslationString("LetterTemplateModule.add.category")); 
		this.incidentLabel	= new JLabel(
				Translatrix.getTranslationString("fileimport.incident"));
		
		this.templateList	= new JList();
		this.contactLabel	= new JLabel();
		this.contactPanel	= new FormInputComponent("LetterTemplateModule.new.contact", 
										contactLabel, "LetterTemplateModule.new.select");
		this.nameField		= new JTextField(50);
		this.namePanel		= new FormInputComponent("core.name", this.nameField);
		
		this.scroll			= new JScrollPane(this.templateList);
		/* ------------------------------------------------------- */
		// set opaque false
		/* ------------------------------------------------------- */
		this.categoryLabel.setOpaque(false);
		this.incidentLabel.setOpaque(false);
		this.contactPanel.setOpaque(false);
		this.namePanel.setOpaque(false);
		/* ====================================================== */
	}
	
}
