/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.letter.gui.components.SortedListModel;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.form.FormPanel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.util.DefaultValidationResultModel;
import com.jgoodies.validation.view.ValidationResultViewFactory;

/**
 * @author martin.heinemann@tudor.lu
 * 25.08.2008
 * 10:56:05
 *
 *
 * @version
 * <br>$Log: NewTemplateDialogPanel.java,v $
 * <br>Revision 1.6  2012-12-14 14:57:07  ferring
 * <br>Entries in placeholder type combo box are now alphabetically sorted
 * <br>
 * <br>Revision 1.5  2012-11-26 07:56:14  ferring
 * <br>New placeholders are introduced to the letter module
 * <br>The replacement algorithm in Word- and WriterCotnroller has been changed
 * <br>Multicontacts are prepared, but not yet implemented
 * <br>
 * <br>Revision 1.4  2008-12-05 17:34:23  heinemann
 * <br>moved some basic classes to lu.tudor.santec.widgets
 * <br>
 * <br>Revision 1.3  2008-11-12 17:16:33  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.1  2008-08-27 15:34:53  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class NewTemplateDialogPanel extends JPanel{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	protected JTextField nameField;
	protected JComboBox templateCategoryBox;
	protected JLabel documentLabel;
	protected JButton importDocumentButton;
	protected JComboBox placeHolderCategoryBox;
	protected JList placeHolderRepositoryList;
	protected JList selectedPlaceHolderList;
	protected JButton selectAllButton;
	protected JButton selectButton;
	protected JButton deselectButton;
	protected JButton deselectAllButton;
	protected JComboBox contactCategoryBox;
	private JPanel importButtonPanel;
	private JPanel placeHolderPanel;
	private CellConstraints cc;
	private JLabel placeHolderLabel;
	private JScrollPane selectedPlaceHolderListScroll;
	private JScrollPane placeHolderRepositoryListScroll;
	protected DefaultValidationResultModel validationResultModel;
	private JComponent reportList;
	
	
	public NewTemplateDialogPanel() {
		/* ================================================== */
		initComponents();
		buildPanel();
		this.validationResultModel.setResult(ValidationResult.EMPTY);
		/* ================================================== */
	}


	
	private void initComponents() {
		/* ================================================== */
		PlaceholderCellRenderer	renderer	= new PlaceholderCellRenderer();
		
		
		this.nameField 					= new JTextField(30);
		this.templateCategoryBox 		= new JComboBox();
		
		this.documentLabel 				= new JLabel();
		this.importDocumentButton 		= new JButton();
		
		this.placeHolderLabel 			= new JLabel();
		this.placeHolderCategoryBox 	= new JComboBox(new SortedListModel());
		this.placeHolderRepositoryList 	= new JList();
		this.placeHolderRepositoryList.setCellRenderer(renderer);
		this.selectedPlaceHolderList 	= new JList();
		this.selectedPlaceHolderList.setCellRenderer(renderer);
		
		this.selectedPlaceHolderListScroll   = new JScrollPane(this.selectedPlaceHolderList);
		this.placeHolderRepositoryListScroll = new JScrollPane(this.placeHolderRepositoryList);
		
		this.selectButton 				= new JButton();
		this.selectAllButton 			= new JButton();
		this.deselectButton 			= new JButton();
		this.deselectAllButton 			= new JButton();
		
		this.contactCategoryBox 		= new JComboBox();
		
		/* ------------------------------------------------------- */
		// a panel for the document label and the import button
		/* ------------------------------------------------------- */
		this.importButtonPanel = new JPanel(new FormLayout("75dlu,fill:pref" ,"fill:pref"));
		this.importButtonPanel.setOpaque(false);
		this.cc = new CellConstraints();
		
		this.importButtonPanel.add(this.documentLabel, cc.xy(1, 1));
		this.importButtonPanel.add(this.importDocumentButton, cc.xy(2, 1));
		
		/* ------------------------------------------------------- */
		// fill with translatrix
		/* ------------------------------------------------------- */
		this.documentLabel.setText(Translatrix.getTranslationString("LetterTemplateModule.add.empty"));
		this.placeHolderLabel.setText(Translatrix.getTranslationString("LetterTemplateModule.add.placeholder.heading"));
		
		this.importDocumentButton.setText(Translatrix.getTranslationString("LetterTemplateModule.add.importdocument"));
		/* ------------------------------------------------------- */
		this.selectButton.setText(     ">");
		this.selectAllButton.setText(  ">>");
		
		this.deselectButton.setText(   "<");
		this.deselectAllButton.setText("<<");
		
		
		/* ================================================== */
		// create the validation things
		/* ================================================== */
		this.validationResultModel = new DefaultValidationResultModel();
		this.reportList = ValidationResultViewFactory
				.createReportList(validationResultModel);
		reportList.setMaximumSize(new Dimension(reportList.getMaximumSize().width, 25));
		
		/* ================================================== */
	}
	
	/**
	 * 
	 */
	private void buildPanel() {
		/* ====================================================== */
		buildPlaceholderPanel();
		
		FormPanel formPanel = new FormPanel();
		formPanel.setOpaque(false);
		formPanel.addLine(Translatrix.getTranslationString("LetterTemplateModule.add.name"),
							nameField);
		formPanel.addLine(Translatrix.getTranslationString("LetterTemplateModule.add.category"), templateCategoryBox);
		formPanel.addGap();
		formPanel.addLine(Translatrix.getTranslationString("LetterTemplateModule.add.document"), importButtonPanel);
		formPanel.addSeparator();
		/* ------------------------------------------------------- */
		this.setLayout(new BorderLayout());
		this.setOpaque(false);
		
		this.add(formPanel, BorderLayout.NORTH);
		this.add(this.placeHolderPanel, BorderLayout.CENTER);
		
		/* ====================================================== */
	}
	
	
	/**
	 * 
	 */
	private void buildPlaceholderPanel() {
		/* ================================================== */
		this.placeHolderPanel = new JPanel(new FormLayout(
												// cols
												"3dlu,fill:100dlu,6dlu,fill:pref,6dlu,fill:100dlu,3dlu",
												// rows
												"3dlu,fill:pref,10dlu,fill:pref,5dlu,fill:150dlu,5dlu,fill:pref,3dlu,fill:25dlu"));
		placeHolderPanel.setOpaque(false);
		/* ------------------------------------------------------- */
		// a panel for the buttons < << >> >
		/* ------------------------------------------------------- */
		JPanel moveButtonPanel = new JPanel(new FormLayout("0dlu,pref,0dlu",
												"pref:grow,pref,2dlu,pref,15dlu,pref,2dlu,pref,pref:grow"));
		moveButtonPanel.setOpaque(false);
		
		moveButtonPanel.add(this.selectButton, 	    cc.xy(2, 2));
		moveButtonPanel.add(this.selectAllButton, 	cc.xy(2, 4));
		moveButtonPanel.add(this.deselectAllButton, cc.xy(2, 6));
		moveButtonPanel.add(this.deselectButton, 	cc.xy(2, 8));
		
		
		placeHolderPanel.add(this.placeHolderLabel, 		 	   cc.xy(2, 2));
		placeHolderPanel.add(this.placeHolderCategoryBox, 	 	   cc.xy(2, 4));
		placeHolderPanel.add(this.placeHolderRepositoryListScroll, cc.xy(2, 6));
		placeHolderPanel.add(this.selectedPlaceHolderListScroll,   cc.xy(6, 6));
		placeHolderPanel.add(moveButtonPanel, 				 	   cc.xy(4, 6));
		placeHolderPanel.add(new FormPanel(Translatrix.getTranslationString("LetterTemplateModule.add.contactcategory"),
				this.contactCategoryBox, false), cc.xyw(2, 8, 5));
		
		placeHolderPanel.add(reportList, cc.xyw(2, 10, 5));
		/* ================================================== */
	}
	
	

}
