package lu.tudor.santec.gecamed.letter.gui.dialogs;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ReplaceOrCopyLetterDialog.java,v $
 * <br>Revision 1.1  2012-11-26 13:23:12  ferring
 * <br>Open and modify letter changed to one action. User will be asked, after closing the document, what to do
 * <br>
 */

public class ReplaceOrCopyLetterDialog extends GECAMedBaseDialogImpl
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 1L;
	
	
	public static final int		REPLACE		= YES_OPTION;
	public static final int		CREATE_NEW	= NO_OPTION;
	public static final int		DISCARD		= CANCEL_OPTION;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private JLabel	textLabel;
	
	private int		option;
	
	private int		lastOption;
	
	private JRadioButton	replaceButton;
	
	private JRadioButton	createNewButton;
	
	private JRadioButton	discardButton;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public ReplaceOrCopyLetterDialog ()
	{
		super(MainFrame.getInstance(), 
				Translatrix.getTranslationString("LetterTemplateModule.dialog.modifyOrCopyLetter.title"), 
				OK_BUTTON_MODE);
		
		CellConstraints	cc	= new CellConstraints();
		ButtonGroup		bg	= new ButtonGroup();
		
		
		mainPanel.setLayout(new FormLayout(
				"5px,p,5px", 
				"5px,p," +	// description
				"15px,p," +	// replace
				"5px,p," +	// create new
				"5px,p," +	// discard
				"5px"));
		
		textLabel	= new JLabel();
		
		replaceButton	= new JRadioButton(new AbstractAction(
				Translatrix.getTranslationString("LetterTemplateModule.dialog.modifyOrCopyLetter.replace"))
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed(ActionEvent e)
			{
				option	= REPLACE;
			}
		});
		bg.add(replaceButton);
		replaceButton.setOpaque(false);
		
		createNewButton	= new JRadioButton(new AbstractAction(
				Translatrix.getTranslationString("LetterTemplateModule.dialog.modifyOrCopyLetter.createNew"))
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed(ActionEvent e)
			{
				option	= CREATE_NEW;
			}
		});
		bg.add(createNewButton);
		createNewButton.setOpaque(false);
		mainPanel.add(createNewButton, cc.xy(2, 6));

		discardButton	= new JRadioButton(new AbstractAction(
				Translatrix.getTranslationString("LetterTemplateModule.dialog.modifyOrCopyLetter.discard"))
		{
			private static final long	serialVersionUID	= 1L;

			public void actionPerformed(ActionEvent e)
			{
				option	= DISCARD;
			}
		});
		bg.add(discardButton);
		discardButton.setOpaque(false);

		mainPanel.add(textLabel,		cc.xy(2, 2));
		mainPanel.add(replaceButton,	cc.xy(2, 4));
		mainPanel.add(createNewButton,	cc.xy(2, 6));
		mainPanel.add(discardButton,	cc.xy(2, 8));
		
		// select REPLACE as default
		replaceButton.setSelected(true);
		option		= REPLACE;
		lastOption	= REPLACE;
		
		enableCancelKeyMapping(false);
	}
	
	
	public int showDialog(String letterName)
	{
		textLabel.setText(Translatrix.getTranslationString("LetterTemplateModule.dialog.modifyOrCopyLetter.message", 
				new String[] { letterName }));
		
		if (discardButton.isSelected())
		{
			option	= lastOption;
			if (option == REPLACE)
				 replaceButton.setSelected(true);
			else createNewButton.setSelected(true);
		}
		
		pack();
		super.showCenteredDialog();
		
		if (option != DISCARD)
			lastOption	= option;
		
		return option;
	}
	
	
	@Override
	public void closeActionCalled()
	{
		this.option	= DISCARD;
		super.closeActionCalled();
	}
}
