/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.letter.gui.listeners;

import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.letter.ejb.entity.beans.LetterTemplate;
import lu.tudor.santec.gecamed.letter.gui.LetterTemplateModule;
import lu.tudor.santec.gecamed.letter.gui.templatelist.TemplateDetailsPanel;
import lu.tudor.santec.i18n.Translatrix;

/*
 * Lister that trigegrs on the change of the selection of the list
 */

public class TemplateListSelectionListener implements ListSelectionListener 
{
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private TemplateDetailsPanel	details;
	
	private LetterTemplateModule	module;
	
	private boolean					adapting = false;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public TemplateListSelectionListener(JPanel details) 
	{
		this.details	= (TemplateDetailsPanel) details;
		this.module		= LetterTemplateModule.getInstance();
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	public void valueChanged(ListSelectionEvent evt) 
	{
		int				buttonOption;
		JList			list		= (JList) evt.getSource();
		LetterTemplate	newTemplate	= (LetterTemplate) list.getSelectedValue();
		LetterTemplate	oldTemplate	= details.getCurrentTemplate();
//		boolean			change		= oldTemplate == null 
//									|| oldTemplate.equals(newTemplate);
		
		
		if (evt.getValueIsAdjusting()
				|| (oldTemplate != null && oldTemplate.equals(newTemplate))
				|| adapting)
			return;
		
		if (module.isModified())
		{
			buttonOption	= GECAMedBaseDialogImpl.showMessageDialog(module, 
					Translatrix.getTranslationString("LetterTemplateModule.dialog.unsavedChanges.title"), 
					Translatrix.getTranslationString("LetterTemplateModule.dialog.unsavedChanges.message"), 
					GECAMedBaseDialogImpl.YES_NO_CANCEL_BUTTON_MODE, 
					GECAMedModule.getIcon(GECAMedIconNames.WARNING));
			
			if (buttonOption == GECAMedBaseDialogImpl.YES_OPTION)
			{
				module.save();
			}
			else if (buttonOption == GECAMedBaseDialogImpl.NO_OPTION)
			{
				module.setModified(false);
			}
			else // if (buttonOption == GECAMedBaseDialogImpl.CANCEL_OPTION 
				 //  || buttonOption == GECAMedBaseDialogImpl.CLOSED_OPTION)
			{
				adapting = true;
				module.getList().setSelectedValue(oldTemplate, true);
				adapting = false;
				
				// do NOT render
				return;
			}
		}
		
		details.render(newTemplate);
	}

}
