package lu.tudor.santec.gecamed.letter.gui.placeholders;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.formeditor.gui.FormEditorModule;
import lu.tudor.santec.gecamed.letter.ejb.entity.beans.LetterPlaceholder;
import lu.tudor.santec.gecamed.letter.ejb.session.beans.LetterPlaceholderBean;
import lu.tudor.santec.gecamed.letter.ejb.session.interfaces.LetterPlaceholderInterface;

class NewPlaceholdersConfig
{
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private static LetterPlaceholderInterface	manager;
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
//	public static HashMap<String, String> generateCategory (String category, Contact contact)
//	{
//		// TODO Auto-generated method stub
//		return null;
//	}
	
	
//	public static Map<String, String> getPlaceholdersMap (Contact contact)
//	{
//		// TODO Auto-generated method stub
//		return null;
//	}

	public static Map<String, String> getPlaceholdersMap (List<Contact> contacts, Collection<String> names) throws WrongJavaVersionException
	{
		LetterPlaceholderInterface	manager;
		List<LetterPlaceholder>		placeholders;
		ScriptingManager			scriptManager;
		
		
		if (!FormEditorModule.isJavaVersionOK())
		{
			throw new WrongJavaVersionException("You need Java Version 1.6 or higher, " +
					"to run the letter template with the new placeholder version.");
		}
		
		if (names == null || names.isEmpty())
			return new HashMap<String, String>();
		
		manager			= getManager();
		placeholders	= manager.getPlaceholdersByName(names);
		
		if (placeholders == null || placeholders.isEmpty())
			return new HashMap<String, String>();
		
		scriptManager	= new ScriptingManager();
		scriptManager.initializeEngine(contacts);
		scriptManager.loadScripts(placeholders);
		
		return scriptManager.nextData();
	}
	
	
	public static String getValue (String key, String category, Contact contact)
	{
		// TODO Auto-generated method stub
		return null;
	}
	
	
	public static HashMap<String, List<LetterPlaceholder>> getPlaceHolders ()
	{
		List<String>								types;
		List<LetterPlaceholder>						names;
		HashMap<String, List<LetterPlaceholder>>	placholders;
		LetterPlaceholderInterface					manager;
		
		
		manager		= getManager();
		types		= manager.getPlaceholderTypes();
		placholders	= new HashMap<String, List<LetterPlaceholder>>();
		
		for (String type : types)
		{
			names	= manager.getPlaceholdersByType(type);
			placholders.put(type, names);
		}
		
		return placholders;
	}
	
	
	public static HashMap<String, List<String>> getPlaceHolderNames ()
	{
		List<String>					types;
		List<String>					names;
		HashMap<String, List<String>>	placholders;
		LetterPlaceholderInterface		manager;
		
		
		manager		= getManager();
		types		= manager.getPlaceholderTypes();
		placholders	= new HashMap<String, List<String>>();
		
		for (String type : types)
		{
			names	= manager.getPlaceholderNamesByType(type);
			placholders.put(type, names);
		}
		
		return placholders;
	}
	
	
	public static List<String> getPlaceHolderCategories ()
	{
		return getManager().getPlaceholderTypes();
	}


	public static List<String> getContactPlaceholders()
	{
		return getManager().getContactPlaceholderNames();
	}


	public static List<LetterPlaceholder> loadFunctions(Collection<LetterPlaceholder> placeholders)
	{
		Collection<String>		types	= new HashSet<String>();
		List<LetterPlaceholder>	functions;
		
		
		for (LetterPlaceholder p : placeholders)
			types.add(p.getType());
		
		functions	= getManager().getFunctions(types);
		
		return functions;
	}
	
	
	public static LetterPlaceholderInterface getManager ()
	{
		if (manager == null)
			manager	= (LetterPlaceholderInterface) ManagerFactory
					.getRemote(LetterPlaceholderBean.class);
		
		return manager;
	}
}
