package lu.tudor.santec.gecamed.letter.gui.placeholders;

import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

import lu.luxtrust.logging.Log;
import lu.luxtrust.logging.Logger;
import lu.tudor.santec.gecamed.addressbook.ejb.entity.beans.Contact;
import lu.tudor.santec.gecamed.core.utils.printing.ireport.UtilFormatter;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Office;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Site;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: ScriptTest.java,v $
 * <br>Revision 1.6  2014-01-15 09:45:55  donak
 * <br>test
 * <br>
 * <br>Revision 1.5  2013-12-27 18:09:26  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.4  2013-07-15 06:18:37  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.3  2013-05-08 13:45:08  ferring
 * <br>Labo rootCA fixes
 * <br>
 * <br>Revision 1.2  2012-12-14 09:48:21  ferring
 * <br>Interface IController replaced by abstract class DocumentController
 * <br>Function added to update placeholders in letter template
 * <br>
 * <br>Revision 1.1  2012-12-03 06:45:02  ferring
 * <br>This is the class to test the placeholder scripts
 * <br>
 */

/**
 * @author jens.ferring(at)tudor.lu
 */
public class ScriptTest
{
	
	private static Patient			PATIENT			= null;
	private static Physician		PHYSICIAN		= null;
	private static List<Physician>	PHYSICIAN_LIST	= null;
	private static Office			OFFICE			= null;
	private static Contact			MAIN_CONTACT	= null;
	private static Contact			COPY_CONTACT	= null;
	private static List<Contact>	CONTACT_LIST	= null;
	private static GecamedUser		USER			= null;
	private static Site				SITE			= null;
//	private static DatabaseManager	DATABASE_MANAGER= new DatabaseManager();
//	private static UtilFormatter	FORMATTER		= new UtilFormatter();
	private static DatabaseManager	DATABASE_MANAGER= null;
	private static UtilFormatter	FORMATTER		= null;
	
	static 
	{
//		try
//		{
//			PatientAdminInterface patientManager = (PatientAdminInterface) ManagerFactory.getRemote(PatientAdminBean.class);
//			OfficeManagerInterface officeManager = (OfficeManagerInterface) ManagerFactory.getRemote(OfficeManagerBean.class);
//			patient	= patientManager.getPatient(27363); // Bill Billing
//			physician = officeManager.getPhysician(13); // Dr. Ferring
//			office = officeManager.getOffice(1); 
//			try
//			{
//				site = officeManager.getSites().iterator().next();
//			}
//			catch (Exception e) {}
//		}
//		catch (Exception e)
//		{
//			e.printStackTrace();
//		}
	}
	
	
public void testScript ()
{
}

/* ======================================== */
// 		FUNCTIONS
/* ======================================== */

public List getPatientAllergies (int id)
{
	return null;
}


public List getPatientAntecedents (int id)
{
	return null;
}



/**
 * @param patient The patient to get the history from
 * @param types The incident entry types to fetch
 * @param fromDate The earliest date to get the history 
 * @param toDate The latest date to get the history
 * @return The IncidentEntries of the patient
 */
public List<IncidentEntry> getPatientIncidentEntries (Patient patient, String[] types, Date fromDate, Date toDate)
{
	StringBuilder query = new java.lang.StringBuilder();
	
	// define the query
	query.append("SELECT OBJECT(e)")
			.append("\nFROM Incident i, IncidentEntry e, IncidentEntryType t")
			.append("\nWHERE i.patientId = ").append(patient.getId())
			.append("\nAND i.id = e.incidentId")
			.append("\nAND t.id = e.entryTypeId");
	if (types != null)
	{
		query.append("\nAND t.name IN (");
		for (int i = 0; i < types.length; i++)
			query.append(i == 0 ? "'" : ", '").append(types[i]).append("'");
		query.append(")\n");
	}
	if (fromDate != null)
		query.append("\nAND i.incidentDate > ").append(FORMATTER.formatDate(fromDate, "'yyyy-MM-dd'"));
	if (toDate != null)
		query.append("\nAND i.incidentDate < ").append(FORMATTER.formatDate(toDate, "'yyyy-MM-dd'"));
	query.append("\nORDER BY e.entryDate, i.incidentDate");
	
	return (List<IncidentEntry>) DATABASE_MANAGER.doHqlQuery(query.toString());
}


/**
 * @param patient The patient to get the history from
 * @param types The incident entry types to fetch
 * @param fromDate The earliest date to get the history 
 * @param toDate The latest date to get the history
 * @return The history of the patient as HTML
 */
public String getPatientHistory (Patient patient, String[] types, Date fromDate, Date toDate)
{
	List<IncidentEntry> entries = getPatientIncidentEntries(patient, types, fromDate, toDate);
	StringBuilder html = new java.lang.StringBuilder("<html><table border=1 cellspacing=0><tbody>\n");
	List<IncidentEntry> incident = new java.util.LinkedList<IncidentEntry>();
	IncidentEntry currentEntry;
	Incident currentIncident = null;
	
	for (int i = 0; i < entries.size(); i++)
	{
		currentEntry = entries.get(i);
		
		if (currentIncident == null)
			currentIncident = currentEntry.getIncident();
		
		if (currentIncident.equals(currentEntry.getIncident()))
		{
			incident.add(currentEntry);
		}
		else
		{
			for (int j = 0; j < incident.size(); j++)
				appendIncidentEntryRow(incident.get(j), html, j == 0 ? incident.size() : 0);
			incident.clear();
		}
		
	}
	
	html.append("\n</tbody></table></html>");
	
	return html.toString();
}


/**
 * IncidentEntry entry: The incident entry to format
 * StringBuilder html
 * Date dateRowSpan
 * return: HTML of the data of the incident entry
 */
public StringBuilder appendIncidentEntryRow (IncidentEntry entry, StringBuilder html, int dateRowSpan)
{
	String type = entry.getEntryType().getName();
	
	
	if (type == null)
		return html;
	
	html.append("<tr>");
	if (dateRowSpan > 0)
	{
		html.append("<td rowspan=")
				.append(dateRowSpan)
				.append(">\n")
				.append(FORMATTER.formatDate(entry.getIncident().getIncidentDate()))
				.append("</td>");
	}
	
	if (type.toLowerCase().startsWith("soap."))
	{
		html.append("  <td>")
				.append(tryTranslate("patient.incident.", type))
				.append("</td><td>")
				.append(entry.getTextContent().replace("\n", "<br/>"))
				.append("</td>");
		
	}
	else if (type.toLowerCase().equals("measurement"))
	{
		type = tryTranslate("patient.incident.", type);
		html.append("<td /><td />");
	}
	else if (type.toLowerCase().equals("prescription"))
		html.append("<td /><td />");
	else if (type.toLowerCase().equals("dicom"))
		html.append("<td /><td />");
	else if (type.toLowerCase().equals("file"))
		html.append("<td /><td />");
	else if (type.toLowerCase().equals("letter"))
		html.append("<td /><td />");
	else if (type.toLowerCase().equals("form"))
		html.append("<td /><td />");
	else if (type.toLowerCase().equals("labo.result"))
		html.append("<td /><td />");
	
	html.append("\n</tr>\n");
	return html;
}



/**
 * String prefix: The prefix of the translation
 * String label: The label to the translation
 * return Translates the concatenation of the two strings
 */
public String tryTranslate (String prefix, String label)
{
	String translation;
	
	
	if (label == null)
		return "";
	if (prefix == null)
		prefix = "";
	
    // Concats the label onto the prefix string and tries to translate
    // them by calling formatter.translate().
	translation = FORMATTER.translate(prefix+label);
	
    // If this translation returns null, the label is returned.
	if (translation == null)
		return label;
	else
		return translation;
}


/**
 * Calendar cal: The calendar to clear
 * return: The given calendar, with unchanged date, but
 * time set to 00:00:00.000
 */
public Calendar clearCalendar(Calendar cal)
{
	cal.set(java.util.Calendar.HOUR_OF_DAY, 0);
	cal.set(java.util.Calendar.MINUTE, 0);
	cal.set(java.util.Calendar.SECOND, 0);
	cal.set(java.util.Calendar.MILLISECOND, 0);
	
	return cal;
}



/* ======================================== */
// 		MAIN
/* ======================================== */

public static void main(String[] args) throws Exception
{
	System.out.println(System.getProperty("java.io.tmpdir"));
//	Log l = Logger.getLogger("lu.luxtrust");
//	
//	System.out.println(l.getClass());
//	for (Field f : l.getClass().getDeclaredFields())
//		System.out.println(f.getName());
	
//	// TEST: Extract name, description, filename and filesize from ITI-18 request:
//	String iti18Response = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Header xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"/><soap:Body><ns4:AdhocQueryResponse xmlns=\"urn:oasis:names:tc:ebxml-regrep:xsd:rim:3.0\" xmlns:ns2=\"urn:oasis:names:tc:ebxml-regrep:xsd:rs:3.0\" xmlns:ns3=\"urn:oasis:names:tc:ebxml-regrep:xsd:lcm:3.0\" xmlns:ns4=\"urn:oasis:names:tc:ebxml-regrep:xsd:query:3.0\" status=\"urn:oasis:names:tc:ebxml-regrep:ResponseStatusType:Success\" totalResultCount=\"12\"><RegistryObjectList><ObjectRef id=\"urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d\"/><ObjectRef id=\"urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab\"/><ExtrinsicObject home=\"1.3.6.1.4.1.5729.10020.2.6.13.0\" id=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" isOpaque=\"false\" mimeType=\"text/xml\" objectType=\"urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1\" status=\"urn:oasis:names:tc:ebxml-regrep:StatusType:Approved\"><Slot name=\"creationTime\"><ValueList><Value>20130604124340</Value></ValueList></Slot><Slot name=\"hash\"><ValueList><Value>424edc52cb1912fdac131688ad96933352f87e98</Value></ValueList></Slot><Slot name=\"languageCode\"><ValueList><Value>fr-FR</Value></ValueList></Slot><Slot name=\"repositoryUniqueId\"><ValueList><Value>1.3.6.1.4.1.5729.10020.2.6.7.1.2</Value></ValueList></Slot><Slot name=\"size\"><ValueList><Value>105928</Value></ValueList></Slot><Slot name=\"sourcePatientId\"><ValueList><Value>485216467^^^&amp;1.3.6.1.4.1.5729.10020.2.6.10.1&amp;ISO</Value></ValueList></Slot><Slot name=\"sourcePatientInfo\"><ValueList><Value>PID-3|485216467^^^&amp;1.3.6.1.4.1.5729.10020.2.6.10.1&amp;ISO</Value><Value>PID-5|TUDOR^patient^^^^^L</Value><Value>PID-8|M</Value><Value>PID-7|19700507</Value><Value>PID-23|^^^^^^N</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"cda-testCDApdf1.xml_1 java client\" xml:lang=\"FR\"/></Name><Description><LocalizedString charset=\"UTF8\" value=\"Envoi Mirth cda-testCDApdf1.xml_1\" xml:lang=\"sr-Latn\"/></Description><Classification classificationScheme=\"urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1\" classifiedObject=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" id=\"urn:uuid:3bd7dbd9-86a7-47da-a5fb-a002f71d731f\" nodeRepresentation=\"SA38\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.2.250.1.71.4.2.4</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Pharmacie minière\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:f0306f51-975f-434e-a61c-c59651d33983\" classifiedObject=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" id=\"urn:uuid:a548dfa2-9d19-4631-b470-af8bca53035b\" nodeRepresentation=\"11526-1\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>2.16.840.1.113883.6.1</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"CR d'anatomie et de cytologie pathologiques\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead\" classifiedObject=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" id=\"urn:uuid:aab7a6fb-d109-46a9-a3b1-a88000f502c7\" nodeRepresentation=\"HAD\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.2.250.1.213.1.1.4.9</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Hospitalisation à domicile\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f\" classifiedObject=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" id=\"urn:uuid:9f24aa49-0d30-4671-b1ec-faf27f53f5c7\" nodeRepresentation=\"V\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>2.16.840.1.113883.5.25</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Très restreint\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d\" classifiedObject=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" id=\"urn:uuid:379df7e5-ea72-4fec-984c-d0a12c253e19\" nodeRepresentation=\"urn:ihe:iti:xds-sd:pdf:2008\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.3.6.1.4.1.19376.1.2.3</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"documents à corps non structuré en Pdf/A-1\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d\" classifiedObject=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" id=\"urn:uuid:2ffbdc00-ddfb-4f72-b96e-a040cb286706\" nodeRepresentation=\"\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"authorPerson\"><ValueList><Value>P000004545^TUDOR^Medecin^^^^^^123133^D^^^EI</Value></ValueList></Slot><Name/></Classification><Classification classificationScheme=\"urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a\" classifiedObject=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" id=\"urn:uuid:5d42db14-02ec-4f3f-a1b8-dc0043a6b861\" nodeRepresentation=\"10\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.2.250.1.213.1.1.4.1</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Comptes rendus\" xml:lang=\"FR\"/></Name></Classification><ExternalIdentifier id=\"urn:uuid:2d1332a7-3493-4c9f-8bdb-9d25c154b121\" identificationScheme=\"urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:ExternalIdentifier\" registryObject=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" value=\"485216467^^^&amp;1.3.6.1.4.1.5729.10020.2.6.10.1&amp;ISO\"><Name><LocalizedString charset=\"UTF8\" value=\"XDSDocumentEntry.patientId\" xml:lang=\"FR\"/></Name></ExternalIdentifier><ExternalIdentifier id=\"urn:uuid:c28a532a-90dd-4a3b-96f8-dd0775fde452\" identificationScheme=\"urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:ExternalIdentifier\" registryObject=\"urn:uuid:f458bdf4-2f7d-4f69-9b07-b2db40080af9\" value=\"1.3.6.1.4.1.5729.10020.2.6.7.1.99.167\"><Name><LocalizedString charset=\"UTF8\" value=\"XDSDocumentEntry.uniqueId\" xml:lang=\"FR\"/></Name></ExternalIdentifier></ExtrinsicObject><ObjectRef id=\"urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427\"/><ObjectRef id=\"urn:uuid:f0306f51-975f-434e-a61c-c59651d33983\"/><ExtrinsicObject home=\"1.3.6.1.4.1.5729.10020.2.6.13.0\" id=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" isOpaque=\"false\" mimeType=\"application/pdf\" objectType=\"urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1\" status=\"urn:oasis:names:tc:ebxml-regrep:StatusType:Approved\"><Slot name=\"creationTime\"><ValueList><Value>20130524114812</Value></ValueList></Slot><Slot name=\"hash\"><ValueList><Value>e56c4aa03b37f6a773bc409b05ad310ad450c030</Value></ValueList></Slot><Slot name=\"languageCode\"><ValueList><Value>fr-FR</Value></ValueList></Slot><Slot name=\"repositoryUniqueId\"><ValueList><Value>1.3.6.1.4.1.5729.10020.2.6.7.1.2</Value></ValueList></Slot><Slot name=\"size\"><ValueList><Value>18332</Value></ValueList></Slot><Slot name=\"sourcePatientId\"><ValueList><Value>485216467^^^&amp;1.3.6.1.4.1.5729.10020.2.6.10.1&amp;ISO</Value></ValueList></Slot><Slot name=\"sourcePatientInfo\"><ValueList><Value>PID-3|485216467^^^&amp;1.3.6.1.4.1.5729.10020.2.6.10.1&amp;ISO</Value><Value>PID-5|TUDOR^patient^^^^^L</Value><Value>PID-8|M</Value><Value>PID-7|19700507</Value><Value>PID-23|^^^^^^N</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"pdfa1.pdf_1\" xml:lang=\"FR\"/></Name><Description><LocalizedString charset=\"UTF8\" value=\"Envoi Mirth pdfa1.pdf_1\" xml:lang=\"sr-Latn\"/></Description><Classification classificationScheme=\"urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1\" classifiedObject=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" id=\"urn:uuid:7b71234a-3fd7-4ca0-9fec-8f69a6f0f2be\" nodeRepresentation=\"SA18\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.2.250.1.71.4.2.4</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Etablissement Aide à la famille\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:f0306f51-975f-434e-a61c-c59651d33983\" classifiedObject=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" id=\"urn:uuid:6e9e6904-4ac9-4029-aed9-dcb83f526379\" nodeRepresentation=\"46241-6\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>2.16.840.1.113883.6.1</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"CR d'admission\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead\" classifiedObject=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" id=\"urn:uuid:7fc96ac6-9ac9-41a4-9100-b4c7620e104e\" nodeRepresentation=\"MAD\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.2.250.1.213.1.1.4.9</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Maintien à domicile\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f\" classifiedObject=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" id=\"urn:uuid:3c58f4df-2e75-4945-96a3-b5814a85fa39\" nodeRepresentation=\"R\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>2.16.840.1.113883.5.25</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Restreint\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d\" classifiedObject=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" id=\"urn:uuid:446aea03-349a-49bc-be6c-ddac9b19358f\" nodeRepresentation=\"application/pdf\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>dcr_formatCode</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"application/pdf\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d\" classifiedObject=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" id=\"urn:uuid:9b54f17f-9ac5-4790-b18c-d7161992286e\" nodeRepresentation=\"\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"authorPerson\"><ValueList><Value>P000004545^TUDOR^Medecin^^^^^^123133^D^^^EI</Value></ValueList></Slot><Name/></Classification><Classification classificationScheme=\"urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a\" classifiedObject=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" id=\"urn:uuid:7c11f8f4-656a-46b3-8c7c-e7656cac919f\" nodeRepresentation=\"10\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.2.250.1.213.1.1.4.1</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Comptes rendus\" xml:lang=\"FR\"/></Name></Classification><ExternalIdentifier id=\"urn:uuid:27f53a9c-bc37-410e-b3f1-cb75201c1850\" identificationScheme=\"urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:ExternalIdentifier\" registryObject=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" value=\"485216467^^^&amp;1.3.6.1.4.1.5729.10020.2.6.10.1&amp;ISO\"><Name><LocalizedString charset=\"UTF8\" value=\"XDSDocumentEntry.patientId\" xml:lang=\"FR\"/></Name></ExternalIdentifier><ExternalIdentifier id=\"urn:uuid:b67018e3-2f00-40f2-90c1-bbb5f785860f\" identificationScheme=\"urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:ExternalIdentifier\" registryObject=\"urn:uuid:1616c00d-83f0-46c7-864d-d61e29c99c50\" value=\"1.3.6.1.4.1.5729.10020.2.6.7.1.99.14\"><Name><LocalizedString charset=\"UTF8\" value=\"XDSDocumentEntry.uniqueId\" xml:lang=\"FR\"/></Name></ExternalIdentifier></ExtrinsicObject><ObjectRef id=\"urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a\"/><ObjectRef id=\"urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1\"/><ObjectRef id=\"urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f\"/><ObjectRef id=\"urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead\"/><ObjectRef id=\"urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d\"/><ExtrinsicObject home=\"1.3.6.1.4.1.5729.10020.2.6.13.0\" id=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" isOpaque=\"false\" mimeType=\"text/xml\" objectType=\"urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1\" status=\"urn:oasis:names:tc:ebxml-regrep:StatusType:Approved\"><Slot name=\"creationTime\"><ValueList><Value>20130524124340</Value></ValueList></Slot><Slot name=\"hash\"><ValueList><Value>424edc52cb1912fdac131688ad96933352f87e98</Value></ValueList></Slot><Slot name=\"languageCode\"><ValueList><Value>fr-FR</Value></ValueList></Slot><Slot name=\"repositoryUniqueId\"><ValueList><Value>1.3.6.1.4.1.5729.10020.2.6.7.1.2</Value></ValueList></Slot><Slot name=\"size\"><ValueList><Value>105928</Value></ValueList></Slot><Slot name=\"sourcePatientId\"><ValueList><Value>485216467^^^&amp;1.3.6.1.4.1.5729.10020.2.6.10.1&amp;ISO</Value></ValueList></Slot><Slot name=\"sourcePatientInfo\"><ValueList><Value>PID-3|485216467^^^&amp;1.3.6.1.4.1.5729.10020.2.6.10.1&amp;ISO</Value><Value>PID-5|TUDOR^patient^^^^^L</Value><Value>PID-8|M</Value><Value>PID-7|19700507</Value><Value>PID-23|^^^^^^N</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"cda-testCDApdf1.xml_1\" xml:lang=\"FR\"/></Name><Description><LocalizedString charset=\"UTF8\" value=\"Envoi Mirth cda-testCDApdf1.xml_1\" xml:lang=\"sr-Latn\"/></Description><Classification classificationScheme=\"urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1\" classifiedObject=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" id=\"urn:uuid:a9867447-c41a-483e-a627-fc69288dc2cc\" nodeRepresentation=\"SA38\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.2.250.1.71.4.2.4</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Pharmacie minière\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:f0306f51-975f-434e-a61c-c59651d33983\" classifiedObject=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" id=\"urn:uuid:035ef108-a165-4aef-88db-a3c0fbce315e\" nodeRepresentation=\"11526-1\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>2.16.840.1.113883.6.1</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"CR d'anatomie et de cytologie pathologiques\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead\" classifiedObject=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" id=\"urn:uuid:244e90ed-529d-4bb4-9a04-ef0076fee963\" nodeRepresentation=\"HAD\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.2.250.1.213.1.1.4.9</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Hospitalisation à domicile\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f\" classifiedObject=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" id=\"urn:uuid:fb4a3b37-77c4-4f62-9a36-c4f88f03ab53\" nodeRepresentation=\"V\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>2.16.840.1.113883.5.25</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Très restreint\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d\" classifiedObject=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" id=\"urn:uuid:f1086202-266a-4524-97c0-8a4e75e57a4b\" nodeRepresentation=\"urn:ihe:iti:xds-sd:pdf:2008\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.3.6.1.4.1.19376.1.2.3</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"documents à corps non structuré en Pdf/A-1\" xml:lang=\"FR\"/></Name></Classification><Classification classificationScheme=\"urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d\" classifiedObject=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" id=\"urn:uuid:97cb84f7-44b1-4c45-bcf1-cac7b5b70171\" nodeRepresentation=\"\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"authorPerson\"><ValueList><Value>P000004545^TUDOR^Medecin^^^^^^123133^D^^^EI</Value></ValueList></Slot><Name/></Classification><Classification classificationScheme=\"urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a\" classifiedObject=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" id=\"urn:uuid:3da1eab4-caa3-4c27-af23-c88eaa5a7eb8\" nodeRepresentation=\"10\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:Classification\"><Slot name=\"codingScheme\"><ValueList><Value>1.2.250.1.213.1.1.4.1</Value></ValueList></Slot><Name><LocalizedString charset=\"UTF8\" value=\"Comptes rendus\" xml:lang=\"FR\"/></Name></Classification><ExternalIdentifier id=\"urn:uuid:1ae605bd-e7cd-4528-8ca5-f97d5cabb150\" identificationScheme=\"urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:ExternalIdentifier\" registryObject=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" value=\"485216467^^^&amp;1.3.6.1.4.1.5729.10020.2.6.10.1&amp;ISO\"><Name><LocalizedString charset=\"UTF8\" value=\"XDSDocumentEntry.patientId\" xml:lang=\"FR\"/></Name></ExternalIdentifier><ExternalIdentifier id=\"urn:uuid:ef0ec479-49ca-4051-b8e1-d6d9ad435810\" identificationScheme=\"urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab\" objectType=\"urn:oasis:names:tc:ebxml-regrep:ObjectType:RegistryObject:ExternalIdentifier\" registryObject=\"urn:uuid:b8490685-74ae-4dbb-ac5f-a99dc2eaf24c\" value=\"1.3.6.1.4.1.5729.10020.2.6.7.1.99.16\"><Name><LocalizedString charset=\"UTF8\" value=\"XDSDocumentEntry.uniqueId\" xml:lang=\"FR\"/></Name></ExternalIdentifier></ExtrinsicObject></RegistryObjectList></ns4:AdhocQueryResponse></soap:Body></soap:Envelope>";
//	// TODO: ...
//	Document response =  DocumentBuilderFactory.newInstance()
//			.newDocumentBuilder().parse(new InputSource(
//					new StringReader(iti18Response)));
//	
//	System.out.println("Status: "+XPathAPI.selectNodeValue(response, "//*[local-name()='AdhocQueryResponse']/@status", false));
//	NodeList cdaHeaders = XPathAPI.selectNodeIterator(response, 
//			"//*[local-name()='ExtrinsicObject']", false); 
//	
//	for (int i = 0; i < cdaHeaders.getLength(); i++)
//	{
//		Node cdaHeader = cdaHeaders.item(i);
//		String id = XPathAPI.selectNodeValue(cdaHeader,
//				"*[local-name()='ExternalIdentifier' and @*[local-name()='identificationScheme']='urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab']/@value",
//				false);
//		if (id != null)
//		{
//			System.out.println(id);
//			// content mime type
//			System.out.println(XPathAPI.selectNodeValue(cdaHeader,
//					"@mimeType", 
//					false));
//			// creation time
//			System.out.println(XPathAPI.selectNodeValue(cdaHeader, 
//					"*[local-name()='Slot' and @*[local-name()='name']='creationTime']/*[local-name()='ValueList']/*[local-name()='Value']/text()", 
//					false));
//			// unique ID
//			System.out.println(XPathAPI.selectNodeValue(cdaHeader, 
//					"*[local-name()='Slot' and @*[local-name()='name']='repositoryUniqueId']/*[local-name()='ValueList']/*[local-name()='Value']/text()", 
//					false));
//			// content size
//			System.out.println(XPathAPI.selectNodeValue(cdaHeader, 
//					"*[local-name()='Slot' and @*[local-name()='name']='size']/*[local-name()='ValueList']/*[local-name()='Value']/text()", 
//					false));
//			// name
//			System.out.println(XPathAPI.selectNodeValue(cdaHeader, 
//					"*[local-name()='Name']/*[local-name()='LocalizedString']/@value", 
//					false));
//			// description
//			System.out.println(XPathAPI.selectNodeValue(cdaHeader, 
//					"*[local-name()='Description']/*[local-name()='LocalizedString']/@value", 
//					false));
//			System.out.println("  --------------------  ");
//		}
//	}
	
	
	// TEST: Create own language
	
//	String html = "<was>\n   <adljh>\n         sdoghsdfog\nskldgjsfg\n   <iopg";
//	Pattern pattern = Pattern.compile("^\\s+(?=\\<)", Pattern.MULTILINE);
//	Matcher matcher = pattern.matcher(html);
//	System.out.println(matcher.replaceAll(""));
//	title		= "M";
//	firstName	= "Lily";
//	surName		= "Potter";
//	maidenName	= "Evans";
//	male		= false;
//	
//	System.out.println(formatName("%T %Fc [%Su-%Mu]"));
}

public static void printCal (Calendar cal)
{
	DateFormat	df	= new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.S Z");
	System.out.println(df.format(cal.getTime()));
}

private static final String T	= "%T";
private static final String Tu	= "%T";
private static final String Tl	= "%T";
private static final String Tc	= "%T";
private static final String F	= "%F";
private static final String Fu	= "%F";
private static final String Fl	= "%F";
private static final String Fc	= "%F";
private static final String S	= "%S";
private static final String Su	= "%S";
private static final String Sl	= "%S";
private static final String Sc	= "%S";
private static final String M	= "%M";
private static final String Mu	= "%M";
private static final String Ml	= "%M";
private static final String Mc	= "%M";

private static String	title;
private static String	firstName;
private static String	surName;
private static String	maidenName;
private static boolean	male;


public static String formatName (String formatString)
{
	List<String>	formatParts	= new LinkedList<String>();
	
	
	if (title != null && title.trim().length() == 0)
		title = null;
	if (firstName != null && firstName.trim().length() == 0)
		firstName = null;
	if (surName != null && surName.trim().length() == 0)
		surName = null;
	if (maidenName != null && maidenName.trim().length() == 0)
		maidenName = null;
	
	
	
	return formatString;
}

private static boolean containsNull (String s)
{
	return (s.contains(T) && title == null)
			|| (s.contains(F) && firstName == null)
			|| (s.contains(S) && surName == null)
			|| (s.contains(M) && maidenName == null);
}


private static String replaceConditions (String s)
{
	return s;
}


private static String clearCondition (String s)
{
	return s.replaceAll("(?<=.*\\[[^\\]]*)(?=.*\\].*)[^(%[TFSM][ulc]?)]", "");
}


private static String replacePlacholders (String s)
{
	s	= s.replaceAll("%T[ulc]?", title		== null ? "" : title);
	s	= s.replaceAll("%F[ulc]?", firstName	== null ? "" : firstName);
	s	= s.replaceAll("%S[ulc]?", surName		== null ? "" : surName);
	s	= s.replaceAll("%M[ulc]?", maidenName	== null ? "" : maidenName);
	
	return s;
}
}
