/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.address.ejb.entity.beans.GECAMedAddressBean;

/**
 * Entity Bean that maps the <b>office.office_address</b> table
 * which stores the addresses of a table
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 *@Version
 * <br>$Log: OfficeAddress.java,v $
 * <br>Revision 1.9  2009-02-04 16:03:11  hermen
 * <br>added bean and table for site and site_address
 * <br>created GECAMedAddressBean which all addresses should extend
 * <br>
 * <br>Revision 1.8  2008-12-18 13:06:58  mack
 * <br>Localities are to be printed in uppercase characters
 * <br>
 * <br>Revision 1.7  2008-10-07 09:33:30  heinemann
 * <br>GECAMedEntityBean now implements Comparable
 * <br>
 * <br>Revision 1.6  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-15 13:08:51  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * 
 */
@javax.persistence.NamedQueries({

    // findAll NamedQuery
    @javax.persistence.NamedQuery(name="findAllOfficeAddress",
        query="SELECT OBJECT(o) FROM OfficeAddress o"),
    // NamedQueries using Fields.
    @javax.persistence.NamedQuery(name="findAllOfficeAddressByOfficeId",
        query="SELECT OBJECT(o) FROM OfficeAddress o WHERE o.officeId = :officeId")
})

@Entity
@Table(name = "office_address", schema = "office")
public class OfficeAddress extends GECAMedAddressBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private Integer officeId;

	/**
	 * Get the office_id.
	 *
	 * @return The office_id.
	 */
	@javax.persistence.Column(name = "office_id")
	public Integer getOfficeId() {
		return officeId;
	}

	/**
	 * Set the officetId.
	 *
	 * @param filename The officeId.
	 */
	public void setOfficeId(Integer patientId) {
		this.officeId = patientId;
	}

}
