/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>office.office_phone</b> table
 * which stores the offices phones
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 *@Version
 * <br>$Log: OfficePhone.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:08  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-15 13:08:51  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * 
 */
@javax.persistence.NamedQueries({

    // findAll NamedQuery
    @javax.persistence.NamedQuery(name="findAllOfficePhone",
        query="SELECT OBJECT(o) FROM OfficePhone o"),
    // NamedQueries using Fields.
    @javax.persistence.NamedQuery(name="findAllPOfficePhoneByOfficetId",
        query="SELECT OBJECT(o) FROM OfficePhone o WHERE o.officeId = :officeId")
})

@Entity
@Table(name = "office_phone", schema = "office")
public class OfficePhone extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private String number;
	private String type;
	private Integer officeId;
	
	/**
	 * Get the number.
	 *
	 * @return The number.
	 */
	@javax.persistence.Column(name = "number")
	public String  getNumber() {
		return number;
	}

	/**
	 * Set the number.
	 *
	 * @param data The number.
	 */
	public void setNumber(String number) {
		this.number = number;
	}
	
	/**
	 * Get the type.
	 *
	 * @return The type.
	 */
	@javax.persistence.Column(name = "type")
	public String  getType() {
		return type;
	}

	/**
	 * Set the number.
	 *
	 * @param data The number.
	 */
	public void setType(String type) {
		this.type = type;
	}

	/**
	 * Get the officeId.
	 *
	 * @return The officeId.
	 */
	@javax.persistence.Column(name = "office_id")
	public Integer getOfficeId() {
		return officeId;
	}

	/**
	 * Set the officeId.
	 *
	 * @param filename The officeId.
	 */
	public void setOfficeId(Integer officeId) {
		this.officeId = officeId;
	}

}
