/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.gui;

import lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;

/**
 * a renderer for Physician objects in comboboxes
 *
 * @author Nico MACK
 * 
 * @version
 * <br>$Log$
 * <br>Revision 1.6  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.5  2008-01-15 13:08:50  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************
public class PhysicianComboBoxRenderer extends DefaultComboBoxRenderer
{
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
    private static final long serialVersionUID = 1L;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public PhysicianComboBoxRenderer ()
	{
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

/* (non-Javadoc)
 * @see lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer#getRenderString(java.lang.Object)
 */
protected String getRenderString (Object p_Object)
    {
    Physician l_Physician;
    String	 l_Rendered;
    
    l_Rendered = "";
    
    if (p_Object instanceof Physician)
    		{
    		l_Physician = (Physician) p_Object;
    		l_Rendered = l_Physician.toString();
    		}
    else l_Rendered = "Not a physician";
    
    return l_Rendered;
    }

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
