/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.office.gui.sitemanagement;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import lu.tudor.santec.gecamed.core.gui.widgets.LimitTextField;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.core.gui.widgets.PhoneField;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Site;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * JPanel to edit the general site data such as name, ucm, etc.
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: SiteGeneralPanel.java,v $
 * <br>Revision 1.1  2009-02-11 14:05:53  hermen
 * <br>added management of sites to the office admin tab
 * <br>
 *
 */
public class SiteGeneralPanel extends JPanel implements KeyListener
{
    //~ Static fields/initializers =============================================

    private static final long serialVersionUID = 1L;

    //~ Instance fields ========================================================

    public JTextField name;
    private SitePanel siteManagementPanel;
    private JTextArea information;
    private boolean isEnabled;
    private JTextField faxNumber;
    private JTextField phoneNumber;


    //~ Constructors ===========================================================

    public SiteGeneralPanel(SitePanel siteManagementPanel)
    {
    	this.setOpaque(false);
    	this.siteManagementPanel = siteManagementPanel;
        this.buildPanel();
    }

    //~ Methods ================================================================
    /**
     * gets the site from the panel
     */
    public void getData(Site site)
    {
    	site.setName(name.getText());
    	site.setInformation(information.getText());
	site.setPhone(this.phoneNumber.getText());
	site.setFax(this.faxNumber.getText());
    }

    /**
     * sets the site to the panel
     */
    public void setSite(Site site)
    {
            this.name.setText(site.getName());
            this.information.setText(site.getInformation());
            this.phoneNumber.setText(site.getPhone());
            this.faxNumber.setText(site.getFax());        
    }

    /**
     * adds the components to the panel
     */
    private void buildPanel()
    {
        // initialize components
        initComponents();

        FormLayout layout = new FormLayout(
        	"150dlu, 3dlu, 100dlu:grow",
        	"3dlu, top:pref, 3dlu, pref, 3dlu, pref");
        
        this.setLayout(layout);
        CellConstraints cc = new CellConstraints();

        this.add(new NamedComponent(Translatrix.getTranslationString(
        "office.name"), this.name), cc.xy(1, 2)); 
        
        this.add(new NamedComponent(Translatrix.getTranslationString("pm.phone"), this.phoneNumber), cc.xy(1,4)); 
        this.add(new NamedComponent(Translatrix.getTranslationString("pm.fax"), this.faxNumber), cc.xy(1,6)); 
        
        JScrollPane jsp = new JScrollPane(this.information);
        jsp.setOpaque(false);
        jsp.getViewport().setOpaque(false);
        this.add(new NamedComponent(Translatrix.getTranslationString(
        "office.information"),jsp), cc.xywh(3,2,1,5));
    }

    /**
     * initializes the Components
     */
    private void initComponents()
    {
        this.name = new LimitTextField(90);
        this.name.addKeyListener(this);
        this.information = new JTextArea(4, 70);
        this.information.addKeyListener(this);
        this.phoneNumber = new PhoneField(30);
        this.phoneNumber.addKeyListener(this);
        this.faxNumber = new PhoneField(30);
        this.faxNumber.addKeyListener(this);
    }
    
	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyTyped(java.awt.event.KeyEvent)
	 */
	public void keyTyped(KeyEvent e) {
		if (isEnabled)
			this.siteManagementPanel.setUnsavedChanges(true);
	}
	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyPressed(java.awt.event.KeyEvent)
	 */
	public void keyPressed(KeyEvent e) {
	}
	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
	 */
	public void keyReleased(KeyEvent e) {
	}

	/* (non-Javadoc)
	 * @see javax.swing.JComponent#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.isEnabled = enabled;
		this.name.setEditable(enabled);
		this.information.setEditable(enabled);
		super.setEnabled(enabled);
	}
	
}
