/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.util.Locale;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Entity Bean that maps the <b>patient.allergens</b> table
 * which stores a list of all available allergens
 *
 * @version
 * <br>$Log: Allergens.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-15 15:11:43  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@NamedQueries 
({
@NamedQuery(name = "getAllergens", query = "SELECT OBJECT(o) FROM Allergens o ORDER BY datasource DESC, nameEn ASC")
})


@Entity
@Table(name = "allergens", schema = "patient")
public class Allergens extends GECAMedEntityBean implements java.io.Serializable {

	// Fields    

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Integer groupid;
	private String code;
	private String nameEn;
	private String synonymsEn;
	private String descriptionEn;
	private String invasionEn;
	private String triggerEn;
	private String nameFr;
	private String synonymsFr;
	private String descriptionFr;
	private String invasionFr;
	private String triggerFr;
	private String nameDe;
	private String synonymsDe;
	private String descriptionDe;
	private String invasionDe;
	private String triggerDe;
	private String nameLatin;
	private String familyLatin;
	private String orderLatin;
	private Integer foodTypeid;
	private Short expositionFrom;
	private Short expositionTo;
	private Short clinicalRelevance;
	private Integer datasource;

	// Constructors

	/** default constructor */
	public Allergens() {
	}

	

	@Column(name = "groupid", unique = false, nullable = false, insertable = true, updatable = true)
	public Integer getGroupid() {
		return this.groupid;
	}

	public void setGroupid(Integer groupid) {
		this.groupid = groupid;
	}

	@Column(name = "code", unique = false, nullable = true, insertable = true, updatable = true, length = 50)
	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Column(name = "name_en", unique = false, nullable = false, insertable = true, updatable = true, length = 128)
	public String getNameEn() {
		return this.nameEn;
	}

	public void setNameEn(String nameEn) {
		this.nameEn = nameEn;
	}

	@Column(name = "synonyms_en", unique = false, nullable = true, insertable = true, updatable = true, length = 1500)
	public String getSynonymsEn() {
		return this.synonymsEn;
	}

	public void setSynonymsEn(String synonymsEn) {
		this.synonymsEn = synonymsEn;
	}

	@Column(name = "description_en", unique = false, nullable = true, insertable = true, updatable = true, length = 2000)
	public String getDescriptionEn() {
		return this.descriptionEn;
	}

	public void setDescriptionEn(String descriptionEn) {
		this.descriptionEn = descriptionEn;
	}

	@Column(name = "invasion_en", unique = false, nullable = true, insertable = true, updatable = true, length = 500)
	public String getInvasionEn() {
		return this.invasionEn;
	}

	public void setInvasionEn(String invasionEn) {
		this.invasionEn = invasionEn;
	}

	@Column(name = "trigger_en", unique = false, nullable = true, insertable = true, updatable = true, length = 500)
	public String getTriggerEn() {
		return this.triggerEn;
	}

	public void setTriggerEn(String triggerEn) {
		this.triggerEn = triggerEn;
	}
	
	
	
	@Column(name = "name_fr", unique = false, nullable = true, insertable = true, updatable = true, length = 128)
	public String getNameFr() {
		return this.nameFr;
	}

	public void setNameFr(String nameFr) {
		this.nameFr = nameFr;
	}

	@Column(name = "synonyms_fr", unique = false, nullable = true, insertable = true, updatable = true, length = 1500)
	public String getSynonymsFr() {
		return this.synonymsFr;
	}

	public void setSynonymsFr(String synonymsFr) {
		this.synonymsFr = synonymsFr;
	}

	@Column(name = "description_fr", unique = false, nullable = true, insertable = true, updatable = true, length = 2000)
	public String getDescriptionFr() {
		return this.descriptionFr;
	}

	public void setDescriptionFr(String descriptionFr) {
		this.descriptionFr = descriptionFr;
	}

	@Column(name = "invasion_fr", unique = false, nullable = true, insertable = true, updatable = true, length = 500)
	public String getInvasionFr() {
		return this.invasionFr;
	}

	public void setInvasionFr(String invasionFr) {
		this.invasionFr = invasionFr;
	}

	@Column(name = "trigger_fr", unique = false, nullable = true, insertable = true, updatable = true, length = 500)
	public String getTriggerFr() {
		return this.triggerFr;
	}

	public void setTriggerFr(String triggerFr) {
		this.triggerFr = triggerFr;
	}

	@Column(name = "name_de", unique = false, nullable = true, insertable = true, updatable = true, length = 128)
	public String getNameDe() {
		return this.nameDe;
	}

	public void setNameDe(String nameDe) {
		this.nameDe = nameDe;
	}

	@Column(name = "synonyms_de", unique = false, nullable = true, insertable = true, updatable = true, length = 1500)
	public String getSynonymsDe() {
		return this.synonymsDe;
	}

	public void setSynonymsDe(String synonymsDe) {
		this.synonymsDe = synonymsDe;
	}

	@Column(name = "description_de", unique = false, nullable = true, insertable = true, updatable = true, length = 2000)
	public String getDescriptionDe() {
		return this.descriptionDe;
	}

	public void setDescriptionDe(String descriptionDe) {
		this.descriptionDe = descriptionDe;
	}

	@Column(name = "invasion_de", unique = false, nullable = true, insertable = true, updatable = true, length = 500)
	public String getInvasionDe() {
		return this.invasionDe;
	}

	public void setInvasionDe(String invasionDe) {
		this.invasionDe = invasionDe;
	}

	@Column(name = "trigger_de", unique = false, nullable = true, insertable = true, updatable = true, length = 500)
	public String getTriggerDe() {
		return this.triggerDe;
	}

	public void setTriggerDe(String triggerDe) {
		this.triggerDe = triggerDe;
	}

	@Column(name = "name_latin", unique = false, nullable = true, insertable = true, updatable = true, length = 128)
	public String getNameLatin() {
		return this.nameLatin;
	}

	public void setNameLatin(String nameLatin) {
		this.nameLatin = nameLatin;
	}

	@Column(name = "family_latin", unique = false, nullable = true, insertable = true, updatable = true, length = 128)
	public String getFamilyLatin() {
		return this.familyLatin;
	}

	public void setFamilyLatin(String familyLatin) {
		this.familyLatin = familyLatin;
	}

	@Column(name = "order_latin", unique = false, nullable = true, insertable = true, updatable = true, length = 128)
	public String getOrderLatin() {
		return this.orderLatin;
	}

	public void setOrderLatin(String orderLatin) {
		this.orderLatin = orderLatin;
	}

	@Column(name = "food_typeid", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getFoodTypeid() {
		return this.foodTypeid;
	}

	public void setFoodTypeid(Integer foodTypeid) {
		this.foodTypeid = foodTypeid;
	}

	@Column(name = "exposition_from", unique = false, nullable = true, insertable = true, updatable = true)
	public Short getExpositionFrom() {
		return this.expositionFrom;
	}

	public void setExpositionFrom(Short expositionFrom) {
		this.expositionFrom = expositionFrom;
	}

	@Column(name = "exposition_to", unique = false, nullable = true, insertable = true, updatable = true)
	public Short getExpositionTo() {
		return this.expositionTo;
	}

	public void setExpositionTo(Short expositionTo) {
		this.expositionTo = expositionTo;
	}

	@Column(name = "clinical_relevance", unique = false, nullable = true, insertable = true, updatable = true)
	public Short getClinicalRelevance() {
		return this.clinicalRelevance;
	}

	public void setClinicalRelevance(Short clinicalRelevance) {
		this.clinicalRelevance = clinicalRelevance;
	}

	@Column(name = "datasource", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getDatasource() {
		return this.datasource;
	}

	public void setDatasource(Integer datasource) {
		this.datasource = datasource;
	}

	public String toString() {
		String l = Translatrix.getLocale().getLanguage().toLowerCase();
		try {
			if (l.startsWith("fr") && getNameFr() != null) {
				return getNameFr() + (getGroupid()!=null && (0<getGroupid() && getGroupid()<9) && getCode()!=null ?" [" + getCode() + "]":"") ;
			} else if (l.startsWith("de")) {
				return getNameDe() + (getGroupid()!=null && (0<getGroupid() && getGroupid()<9) && getCode()!=null ?" [" + getCode() + "]":"");
			} else {
				return getNameEn() + (getGroupid()!=null && (0<getGroupid() && getGroupid()<9) && getCode()!=null ?" [" + getCode() + "]":"");			
			}			
		} catch (Exception e) {
			return getNameEn();
		}
	}

	public String toInfoString() {
		StringBuffer sb = new StringBuffer("<html><b>");
		try {
			String l = Translatrix.getLocale().getLanguage().toLowerCase();
			if (l.startsWith("fr") && getNameFr() != null) {
				sb.append(getNameFr() + (getGroupid()!=null && (0<getGroupid() && getGroupid()<9) && getCode()!=null ?" [" + getCode() + "]":"") +  "</b>"); 
				sb.append((getSynonymsFr() != null ?getSynonymsFr() : "") + "<br>");
				sb.append("<span style=\"font-family:Arial;font-size:9px;\">" + (getDescriptionFr() != null ? getDescriptionFr() : ""));
				sb.append("<br>" + (getTriggerFr() != null ? getTriggerFr() : ""));
				sb.append("<br>" + (getInvasionFr() != null ? getInvasionFr() : ""));
			} else 
				if (l.startsWith("de")) {
					sb.append(getNameDe() + (getGroupid()!=null && (0<getGroupid() && getGroupid()<9) && getCode()!=null ?" [" + getCode() + "]":"") +  " </b>"); 
					sb.append((getSynonymsDe() != null ?getSynonymsDe() : "") + "<br>");
					sb.append("<span style=\"font-family:Arial;font-size:9px;\">" + (getDescriptionDe() != null ? getDescriptionDe() : ""));
					sb.append("<br>" + (getTriggerDe() != null ? getTriggerDe() : ""));
					sb.append("<br>" + (getInvasionDe() != null ? getInvasionDe() : ""));
				} else {
					sb.append(getNameEn() + (getGroupid()!=null && (0<getGroupid() && getGroupid()<9) && getCode()!=null ?" [" + getCode() + "]":"") +  " </b>"); 
					sb.append((getSynonymsEn() != null ?getSynonymsEn() : "") + "<br>");
					sb.append("<span style=\"font-family:Arial;font-size:9px;\">" + (getDescriptionEn() != null ? getDescriptionEn() : ""));
					sb.append("<br>" + (getTriggerEn() != null ? getTriggerEn() : ""));
					sb.append("<br>" + (getInvasionEn() != null ? getInvasionEn() : ""));
				}
		} catch (Exception e) {
			sb.append(getNameEn());
		}
		return sb.toString();
	}

	@Override
	public int compareTo(GECAMedEntityBean o) {
		if (o instanceof Allergens) {
			Allergens a = (Allergens) o;
			if (getDatasource().equals(a.getDatasource())) {
				String lang = Translatrix.getLocale().getLanguage();
				
				if (lang.startsWith("de")) {
					return getNameDe().compareTo(a.getNameDe());
				} else if (lang.startsWith("fr") && getNameFr() != null && a.getNameFr() != null) {
					return getNameFr().compareTo(a.getNameFr());
				} else {
					return getNameEn().compareTo(a.getNameEn());
				}
			} else {
				return a.getDatasource().compareTo(getDatasource());
			}
		} else {
			return super.compareTo(o);			
		}
		
	}
	
}
