/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;


@NamedQueries 
({
@NamedQuery(name = "getAllergiesByPatientID", query = "SELECT OBJECT(o) FROM Allergies o WHERE o.patientId = :patientID AND o.deletionDate IS NULL ORDER BY o.created DESC")
})

/**
 * Entity Bean that maps the <b>patient.allergies</b> table
 * which stores  the patients allergies
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: Allergies.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-07-21 10:27:12  hermen
 * <br>changed not nulls on Allergies and Antecedents
 * <br>
 * <br>Revision 1.2  2008-01-15 15:11:44  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@Entity
@Table(name = "allergies", schema = "patient")
public class Allergies extends GECAMedEntityBean implements Serializable {

	// Fields    

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private Integer patientId;
	private Integer allergenId = -1;
	private String comment;
	private Date created;
	private Integer createdBy;
	private Integer deletedBy;
	private Date deletionDate;
	private String allergenName;
	private String code;

	// Constructors

	/** default constructor */
	public Allergies() {
	}


	// Property accessors
	@Column(name = "patient_id", unique = false, nullable = false, insertable = true, updatable = true)
	public Integer getPatientId() {
		return this.patientId;
	}

	public void setPatientId(Integer patientId) {
		this.patientId = patientId;
	}

	@Column(name = "allergen_id", unique = false, nullable = false, insertable = true, updatable = true)
	public Integer getAllergenId() {
		return this.allergenId;
	}

	public void setAllergenId(Integer allergenId) {
		this.allergenId = allergenId;
	}
	
	@Column(name = "allergen_name", unique = false, nullable = true, insertable = true, updatable = true)
	public String getAllergenName() {
		return this.allergenName;
	}

	public void setAllergenName(String allergenName) {
		this.allergenName = allergenName;
	}
	
	@Column(name = "code")
	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	@Column(name = "comment", unique = false, nullable = true, insertable = true, updatable = true)
	public String getComment() {
		return this.comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	@Column(name = "created", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public Date getCreated() {
		return this.created;
	}

	public void setCreated(Date created) {
		this.created = created;
	}

	@Column(name = "created_by", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getCreatedBy() {
		return this.createdBy;
	}

	public void setCreatedBy(Integer createdBy) {
		this.createdBy = createdBy;
	}

	@Column(name = "deleted_by", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getDeletedBy() {
		return this.deletedBy;
	}

	public void setDeletedBy(Integer deletedBy) {
		this.deletedBy = deletedBy;
	}

	@Column(name = "deletion_date", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public Date getDeletionDate() {
		return this.deletionDate;
	}

	public void setDeletionDate(Date deletionDate) {
		this.deletionDate = deletionDate;
	}

}
