/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.core.utils.ManagerFactory;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.beans.LoginBean;
import lu.tudor.santec.gecamed.usermanagement.ejb.session.interfaces.LoginInterface;

/**
 * Entity Bean that maps the <b>patient.antecedents</b> table
 * which stores the patients antecedents
 *
 *
 * @version
 * <br>$Log: Antecedents.java,v $
 * <br>Revision 1.7  2011-10-04 14:12:20  troth
 * <br>fixed Ticket #903 - Copy-paste Mglichkeit fr Antezedenzen.
 * <br>
 * <br>Revision 1.6  2009-06-30 12:24:56  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-07-21 10:27:12  hermen
 * <br>changed not nulls on Allergies and Antecedents
 * <br>
 * <br>Revision 1.3  2008-07-04 15:49:32  heinemann
 * <br>omplete - # 134: Antecedents cacher
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/134
 * <br>
 * <br>Revision 1.2  2008-01-15 15:11:43  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@NamedQueries 
({
@NamedQuery(name = "getAntecedentsByPatientID", query = "SELECT OBJECT(o) FROM Antecedents o WHERE o.patientId = :patientID  AND o.deletedDate IS NULL " +
															" AND ((o.lockedBy IS NOT NULL AND o.lockedBy = :uid) OR o.lockedBy IS NULL) ORDER BY o.created DESC")
})

@Entity
@Table(name = "antecedents", schema = "patient")
public class Antecedents extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	private int patientId;
	private String shortcut = "";
	private String description;
	private Date created;
	private Integer createdBy;
	private Integer deletedBy;
	private Date deletedDate;
	private Integer lockedBy;

	// Constructors

	/** default constructor */
	public Antecedents() {
	}
	

	// Property accessors
	@Column(name = "patient_id", unique = false, nullable = false, insertable = true, updatable = true)
	public int getPatientId() {
		return this.patientId;
	}

	public void setPatientId(int patientId) {
		this.patientId = patientId;
	}

	@Column(name = "shortcut", unique = false, nullable = true, insertable = true, updatable = true, length = 250)
	public String getShortcut() {
		return this.shortcut;
	}

	public void setShortcut(String shortcut) {
		this.shortcut = shortcut;
	}

	@Column(name = "description", unique = false, nullable = true, insertable = true, updatable = true)
	public String getDescription() {
		return this.description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	@Column(name = "created", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public Date getCreated() {
		return this.created;
	}

	public void setCreated(Date created) {
		this.created = created;
	}

	@Column(name = "created_by", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getCreatedBy() {
		return this.createdBy;
	}

	public void setCreatedBy(Integer createdBy) {
		this.createdBy = createdBy;
	}

	@Column(name = "deleted_by", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getDeletedBy() {
		return this.deletedBy;
	}

	public void setDeletedBy(Integer deletedBy) {
		this.deletedBy = deletedBy;
	}

	@Column(name = "deleted_date", unique = false, nullable = true, insertable = true, updatable = true, length = 8)
	public Date getDeletedDate() {
		return this.deletedDate;
	}

	public void setDeletedDate(Date deletedDate) {
		this.deletedDate = deletedDate;
	}

	/**
	 * @return the lockedBy
	 */
	@Column(name = "locked_by", unique = false, nullable = true, insertable = true, updatable = true)
	public Integer getLockedBy() {
		return lockedBy;
	}

	/**
	 * @param lockedBy the lockedBy to set
	 */
	public void setLockedBy(Integer lockedBy) {
		this.lockedBy = lockedBy;
	}
	
	public String toString()
	{
		if(description != null)
		{
			String s = description.replaceAll("<head>","");
			LoginInterface loginManager = (LoginInterface) ManagerFactory.getRemote(LoginBean.class);
			
			DateFormat df = DateFormat.getDateInstance(DateFormat.SHORT );
		    
			String createdInfo = "";
			s = s.replaceAll("</head>","");	
			s = s.replaceAll("<html>","");
			s = s.replaceAll("</html>","");
			s = s.replaceAll("<body>","");
			s = s.replaceAll("</body>","");
			createdInfo = df.format(created) + " - " + loginManager.getUser(createdBy).getLogin();
			return "<html><b>" +  shortcut + "</b><hr>" + s + "<hr><p><small>" + createdInfo + "</small></p></html>";
		}else return "";
	}	
}