/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * Entity Bean that maps the <b>patient.hospitalisation_class</b> table
 * The Hospitalisation class represents the different hospitalisation classes
 * a patient can be in.
 * @author nmac
 * @created 06/04/26
 * 
 * @version
 * <br>$Log: HospitalisationClass.java,v $
 * <br>Revision 1.8  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.7  2011-10-19 13:39:18  ferring
 * <br>adding a new act, the act had the wrong hospitalisation class, if the hospitalisation class was changed after opening and before saving the invoice.
 * <br>This bug is fixes
 * <br>
 * <br>Revision 1.6  2011-10-18 13:10:09  ferring
 * <br>HospitalisationClass column added to the invoice editor table
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-03-11 13:26:27  mack
 * <br>Uses constants for named queries
 * <br>
 * <br>Revision 1.3  2008-01-15 15:11:43  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 */
@Entity
@Cache(usage = CacheConcurrencyStrategy.READ_ONLY) 
@Table(name = "hospitalisation_class", schema = "patient")

@javax.persistence.NamedQueries 
({
@NamedQuery(name = HospitalisationClass.c_AllClasses, 	  query = "SELECT OBJECT(o) FROM HospitalisationClass o"),
@NamedQuery(name = HospitalisationClass.c_ClassByAcronym,  query = "SELECT OBJECT(o) FROM HospitalisationClass o WHERE o.acronym = :acronym")
})

public class HospitalisationClass extends GECAMedEntityBean implements Serializable 
	{
	private static final long serialVersionUID = 1L;
	
	private String	m_Acronym;
	private String	m_Name;

//***************************************************************************
//* Constants                                                               *
//***************************************************************************	
	
	public static final transient String c_AllClasses 	  = "getAllHospitalisationClasses";
	public static final transient String c_ClassByAcronym = "getHospitalisationClassByAcronym";
	
	public static final transient String c_Ambulant 				= "A";
	public static final transient String c_FirstClass 				= "1";
	public static final transient String c_FirstClassSplittedCNS 	= "1C";
	public static final transient String c_FirstClassSplittedPrivate= "1P";
	public static final transient String c_SecondClass 				= "2";
	
	public static final transient double	c_FirstClassMajoration					= 1.66;
	public static final transient double	c_FirstClassSplittedCNSMajoration		= 1.00;
	public static final transient double	c_FirstClassSplittedPrivateMajoration	= 0.66;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************	
	
//***************************************************************************
//* Getter and Setter Methods	                                              *
//***************************************************************************	

//---------------------------------------------------------------------------
/**
 * Returns the acronym corresponding to this hospitalisation class
 * @return this hospitalisation class acronym
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="acronym")

public String getAcronym() 
	{
	return this.m_Acronym;
	}

//---------------------------------------------------------------------------
/**
 * Sets this hospitalisation class acronym to the specified value
 * @param p_Acronym specifies the value to set this hospitalisation class acronym to.
 */
//---------------------------------------------------------------------------

public void setAcronym (String p_Acronym) 
	{
	this.m_Acronym = p_Acronym;
	}

//---------------------------------------------------------------------------
/**
 * @return Returns the full name of this hospitalisation class
 */
//---------------------------------------------------------------------------

@javax.persistence.Column (name ="name")

public String getName() 
	{
	return this.m_Name;
	}

//---------------------------------------------------------------------------
/**
 * Sets the full name of this hospitalisation class
 * @param p_Name specifies the new name for this hospitalisation class.
 */
//---------------------------------------------------------------------------

public void setName (String p_Name) 
	{
	this.m_Name = p_Name;
	}


@Override
public String toString() 
	{
	return this.getAcronym();
	}


//***************************************************************************
//* End of Class															*
//***************************************************************************
}
