/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

/**
 * Entity Bean that maps the <b>patient.hospitalisation_period</b> table
 * The HospitalisationPeriod class represents one single hospitalisation period
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 * 
 * @version
 * <br>$Log: HospitalisationPeriod.java,v $
 * <br>Revision 1.13  2011-11-16 13:34:19  ferring
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.12  2008-10-07 09:33:30  heinemann
 * <br>GECAMedEntityBean now implements Comparable
 * <br>
 * <br>Revision 1.11  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.10  2008-01-15 15:11:43  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 */
@javax.persistence.NamedQueries 
({
@NamedQuery(name = "getAllHospitalisationPeriods", 				 query = "SELECT OBJECT(o) FROM HospitalisationPeriod o"),
@NamedQuery(name = "getAllHospitalisationPeriodsByHospitalisation",  query = "SELECT OBJECT(o) FROM HospitalisationPeriod o WHERE o.hospitalisation = :hospitalisation ORDER BY o.startDate, o.id ASC"),
@NamedQuery(name = "getLatestHospitalisationPeriod",  				query = "SELECT OBJECT(o) FROM HospitalisationPeriod o WHERE o.hospitalisation = :hospitalisation ORDER BY o.startDate, o.id  DESC"),
@NamedQuery(name = "getHospitalisationPeriodByStartDate",  			query = "SELECT OBJECT(o) FROM HospitalisationPeriod o WHERE o.hospitalisation = :hospitalisation AND o.startDate = :startdate")
})

@Entity
@Table(name = "hospitalisation_period", schema = "patient")
public class HospitalisationPeriod extends GECAMedEntityBean  implements Serializable {
	private static final long serialVersionUID = 1L;
	
	
	private String description;

	private Hospitalisation hospitalisation;

	private HospitalisationStatus hospitalisationStatus;

	private HospitalisationClass hospitalisationClass;

	private Date startDate;

	private Date endDate;

	private HospitalDepartment hospitalDepartment;

	private String hospitalBed;
	
	private Set<Passage> passages;

	private Set<HospitalPrescription> prescriptions;

	/**
	 * @return Returns the hospitalisationClass.
	 */
	@ManyToOne
	@JoinColumn(name = "hospitalisation_class_id", referencedColumnName = "id")
	public HospitalisationClass getHospitalisationClass() {
		return hospitalisationClass;
	}

	/**
	 * @param hospitalisationClass
	 *            The hospitalisationClass to set.
	 */
	public void setHospitalisationClass(
			HospitalisationClass hospitalisationClass) {
		this.hospitalisationClass = hospitalisationClass;
	}

	/**
	 * @return Returns the start date.
	 */
	@Column(name = "start_date")
	public Date getStartDate() {
		return this.startDate;
	}

	/**
	 * @param startDate
	 *            The startDate to set.
	 */
	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	/**
	 * @return Returns the end date.
	 */
	@Column(name = "end_date")
	public Date getEndDate() {
		return this.endDate;
	}

	/**
	 * @param endDate
	 *            The endDate to set.
	 */
	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	/**
	 * @return Returns the hospitalBed.
	 */
	@Column(name = "hospital_bed")
	public String getHospitalBed() {
		return hospitalBed;
	}

	/**
	 * @param hospitalBed
	 *            The hospitalBed to set.
	 */
	public void setHospitalBed(String hospitalBed) {
		this.hospitalBed = hospitalBed;
	}

	/**
	 * @return Returns the hospitalDepartment.
	 */
	@ManyToOne
	@JoinColumn(name = "hospital_department_id", referencedColumnName = "id")
	public HospitalDepartment getHospitalDepartment() {
		return hospitalDepartment;
	}

	/**
	 * @param hospitalDepartment
	 *            The hospitalDepartment to set.
	 */
	public void setHospitalDepartment(HospitalDepartment hospitalDepartment) {
		this.hospitalDepartment = hospitalDepartment;
	}

	/**
	 * @return Returns the hospitalisationStatus.
	 */
	@ManyToOne
	@JoinColumn(name = "hospitalisation_status_id", referencedColumnName = "id")
	public HospitalisationStatus getHospitalisationStatus() {
		return hospitalisationStatus;
	}

	/**
	 * @param hospitalisationStatus
	 *            The hospitalisationStatus to set.
	 */
	public void setHospitalisationStatus(
			HospitalisationStatus hospitalisationStatus) {
		this.hospitalisationStatus = hospitalisationStatus;
	}

	/**
	 * @return Returns the hospitalisation.
	 */
	@ManyToOne
	@JoinColumn(name = "hospitalisation_id", referencedColumnName = "id")
	public Hospitalisation getHospitalisation() {
		return hospitalisation;
	}

	/**
	 * @param hospitalisation
	 *            The hospitalisation to set.
	 */
	public void setHospitalisation(Hospitalisation hospitalisation) {
		this.hospitalisation = hospitalisation;
	}

	/**
	 * @return Returns the description.
	 */
	@Column(name = "description")
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	// ***************************************************************************
	//* End of Class															*
	//***************************************************************************
	
	public int compareTo(GECAMedEntityBean o) {
		try {
			if (this.getStartDate().before(((HospitalisationPeriod)o).getStartDate())) {
				return -1;
			}	
		} catch (Exception e) {
		}
		return 1;
	}

	/**
	 * @return Returns the passages.
	 */
	@OneToMany(cascade = javax.persistence.CascadeType.ALL, fetch = javax.persistence.FetchType.EAGER)
	@JoinColumn(name = "hospperiod_id")
	@OrderBy("date DESC")
	public Set<Passage> getPassages() {
		return passages;
	}

	/**
	 * @param passages The passages to set.
	 */
	public void setPassages(Set<Passage> passages) {
		this.passages = passages;
	}
	
	/**
	 * @return Returns the orders.
	 */
	@OneToMany(cascade = javax.persistence.CascadeType.ALL, fetch = javax.persistence.FetchType.EAGER)
	@JoinColumn(name = "hospperiod_id")
	@OrderBy("date DESC")
	public Set<HospitalPrescription> getPrescriptions() {
		return prescriptions;
	}

	/**
	 * @param orders The orders to set.
	 */
	public void setPrescriptions(Set<HospitalPrescription> prescriptions) {
		this.prescriptions = prescriptions;
	}
}
