/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: IncidentEntry.java,v $
 * <br>Revision 1.27  2014-01-17 11:48:08  ferring
 * <br>Files are now attached correctly, with original file name and can be uploaded again
 * <br>
 * <br>Revision 1.26  2013-12-12 13:27:58  ferring
 * <br>logging exception
 * <br>
 * <br>Revision 1.25  2013-11-28 10:38:25  ferring
 * <br>GECAMedUtils split into utils and GUI utils classes
 * <br>
 * <br>Revision 1.24  2013-11-14 18:17:17  donak
 * <br>Fixed versioning issue between JODConverter (Java 1.6) and JBOSS (Java 1.5). Server-side PDF ==> PDF/A conversion should work now.
 * <br>Fixed IncidentEntry getBinaryContent(). Now a call to this functions always provides the binary content of an incident entry, if any. function works on client and server side.
 * <br>Implemented function to update incident entry upload status w/o updating all bean properties.
 * <br>Fixed issue with retrieving default user inactivity logout delay from database
 * <br>
 * <br>Revision 1.23  2013-11-12 12:48:22  donak
 * <br>Document upload:
 * <br>* conversion to pdf/a using open office has been moved to the server. OpenOffice 4 has to be located in the jboss work directory. ATTENTION: it still has to be evaluated if the license agreement dialog occurs when instance is started the first time on the server.
 * <br>* If document contains a description, the first forty characters of the description followed by three dots will be used as title instead of the filename
 * <br>* Upload of incident type letters has been fixed
 * <br>* upload for docx files has been added
 * <br>
 * <br>Upload parameters:
 * <br>* database does now support storage of user dependent properties
 * <br>* The system will automatically remember the last chosen values for confidentiality, facility type, and speciality and propose them as default when the next document will be uploaded.
 * <br>
 * <br>Inactivity Monitor:
 * <br>* the event mouse wheel scrolling is now taken into account for resetting the logoff timer
 * <br>* the logoff delay is now stored in the database. If the database does not contain this parameter, it will be created
 * <br>
 * <br>General:
 * <br>* Optimized incident entry bean handling. Caching will now avoid copying the binary content and the generated pdf content of an incident entry as these elements should only be loaded when needed. Now it should be save to re-implement a proper getBinaryContent() handling.
 * <br>
 * <br>Revision 1.22  2013-10-29 09:45:27  troth
 * <br>The new consultation view with more entries and the sickleave version 3 fix several bugs.
 * <br>
 * <br>Revision 1.21  2013-10-11 16:50:09  donak
 * <br>Added pdf conversion support for all remaining file types (open office, ms office, flash, rtf). New office file types (docx, etc.) are not yet supported. An open office installation on the client system is necessary to make the new feature work.
 * <br>
 * <br>Revision 1.20  2013-10-10 16:31:35  donak
 * <br>Started to add eSanté "uploaded" indicators to incident entries
 * <br>
 * <br>Revision 1.19  2013-10-10 13:31:16  ferring
 * <br>generated binary PDF content added
 * <br>
 * <br>Revision 1.18  2013-10-10 11:28:50  donak
 * <br>Integration of cda unique document id is now persistent context menu now adapts to the upload status of a document
 * <br>
 * <br>Revision 1.16  2013-09-30 11:44:09  donak
 * <br>eSant� upload integration
 * <br>
 * <br>Revision 1.15  2013-02-05 13:15:18  ferring
 * <br>letter status added
 * <br>
 * <br>Revision 1.14  2012-01-24 10:22:27  ferring
 * <br>Native Queries to Named Queries
 * <br>
 * <br>Revision 1.13  2010-10-14 09:51:16  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.12  2009-05-06 15:59:50  heinemann
 * <br>fixed unused compareTo method. is now used for sorting in the patient history
 * <br>
 * <br>Revision 1.11  2008-10-07 09:33:30  heinemann
 * <br>GECAMedEntityBean now implements Comparable
 * <br>
 * <br>Revision 1.10  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.9  2008-07-21 14:06:03  hermen
 * <br>implemented toString
 * <br>
 * <br>Revision 1.8  2008-05-27 14:13:08  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2008-04-10 14:19:30  heinemann
 * <br>added original filename o the IncidentEntry table.
 * <br>differs to filename which is the generated name of the timestamp+originalfilename
 * <br>
 * <br>Revision 1.6  2008-04-09 12:53:59  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.5  2008-03-28 14:56:36  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-03-10 12:37:52  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2007-11-26 10:13:22  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2007-11-21 15:17:23  heinemann
 * <br>checkin without warranty!!
 * <br>
 * <br>Revision 1.1  2007-10-16 08:23:26  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;
import lu.tudor.santec.gecamed.prescription.ejb.session.interfaces.PrescriptionManager;

/**
 * @author martin.heinemann@tudor.lu 11.10.2007 17:02:22
 * 
 * 
 * @version <br>
 *          $Log: IncidentEntry.java,v $
 *          Revision 1.27  2014-01-17 11:48:08  ferring
 *          Files are now attached correctly, with original file name and can be uploaded again
 *
 *          Revision 1.26  2013-12-12 13:27:58  ferring
 *          logging exception
 *
 *          Revision 1.25  2013-11-28 10:38:25  ferring
 *          GECAMedUtils split into utils and GUI utils classes
 *
 *          Revision 1.24  2013-11-14 18:17:17  donak
 *          Fixed versioning issue between JODConverter (Java 1.6) and JBOSS (Java 1.5). Server-side PDF ==> PDF/A conversion should work now.
 *          Fixed IncidentEntry getBinaryContent(). Now a call to this functions always provides the binary content of an incident entry, if any. function works on client and server side.
 *          Implemented function to update incident entry upload status w/o updating all bean properties.
 *          Fixed issue with retrieving default user inactivity logout delay from database
 *
 *          Revision 1.23  2013-11-12 12:48:22  donak
 *          Document upload:
 *          * conversion to pdf/a using open office has been moved to the server. OpenOffice 4 has to be located in the jboss work directory. ATTENTION: it still has to be evaluated if the license agreement dialog occurs when instance is started the first time on the server.
 *          * If document contains a description, the first forty characters of the description followed by three dots will be used as title instead of the filename
 *          * Upload of incident type letters has been fixed
 *          * upload for docx files has been added
 *
 *          Upload parameters:
 *          * database does now support storage of user dependent properties
 *          * The system will automatically remember the last chosen values for confidentiality, facility type, and speciality and propose them as default when the next document will be uploaded.
 *
 *          Inactivity Monitor:
 *          * the event mouse wheel scrolling is now taken into account for resetting the logoff timer
 *          * the logoff delay is now stored in the database. If the database does not contain this parameter, it will be created
 *
 *          General:
 *          * Optimized incident entry bean handling. Caching will now avoid copying the binary content and the generated pdf content of an incident entry as these elements should only be loaded when needed. Now it should be save to re-implement a proper getBinaryContent() handling.
 *
 *          Revision 1.22  2013-10-29 09:45:27  troth
 *          The new consultation view with more entries and the sickleave version 3 fix several bugs.
 *
 *          Revision 1.21  2013-10-11 16:50:09  donak
 *          Added pdf conversion support for all remaining file types (open office, ms office, flash, rtf). New office file types (docx, etc.) are not yet supported. An open office installation on the client system is necessary to make the new feature work.
 *
 *          Revision 1.20  2013-10-10 16:31:35  donak
 *          Started to add eSanté "uploaded" indicators to incident entries
 *
 *          Revision 1.19  2013-10-10 13:31:16  ferring
 *          generated binary PDF content added
 *
 *          Revision 1.18  2013-10-10 11:28:50  donak
 *          Integration of cda unique document id is now persistent context menu now adapts to the upload status of a document
 * Revision 1.16 2013-09-30 11:44:09 donak
 *          eSant� upload integration <br>
 *          Revision 1.15 2013-02-05 13:15:18 ferring <br>
 *          letter status added <br>
 * <br>
 *          Revision 1.14 2012-01-24 10:22:27 ferring <br>
 *          Native Queries to Named Queries <br>
 * <br>
 *          Revision 1.13.2.1 2012-01-20 09:13:53 ferring <br>
 *          BRANCHED VERSION <br>
 * <br>
 *          Revision 1.13 2010-10-14 09:51:16 hermen <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.12 2009-05-06 15:59:50 heinemann <br>
 *          fixed unused compareTo method. is now used for sorting in the
 *          patient history <br>
 * <br>
 *          Revision 1.11 2008-10-07 09:33:30 heinemann <br>
 *          GECAMedEntityBean now implements Comparable <br>
 * <br>
 *          Revision 1.10 2008-09-25 09:43:06 heinemann <br>
 *          fixed copyrights <br>
 * <br>
 *          Revision 1.9 2008-07-21 14:06:03 hermen <br>
 *          implemented toString <br>
 * <br>
 *          Revision 1.8 2008-05-27 14:13:08 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.7 2008-04-10 14:19:30 heinemann <br>
 *          added original filename o the IncidentEntry table. <br>
 *          differs to filename which is the generated name of the
 *          timestamp+originalfilename <br>
 * <br>
 *          Revision 1.6 2008-04-09 12:53:59 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.5 2008-03-28 14:56:36 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.4 2008-03-10 12:37:52 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.3 2007-11-26 10:13:22 heinemann <br>
 *          *** empty log message *** <br>
 * <br>
 *          Revision 1.2 2007-11-21 15:17:23 heinemann <br>
 *          checkin without warranty!! <br>
 * <br>
 *          Revision 1.1 2007-10-16 08:23:26 heinemann <br>
 *          *** empty log message *** <br>
 * 
 */

@NamedQueries({
		@NamedQuery(name = IncidentEntry.DELETE_ORPHAN_ENTRIES, query = "SELECT OBJECT(o) FROM IncidentEntry o WHERE o.incidentId IS NULL"),
		@NamedQuery(name = IncidentEntry.GET_INCIDENT_ENTRY_TYPES, query = "SELECT OBJECT(o) FROM IncidentEntryType o"),
		@NamedQuery(name = IncidentEntry.GET_INCIDENT_ENTRY_TYPE_BY_NAME, query = "SELECT OBJECT(o) FROM IncidentEntryType o "
				+ "WHERE UPPER(o.name) = UPPER(:name)"),
		@NamedQuery(name = IncidentEntry.GET_INCIDENT_ENTRY_TYPE_BY_NAME_AND_MIME, query = "SELECT OBJECT(o) FROM IncidentEntryType o "
				+ "WHERE UPPER(o.name) = UPPER(:name) " + "AND UPPER(o.mimeType) = UPPER(:mime)"),
		@NamedQuery(name = IncidentEntry.GET_INCIDENT_ENTRY_IDS, query = "SELECT presc.incidentEntryId " + "FROM Prescription presc "
				+ "GROUP BY presc.incidentEntryId " + "HAVING COUNT(presc.incidentEntryId) > 1"),
		@NamedQuery(name = IncidentEntry.GET_INCIDENT_ENTRY_IDS_WITHOUT_INCIDENT, query = "SELECT ie.id " + "FROM IncidentEntry ie "
				+ "WHERE ie.incidentId = null"),
		@NamedQuery(name = IncidentEntry.SET_UPLOAD_INDICATOR, query = "UPDATE IncidentEntry ie SET ie.cdaUniqueId = :cdaUniqueId WHERE ie.id = :incidentEntryId") })

@Entity
@Table(name = "incident_entry", schema = "patient")
public class IncidentEntry extends GECAMedEntityBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	public static final String GET_INCIDENT_ENTRY_TYPES = "getIncidentTypes";
	public static final String GET_INCIDENT_ENTRY_TYPE_BY_NAME = "getIncidentEntryTypesByName";
	public static final String GET_INCIDENT_ENTRY_TYPE_BY_NAME_AND_MIME = "getIncidentEntryTypesByNameAndMime";
	public static final String GET_INCIDENT_ENTRY_IDS = "getIncidentEntryTypes";
	public static final String SET_UPLOAD_INDICATOR = "setCdaUniqueId";
	public static final String GET_INCIDENT_ENTRY_IDS_WITHOUT_INCIDENT = "getIncidentEntryTypesWithoutIncident";
	public static final String DELETE_ORPHAN_ENTRIES = "deleteOrphanEntries";

	public static final String ENTRY_NAME = "entry_name";
	
	/** the logger Object for this class */
//	private static Logger logger = Logger.getLogger(IncidentEntry.class.getName());

	private Integer entryTypeId;
	private IncidentEntryType entryType;

	private Integer incidentId;
	private Incident incident;

	private String textContent;
	private String code;
	private String status;
	private Date created;
	private Integer createdBy;
	private Date modified;
	private Integer modifiedBy;
	private Date entryDate;
	private String fileName;
	private String originalFilename;
	private Integer weight;
	private Long fileSize;
	private byte[] binaryContent;
	private String cdaUniqueId;
	
	// transient members
	private transient byte[] generatedPdfContent;
	
	private Date sickLeaveStartDate;
	private Date sickLeaveEndDate;

//	private static Logger logger = Logger.getLogger(IncidentEntry.class.getName());

	private static HashMap<String, Integer> sortMapping = new HashMap<String, Integer>();

	static {
		/* ================================================== */
		sortMapping.put(IncidentManager.ACCIDENT, IncidentEntryType.ACCIDENT);
		sortMapping.put(IncidentManager.SOAP_S, IncidentEntryType.SOAP_S);
		sortMapping.put(IncidentManager.SOAP_O, IncidentEntryType.SOAP_O);
		sortMapping.put(IncidentManager.SOAP_A, IncidentEntryType.SOAP_A);
		sortMapping.put(IncidentManager.SOAP_P, IncidentEntryType.SOAP_P);
		sortMapping.put(PrescriptionManager.ENTRY_TYPE, IncidentEntryType.PRESCRIPTION);
		sortMapping.put(IncidentManager.MEASUREMENT, IncidentEntryType.MEASUREMENT);
		sortMapping.put(IncidentManager.FILE, IncidentEntryType.FILE);
		/* ================================================== */
	}

	public IncidentEntry() {
		/* ================================================== */
		
		/* ================================================== */
	}

	/**
	 * @param e
	 * @throws IntrospectionException
	 */
	public IncidentEntry(IncidentEntry e) {
		super();

		try {
			BeanInfo beanInfo = Introspector.getBeanInfo(this.getClass());
			PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
			for (PropertyDescriptor descriptor : descriptors) {
				// exclude the following attributes as they should only be loaded on demand
				if (("generatedPdfContent".equals(descriptor.getName())) || ("binaryContent".equals(descriptor.getName()))) {
					continue;
				} 
				
				Method getter = descriptor.getReadMethod();
				Method setter = descriptor.getWriteMethod();

				if (getter != null && setter != null) {
					setter.invoke(this, getter.invoke(e));
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	// public IncidentEntry(Integer entryTypeId) {
	// /* ================================================== */
	// this.setEntryTypeId(entryTypeId);
	// /* ================================================== */
	// }

	public IncidentEntry(String entryTypeName) {
		/* ================================================== */
		IncidentEntryType t = new IncidentEntryType();
		t.setName(entryTypeName);
		this.setEntryType(t);

		// try {
		// this.setProperty(ENTRY_NAME, String.class, entryTypeName);
		// } catch (Exception e) {
		// e.printStackTrace();
		// }
		/* ================================================== */
	}

	@ManyToOne
	@JoinColumn(name = "incident_id")
	public Incident getIncident() {
		/* ====================================================== */
		return this.incident;
		/* ====================================================== */
	}

	public void setIncident(Incident incident) {
		/* ====================================================== */
		this.incident = incident;
		/* ====================================================== */
	}

	/**
	 * Provides the binary content of the file.<br>
	 * If the binary is not yet present, it will first be loaded from the server.
	 * 
	 * @return The file that belongs to the incident entry or null if the incident entry does not possess a file (e.g. if it only contains database values). The
	 *         binary content can also be explicitly set and will than be returned by a call to this function, even if the incident type does not support binary
	 *         content.
	 */
	@Transient
	public byte[] getBinaryContent() {

		// DONT'T DO THAT !!!
		
		// if the content is not yet available, try loading it but only do this for files as database entries do not possess binary content
		// find the relevant filename
//		String filename;
//		if (IncidentManager.LETTER.equals(entryType.getName()))
//			filename = this.originalFilename;
//		else 
//			filename = this.fileName;
//		
//		if ((binaryContent == null) && (filename != null)) {
//			try {
//				IncidentManager iManager = (IncidentManager) ManagerFactory.getRemote(IncidentManagerBean.class);
//				IncidentEntry ie = iManager.loadBinary(this);
//				binaryContent = ie.getBinaryContent();
//				
//				setFileSize((long) binaryContent.length);
//			} catch (Exception ex) {
//				logger.error("Couldn't load binary content for IncidentEntry " + getId(), ex);
//			}
//		}
		
		return binaryContent;
	}

	/**
	 * @param binaryContent
	 *            the binaryContent to set
	 */
	public void setBinaryContent(byte[] binaryContent) {
		this.binaryContent = binaryContent;
	}

	/**
	 * @return the code
	 */
	@Column(name = "code")
	public String getCode() {
		return code;
	}

	/**
	 * @param code
	 *            the code to set
	 */
	public void setCode(String code) {
		this.code = code;
	}

	/**
	 * @return the status
	 */
	@Column(name = "status")
	public String getStatus() {
		return status;
	}

	/**
	 * @param status
	 *            the status to set
	 */
	public void setStatus(String status) {
		this.status = status;
	}

	/**
	 * @return the entryTypeId
	 */
	@Column(name = "entry_type_id")
	public Integer getEntryTypeId() {
		return entryTypeId;
	}

	/**
	 * @param entryTypeId
	 *            the entryTypeId to set
	 */
	public void setEntryTypeId(Integer entryTypeId) {
		this.entryTypeId = entryTypeId;
	}

	/**
	 * @return the entryType
	 */
	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "entry_type_id", updatable = false, insertable = false)
	public IncidentEntryType getEntryType() {
		return entryType;
	}

	/**
	 * @param entryType
	 *            the entryType to set
	 */
	public void setEntryType(IncidentEntryType entryType) {
		this.entryType = entryType;
	}

	/**
	 * @return the incidentId
	 */
	@Column(name = "incident_id", insertable = false, updatable = false)
	public Integer getIncidentId() {
		return incidentId;
	}

	/**
	 * @param incidentId
	 *            the incidentId to set
	 */
	public void setIncidentId(Integer incidenId) {
		this.incidentId = incidenId;
	}

	/**
	 * @return the textContent
	 */
	@Column(name = "text_content")
	public String getTextContent() {
		return textContent;
	}

	/**
	 * @param textContent
	 *            the textContent to set
	 */
	public void setTextContent(String textContent) {
		this.textContent = textContent;
	}

	/**
	 * @return the Creation Date of the incident Entry
	 */
	@Column(name = "created")
	public Date getCreated() {
		return created;
	}

	/**
	 * @param created the created to set
	 */
	public void setCreated(Date created) {
		this.created = created;
	}

	/**
	 * @return The GECAMed USER who created this entry
	 */
	@Column(name = "created_by")
	public Integer getCreatedBy() {
		return createdBy;
	}

	/**
	 * @param createdBy The GECAMed USER who created this entry
	 */
	public void setCreatedBy(Integer createdBy) {
		this.createdBy = createdBy;
	}

	/* ------------------------------------------------------- */

	/**
	 * @return
	 */
	@Column(name = "modified")
	public Date getModified() {
		return modified;
	}

	/**
	 * @param modified
	 */
	public void setModified(Date modified) {
		this.modified = modified;
	}

	/**
	 * @return The GECAMed USER who modified this entry
	 */
	@Column(name = "modified_by")
	public Integer getModifiedBy() {
		return modifiedBy;
	}

	/**
	 * @param modifiedBy The GECAMed USER who modified this entry
	 */
	public void setModifiedBy(Integer modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	/* ------------------------------------------------------- */
	/**
	 * @return the entryDate
	 */
	@Column(name = "entry_date")
	public Date getEntryDate() {
		return entryDate;
	}

	/**
	 * @param entryDate
	 *            the entryDate to set
	 */
	public void setEntryDate(Date entryDate) {
		this.entryDate = entryDate;
	}

	/**
	 * Provides the file name of an incident entry that represents a file
	 * 
	 * @return the fileName or null if the incident entry does not represent a file.
	 */
	@Column(name = "filename")
	public String getFileName() {
		// double check to assure that the function always returns null for a missing file name - even if somebody messed up the db.
		return ((fileName == null) || (fileName.length() > 0) ? fileName : null);
	}

	/**
	 * @param fileName
	 *            the fileName to set
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * @return the originalFilename
	 */
	@Column(name = "original_filename")
	public String getOriginalFilename() {
		return originalFilename;
	}

	/**
	 * @param originalFilename
	 *            the originalFilename to set
	 */
	public void setOriginalFilename(String originalFilename) {
		this.originalFilename = originalFilename;
	}

	/**
	 * @return the fileSize
	 */
	@Column(name = "filesize")
	public Long getFileSize() {
		return fileSize;
	}

	/**
	 * @param fileSize
	 *            the fileSize to set
	 */
	public void setFileSize(Long fileSize) {
		this.fileSize = fileSize;
	}

	/**
	 * @return the weight
	 */
	@Column(name = "weight")
	public Integer getWeight() {
		return weight;
	}

	/**
	 * Defines the order of the incident in the incident list. The following priorities are available (in descending order):<br/>
	 * <ul>
	 * <li>{@link IncidentEntryType#Letter}</li>
	 * <li>{@link IncidentEntryType#UNKNOWN}</li>
	 * <li>{@link IncidentEntryType#FILE}</li>
	 * <li>{@link IncidentEntryType#PRESCRIPTION}</li>
	 * <li>{@link IncidentEntryType#SOAP_P}</li>
	 * <li>{@link IncidentEntryType#SOAP_A}</li>
	 * <li>{@link IncidentEntryType#MEASUREMENT}</li>
	 * <li>{@link IncidentEntryType#SOAP_O}</li>
	 * <li>{@link IncidentEntryType#SOAP_S}</li>
	 * <li>{@link IncidentEntryType#ACCIDENT}</li>
	 * </ul>
	 * @param weight
	 *            the weight to set
	 */
	public void setWeight(Integer weight) {
		this.weight = weight;
	}
	
	/**
	 * @return the sick leave start date
	 */
	@Column(name="sick_leave_start_date")
	public Date getSickLeaveStartDate() {
		return sickLeaveStartDate;
	}

	/**
	 * @param sickLeaveStartDate the start date to set
	 */
	public void setSickLeaveStartDate(Date sickLeaveStartDate) {
		this.sickLeaveStartDate = sickLeaveStartDate;
	}
	
	/**
	 * @return the sick leave end date
	 */
	@Column(name="sick_leave_end_date")
	public Date getSickLeaveEndDate() {
		return sickLeaveEndDate;
	}

	/**
	 * @param sickLeaveEndDate the end date to set
	 */
	public void setSickLeaveEndDate(Date sickLeaveEndDate) {
		this.sickLeaveEndDate = sickLeaveEndDate;
	}

	/**
	 * Provides the unique id that has been assigned to the document when it has
	 * been uploaded to the eSanté DSP of the patient
	 * 
	 * @return The unique id of the document
	 */
	@Column(name = "cda_unique_id")
	public String getCdaUniqueId() {
		return this.cdaUniqueId;
	}

	/**
	 * Sets the unique id that has been assigned to the document when it has
	 * been uploaded to the eSanté DSP of the patient
	 * 
	 * @param cdaUniqueId
	 *            The unique id of the document
	 */
	public void setCdaUniqueId(String cdaUniqueId) {
		this.cdaUniqueId = cdaUniqueId;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	@Override
	public int compareTo(GECAMedEntityBean obj) {
		/* ====================================================== */
		if (!(obj instanceof IncidentEntry))
			return super.compareTo(obj);
		/* ------------------------------------------------------- */
		IncidentEntry o = (IncidentEntry) obj;
		Integer weightA = sortMapping.get(this.entryType.getName());
		Integer weightB = sortMapping.get(o.getEntryType().getName());
		/* ------------------------------------------------------- */
		if (weightA == null)
			weightA = IncidentEntryType.UNKNOWN;
		if (weightB == null)
			weightB = IncidentEntryType.UNKNOWN;
		/* ------------------------------------------------------- */
		if ((weightA - weightB) != 0)
			return (weightA - weightB);

		return 0;
		/* ====================================================== */
	}

	public String toString() {
		return "Text: " + getTextContent() + " fileName: " + getFileName() + " fileSize:" + getFileSize();
	}
	
	
	@Transient
	public void setGeneratedPdfContent (byte[] data)
	{
		this.generatedPdfContent = data;
	}
	
	
	/**
	 * Provides the content of the incident entry in pdf/a format. If necessary, it will be converted at the GECAMed Server side first and transferred to the
	 * client afterwards. The converted content is currently not stored in the db<br>
	 * <br>
	 * <i>Please be aware that an Open Office installation at the GECAMed server is needed for accomplishing the conversion.</i>
	 * 
	 * @return The content of the incident entry in pdf/a format, respectively null if the conversion was not possible. In this case, the user is informed about
	 *         the reason via a GECAMed error dialog.
	 */
	@Transient
	public byte[] getGeneratedPdfContent ()
	{
		return this.generatedPdfContent;
	}
}
