/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: IncidentEntryType.java,v $
 * <br>Revision 1.10  2013-10-29 09:45:27  troth
 * <br>The new consultation view with more entries and the sickleave version 3 fix several bugs.
 * <br>
 * <br>Revision 1.9  2013-07-16 13:07:50  troth
 * <br>Fix Bug: Import Patient with a soap, form or file entry causes that the import created new entry types, because of the missing mine_type of the entry_type. Now the mine_type of a entry is set to the default mine_type 'text/plain'.
 * <br>
 * <br>Revision 1.8  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.7  2008-07-22 15:08:38  hermen
 * <br>added toDescriptionString()
 * <br>
 * <br>Revision 1.6  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.5  2008-05-27 14:13:08  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-03-27 12:34:26  weitz
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-03-10 12:37:52  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2007-11-21 15:17:23  heinemann
 * <br>checkin without warranty!!
 * <br>
 * <br>Revision 1.1  2007-10-16 08:23:26  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.swing.JTabbedPane;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.IncidentManager;

/**
 * @author martin.heinemann@tudor.lu
 * 11.10.2007
 * 17:02:56
 *
 *
 * @version
 * <br>$Log: IncidentEntryType.java,v $
 * <br>Revision 1.10  2013-10-29 09:45:27  troth
 * <br>The new consultation view with more entries and the sickleave version 3 fix several bugs.
 * <br>
 * <br>Revision 1.9  2013-07-16 13:07:50  troth
 * <br>Fix Bug: Import Patient with a soap, form or file entry causes that the import created new entry types, because of the missing mine_type of the entry_type. Now the mine_type of a entry is set to the default mine_type 'text/plain'.
 * <br>
 * <br>Revision 1.8  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.7  2008-07-22 15:08:38  hermen
 * <br>added toDescriptionString()
 * <br>
 * <br>Revision 1.6  2008-07-03 11:59:57  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.5  2008-05-27 14:13:08  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.4  2008-03-27 12:34:26  weitz
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-03-10 12:37:52  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2007-11-21 15:17:23  heinemann
 * <br>checkin without warranty!!
 * <br>
 * <br>Revision 1.1  2007-10-16 08:23:26  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
@Entity
@Table(name = "incident_entry_types", schema = "patient")
public class IncidentEntryType extends GECAMedEntityBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	 
//	public static final Integer TYPE_S = 1;
//	public static final Integer TYPE_O = 2;
//	public static final Integer TYPE_A = 3;
//	public static final Integer TYPE_P = 4;
	public static final String PRESCRIPTIONS = "M";
	public static final String FILES="F";
	public static final String LETTERS = "L";
	public static final String FORM = "Fm";
	public static final String LAB = "LAB";
	public static final String CDA = "CDA";
	public static final String DICOM = "DIC";
	
	
	
	public static final String TYPE_S = IncidentManager.SOAP_S;
	public static final String TYPE_O = IncidentManager.SOAP_O;
	public static final String TYPE_A = IncidentManager.SOAP_A;
	public static final String TYPE_P = IncidentManager.SOAP_P;
	public static final String TYPE_CONS_1 = IncidentManager.CONS_1;
	public static final String TYPE_CONS_2 = IncidentManager.CONS_2;
	public static final String TYPE_CONS_3 = IncidentManager.CONS_3;
	public static final String TYPE_SICK_LEAVE = IncidentManager.SICK_LEAVE;
	
	public static final String MIME_TEXT_PLAIN = "text/plain";
	
	public static final int ACCIDENT 		= 2;
	/** The "subjective" part of a soap (subjective, objective, assessment, and plan) note */
	public static final int SOAP_S 	 		= 3;
	/** The "objective" part of a soap (subjective, objective, assessment, and plan) note */
	public static final int SOAP_O   		= 4;
	public static final int MEASUREMENT 	= 5;
	/** The "assessment" part of a soap (subjective, objective, assessment, and plan) note */
	public static final int SOAP_A 			= 10;
	/** The "plan" part of a soap (subjective, objective, assessment, and plan) note */
	public static final int SOAP_P 			= 15;
	public static final int PRESCRIPTION 	= 20;
	public static final int FILE 			= 27;
	public static final int UNKNOWN 		= 30;
	public static final int Letter			= 31;

	public static final String DEFAULT_MIME_TYPE = "text/plain";
	
	private String name;
	private String icon;
	private String mimeType;
	private String compression;
	private Boolean deleted;
	
	public static int typePosition=0;


	public static JTabbedPane tabbedPane;
	/**
	 * 
	 */
	public IncidentEntryType() {
		/* ================================================== */

		/* ================================================== */
	}
	
	
	/**
	 * @return the compression
	 */
	@Column(name="compression")
	public String getCompression() {
		return compression;
	}
	/**
	 * @param compression the compression to set
	 */
	public void setCompression(String compression) {
		this.compression = compression;
	}
	
	
	
	/**
	 * @return the deleted
	 */
	@Column(name="deleted")
	public Boolean getDeleted() {
		return deleted;
	}
	/**
	 * @param deleted the deleted to set
	 */
	public void setDeleted(Boolean deleted) {
		this.deleted = deleted;
	}
	
	
	
	/**
	 * @return the icon
	 */
	@Column(name="icon")
	public String getIcon() {
		return icon;
	}
	/**
	 * @param icon the icon to set
	 */
	public void setIcon(String icon) {
		this.icon = icon;
	}
	
	
	/**
	 * @return the mimeType
	 */
	@Column(name="mime_type")
	public String getMimeType() {
		return mimeType;
	}
	/**
	 * @param mimeType the mimeType to set
	 */
	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}
	
	
	/**
	 * @return the name
	 */
	@Column(name="name")
	public String getName() {
		return name;
	}
	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	public String toString() {
		/* ================================================== */
		return this.getName();
		/* ================================================== */
	}
	
	public String toDescriptionString() {
		/* ================================================== */
		String s = this.getName() + "|" + (getMimeType() == null ? DEFAULT_MIME_TYPE : getMimeType());
		return s.toLowerCase();
		/* ================================================== */
	}
}
