/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>patient.measurement_types</b> table
 * which contains all available measurement types
 *
 * @version
 * <br>$Log: MeasurementType.java,v $
 * <br>Revision 1.13  2012-01-24 10:22:27  ferring
 * <br>Native Queries to Named Queries
 * <br>
 * <br>Revision 1.12  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.11  2008-07-22 10:05:15  hermen
 * <br>changed datatype to Boolean
 * <br>
 * <br>Revision 1.10  2008-01-17 09:19:59  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@NamedQueries ({
	@NamedQuery(name=MeasurementType.FIND_ALL, query ="SELECT Object(o) FROM MeasurementType o"),
	@NamedQuery(name = MeasurementType.DELETE_ORPHAN_MEASUREMENTS, query = "SELECT OBJECT(o) FROM MeasurementValue o WHERE o.incidentId IS NULL"),
	@NamedQuery(name = MeasurementType.GET_MEASUREMENTS_BY_INCIDENT_ENTRY, query = "SELECT OBJECT(o) FROM MeasurementValue o "
					+ "WHERE o.incidentEntryId = :entryId "
					+ "ORDER BY o.incidentEntryId, o.measurementType.id ASC"),
	@NamedQuery(name = MeasurementType.GET_MEASUREMENTS_FOR_PATIENT, query = "SELECT OBJECT(o) FROM MeasurementValue o "
					+ "WHERE o.incidentEntryId IN ( "
					+ "SELECT e.id FROM IncidentEntry e WHERE e.incidentId IN ("
					+ " SELECT i.id FROM Incident i WHERE i.patientId = :patientId)) "
					+ "ORDER BY o.incidentEntryId, o.measurementType.id ASC"),
	@NamedQuery(name = MeasurementType.GET_MEASUREMENT_TYPE_BY_NAME, query = "SELECT OBJECT(o) FROM MeasurementType o "
					+ "WHERE o.name = :name"),
	@NamedQuery(name = MeasurementType.GET_MEASUREMENTS_WITHOUT_INCIDENT_ENTRIES, query = "SELECT OBJECT(o) FROM MeasurementValue o "
					+ "WHERE o.incidentEntryId = null "
					+ "ORDER BY o.incidentId ASC"),
	@NamedQuery(name = MeasurementType.GET_MEASUREMENT_VALUES_BY_INCIDENT, query = "SELECT OBJECT(o) FROM MeasurementValue o " 
					+ "WHERE o.incidentId = :incidentId")
})



@Entity
@Table(name = "measurement_types", schema = "patient")
public class MeasurementType extends GECAMedEntityBean implements java.io.Serializable {

	public static final String FIND_ALL ="findAllMeasurementTypes";
	
	public static final String DELETE_ORPHAN_MEASUREMENTS 				= "deleteOrphanMeasurements";
	public static final String GET_MEASUREMENTS_BY_INCIDENT_ENTRY 		= "getMeasurementsByIncidentEntry";
	public static final String GET_MEASUREMENTS_FOR_PATIENT 			= "getMeasurementsForPatient";
	public static final String GET_MEASUREMENT_TYPE_BY_NAME 			= "getMeasurementTypeByName";
	public static final String GET_MEASUREMENTS_WITHOUT_INCIDENT_ENTRIES= "getMeasurementWithoutIncidentEntries";
	public static final String GET_MEASUREMENT_VALUES_BY_INCIDENT 	= "getMeasurementValuesByIncident";

	// Fields

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	private String name;
	private String unit;
	private Boolean numericType;
	private Boolean isDefault;

	private String alias;

	// Constructors

	/** default constructor */
	public MeasurementType() {
	}

	/** minimal constructor */
	public MeasurementType(int id, String name, String unit,
			boolean numericType, boolean default_) {
		this.name = name;
		this.unit = unit;
		this.numericType = numericType;
		this.isDefault = default_;
	}

	// Property accessors

	@Column(name = "name", unique = false, nullable = false, insertable = true, updatable = true, length = 100)
	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	@Column(name = "unit", unique = false, nullable = false, insertable = true, updatable = true, length = 50)
	public String getUnit() {
		return this.unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	@Column(name = "numeric_type", unique = false, nullable = false, insertable = true, updatable = true)
	public Boolean isNumericType() {
		return this.numericType;
	}

	public void setNumericType(Boolean numericType) {
		this.numericType = numericType;
	}

	@Column(name = "is_default", unique = false, nullable = false, insertable = true, updatable = true)
	public Boolean isDefault() {
		return this.isDefault;
	}

	public void setDefault(Boolean default_) {
		this.isDefault = default_;
	}

	/**
	 * @return the alias
	 */
	@Column(name="alias")
	public String getAlias() {
		return alias;
	}

	/**
	 * @param alias the alias to set
	 */
	public void setAlias(String alias) {
		this.alias = alias;
	}





}
