/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;
import lu.tudor.santec.i18n.Translatrix;


/**
 * Entity Bean that maps the <b>patient.measurement_values</b> table
 * represents one single measurement value for a patient
 *
 * @version
 * <br>$Log: MeasurementValue.java,v $
 * <br>Revision 1.13  2013-09-12 14:27:29  troth
 * <br>Fix Ticket #1107 Measurements not properly translated.
 * <br>
 * <br>Revision 1.12  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.11  2008-03-10 12:37:52  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.10  2008-03-06 15:34:27  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.9  2008-01-17 09:19:59  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@javax.persistence.NamedQueries
({
@NamedQuery(name = MeasurementValue.GET_VALUES, query = "SELECT OBJECT(o) FROM MeasurementValue o WHERE o.incidentId IN " +
		"( SELECT i.id FROM Incident i WHERE i.patientId = :patientID ) ORDER BY o.incidentId, o.measurementType.id")
})

@Entity
@Table(name = "measurement_values", schema = "patient")
public class MeasurementValue extends GECAMedEntityBean implements java.io.Serializable {

	// Fields

	private static final long serialVersionUID = 1L;

	public static final String GET_VALUES = "getMeasurementValues";
	
	
	private MeasurementType measurementType;
	private Double valueNumeric;
	private String valueString;

	private Integer incidentId;
	private Incident incident;

	private Date measurementDate;
	
	private Integer incidentEntryId;
	private IncidentEntry incidentEntry;
	

	// Constructors

	/** default constructor */
	public MeasurementValue() {
	}

	// Property accessors

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "measurement_types_id", unique = false, nullable = false, insertable = true, updatable = true)
	public MeasurementType getMeasurementType() {
		return this.measurementType;
	}

	public void setMeasurementType(MeasurementType measurementType) {
		this.measurementType = measurementType;
	}

	@Column(name = "value_numeric", unique = false, nullable = true, insertable = true, updatable = true, precision = 10)
	public Double getValueNumeric() {
		return this.valueNumeric;
	}

	public void setValueNumeric(Double valueNumeric) {
		this.valueNumeric = valueNumeric;
	}

	@Column(name = "value_string", unique = false, nullable = true, insertable = true, updatable = true, length = 100)
	public String getValueString() {
		return this.valueString;
	}

	public void setValueString(String valueString) {
		this.valueString = valueString;
	}

	/**
	 * @return the incidentId
	 */
	@Column(name="incident_id", insertable=false, updatable=false)
	public Integer getIncidentId() {
		return incidentId;
	}

	/**
	 * @param incidentId the incidentId to set
	 */
	public void setIncidentId(Integer incidentId) {
		this.incidentId = incidentId;
	}

	/**
	 * @return the measurementDate
	 */
	@Column(name="measurement_date")
	public Date getMeasurementDate() {
		return measurementDate;
	}

	/**
	 * @param measurementDate the measurementDate to set
	 */
	public void setMeasurementDate(Date measurementDate) {
		this.measurementDate = measurementDate;
	}



	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		try {
			StringBuffer sb = new StringBuffer(this.measurementType.getName() + " ");
			if (this.measurementType.isNumericType())
				sb.append(this.getValueNumeric() + " ");
			else
				sb.append(this.getValueString() + " ");
			sb.append(this.measurementType.getUnit());
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return super.toString();
		}
	}

	public String toHTMLString() {
		try {
			String translatrixString = "patient.incident.measurement." + this.measurementType.getName().toLowerCase();
			StringBuffer sb = new StringBuffer("<b>");
			if(translatrixString.equals(Translatrix.getTranslationString(translatrixString)))
				sb.append(this.measurementType.getAlias() + " ");
			else	
				sb.append(Translatrix.getTranslationString(translatrixString) + " ");
			
			if (this.measurementType.isNumericType())
				sb.append(this.getValueNumeric() + "</b> ");
			else
				sb.append(this.getValueString() + "</b> ");
			sb.append(this.measurementType.getUnit());
			return sb.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return super.toString();
		}
	}

	/**
	 * @return the incident
	 */
	@ManyToOne
	@JoinColumn(name="incident_id")
	public Incident getIncident() {
		return incident;
	}

	/**
	 * @param incident the incident to set
	 */
	public void setIncident(Incident incident) {
		this.incident = incident;
	}

	/**
	 * @return the entry
	 */
	@ManyToOne
	@JoinColumn(name="incident_entry_id")
	public IncidentEntry getIncidentEntry() {
		return incidentEntry;
	}

	/**
	 * @param entry the entry to set
	 */
	public void setIncidentEntry(IncidentEntry entry) {
		this.incidentEntry = entry;
	}

	/**
	 * @return the entryId
	 */
	@Column(name="incident_entry_id", insertable=false, updatable=false)
	public Integer getIncidentEntryId() {
		return incidentEntryId;
	}

	/**
	 * @param entryId the entryId to set
	 */
	public void setIncidentEntryId(Integer entryId) {
		this.incidentEntryId = entryId;
	}
	
	
	
	
	
	
	
	
	
}
