/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>patient.passage</b> table.
 * represents one single passage for a patients hospitalisation prescription
 *
 * @version
 * <br>$Log: Passage.java,v $
 * <br>Revision 1.19  2010-04-27 15:10:12  mack
 * <br>Removed obsolete code
 * <br>
 * <br>Revision 1.18  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.17  2008-01-17 09:19:59  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@Entity
@Table(name="passage", schema="patient")
@NamedQueries ({
//		@NamedQuery(name=Passage.FIND_PASSAGE_BY_VISIT_ID,
//				query="SELECT OBJECT(o) FROM Passage o WHERE o.visitId = :visitId"),
		@NamedQuery(name= Passage.FIND_PASSAGE_BY_ID,
				query = "SELECT Object(o) FROM Passage o WHERE o.id = :id"),
		@NamedQuery(name= Passage.FIND_PASSAGE_BY_PATIENT_ID,
				query = "SELECT Object(o) FROM Passage o WHERE o.patientId = :patientId"),
		@NamedQuery(name= Passage.FIND_PASSAGE_BY_PHYSICIAN_ID,
				query = "SELECT Object(o) FROM Passage o WHERE o.physicianId = :physicianId"),
		@NamedQuery(name= Passage.FIND_PASSAGE_BY_HOPSPPERIOD_ID,
				query = "SELECT Object(o) FROM Passage o WHERE o.hospperiodId = :hospperiodId ORDER BY o.date DESC"),
		@NamedQuery(name= Passage.FIND_PASSAGE_BY_HOSPITAL_PPRESCRIPTION_ID,
				query = "SELECT Object(o) FROM Passage o WHERE o.hospitalPrescriptionId = :hospitalPrescriptionId ORDER BY o.date DESC"),
		@NamedQuery(name= Passage.FIND_PASSAGE_WITHOUT_HOSPITAL_PPRESCRIPTION_ID,
				query = "SELECT Object(o) FROM Passage o WHERE o.hospitalPrescriptionId IS NULL ORDER BY o.date DESC"),
		@NamedQuery(name= Passage.FIND_PASSAGE_BY_ACCESSION_NUMBER,
				query = "SELECT Object(o) FROM Passage o WHERE o.accessionNumber = :accessionNumber")

})
public class Passage extends GECAMedEntityBean implements Serializable{

	// constants for named queries

	public static final String FIND_PASSAGE_BY_ID ="findPassageById";
	public static final String FIND_PASSAGE_BY_PATIENT_ID ="findAllPassageByPatientId";
//	public static final String FIND_PASSAGE_BY_VISIT_ID ="findAllPassageByVisitId";
	public static final String FIND_PASSAGE_BY_PHYSICIAN_ID ="findAllPassageByPhysicianId";
	public static final String FIND_PASSAGE_BY_HOPSPPERIOD_ID ="findAllPassageByHospPeriodId";
	public static final String FIND_PASSAGE_BY_HOSPITAL_PPRESCRIPTION_ID ="findAllPassageByHospitalPrescriptionId";
	public static final String FIND_PASSAGE_WITHOUT_HOSPITAL_PPRESCRIPTION_ID ="findAllPassageWithoutHospitalPrescriptionId";
	public static final String FIND_PASSAGE_BY_ACCESSION_NUMBER ="findPassageByAccessionNumber";

	// constants

	public static final String PASSAGE_WITH_REPORT = "withReport";



	private static final long serialVersionUID = 1L;

	private Date 		date;
	private Integer 	patientId;
//	private Integer 	visitId;
	private Integer 	hospperiodId;
	private String	accessionNumber;
	private String 	treatmentName;
	private Integer 	physicianId;
	private String 	ordphysician;
	private String 	technicianName;
	private String	treatUCMCode;
	private Integer   createdBy;
	private Boolean 	rX = true; 
	private Boolean 	verified = false; 
	private Integer   hospitalPrescriptionId;

	/**
	 * @return Returns the createdBy.
	 */
	@Column(name = "created_by")
	public Integer getCreatedBy() {
		return createdBy;
	}

	/**
	 * @param createdBy The createdBy to set.
	 */
	public void setCreatedBy(Integer createdBy) {
		this.createdBy = createdBy;
	}


	/**
	 * @return Returns the date.
	 */
	@Column(name = "passage_date")
	public Date getDate() {
		return date;
	}

	/**
	 * @param date The date to set.
	 */
	public void setDate(Date date) {
		this.date = date;
	}


	/**
	 * @return Returns the hospperiodId.
	 */
	@Column(name = "hospperiod_id")
	public Integer getHospperiodId() {
		return hospperiodId;
	}

	/**
	 * @param hospperiodId The hospperiodId to set.
	 */
	public void setHospperiodId(Integer hospperiodId) {
		this.hospperiodId = hospperiodId;
	}

	/**
	 * @return Returns the accession number associated with this passage.
	 */
	@Column(name = "accession_number")
	public String getAccessionNumber() {
		return accessionNumber;
	}

	/**
	 * @param accessionNumber specifies the new accession number for this passage.
	 */
	public void setAccessionNumber (String accessionNumber) {
		this.accessionNumber = accessionNumber;
	}


	/**
	 * @return Returns the ordphysician.
	 */
	@Column(name = "ordphysician")
	public String getOrdphysician() {
		return ordphysician;
	}

	/**
	 * @param ordphysician The ordphysician to set.
	 */
	public void setOrdphysician(String ordphysician) {
		this.ordphysician = ordphysician;
	}


	/**
	 * @return Returns the patientId.
	 */
	@Column(name = "patient_id")
	public Integer getPatientId() {
		return patientId;
	}

	/**
	 * @param patientId The patientId to set.
	 */
	public void setPatientId(Integer patientId) {
		this.patientId = patientId;
	}


	/**
	 * @return Returns the physicianId.
	 */
	@Column(name = "physician_id")
	public Integer getPhysicianId() {
		return physicianId;
	}

	/**
	 * @param physicianId The physicianId to set.
	 */
	public void setPhysicianId(Integer physicianId) {
		this.physicianId = physicianId;
	}

	/**
	 * @return Returns the technicianName.
	 */
	@Column(name = "technicianname")
	public String getTechnicianName() {
		return technicianName;
	}

	/**
	 * @param technicianName The technicianName to set.
	 */
	public void setTechnicianName(String technicianName) {
		this.technicianName = technicianName;
	}


	/**
	 * @return Returns the treatmentName.
	 */
	public String getTreatmentName() {
		return treatmentName;
	}

	/**
	 * @param treatmentName The treatmentName to set.
	 */
	@Column(name = "treatmentname")
	public void setTreatmentName(String treatmentName) {
		this.treatmentName = treatmentName;
	}


	/**
	 * @return Returns the treatUCMCode.
	 */
	@Column(name = "treatucmcode")
	public String getTreatUCMCode() {
		return treatUCMCode;
	}

	/**
	 * @param treatUCMCode The treatUCMCode to set.
	 */
	public void setTreatUCMCode(String treatUCMCode) {
		this.treatUCMCode = treatUCMCode;
	}

//	No LONGER NEEDED
//	/**
//	 * @return Returns the visitId.
//	 */
//	@Column(name = "visit_id")
//	public Integer getVisitId() {
//		return visitId;
//	}
//
//	/**
//	 * @param visitId The visitId to set.
//	 */
//	public void setVisitId(Integer visitId) {
//		this.visitId = visitId;
//	}

	@Override
	public String toString() {
		return this.getTreatmentName() + " (" + this.getTreatUCMCode() + ")";
	}

	/**
	 * @return the rX
	 */
	@Column(name = "rx")
	public Boolean getRX() {
		return rX;
	}

	/**
	 * @param rx the rX to set
	 */
	public void setRX(Boolean rx) {
		rX = rx;
	}
	
	/**
	 * @return the verified
	 */
	@Column(name = "verified")
	public Boolean getVerified() {
		return verified;
	}

	/**
	 * @param verified the verified to set
	 */
	public void setVerified(Boolean verified) {
		this.verified = verified;
	}

	/**
	 * @return the orderID
	 */
	@Column(name = "hospprescription_id")
	public Integer getHospitalPrescriptionId() {
		return hospitalPrescriptionId;
	}

	/**
	 * @param orderID the orderID to set
	 */
	public void setHospitalPrescriptionId (Integer prescriptionId) {
		this.hospitalPrescriptionId = prescriptionId;
	}

}
