/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.beans;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.Table;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.GECAMedEntityBean;

/**
 * Entity Bean that maps the <b>patient.patient_foto</b> table.
 * represents one single foto that can be attached to a patient
 *
 * @version
 * <br>$Log: PatientFoto.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-17 09:19:58  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@javax.persistence.NamedQueries({

    // findAll NamedQuery
    @javax.persistence.NamedQuery(name="findAllPatientFoto",
        query="SELECT OBJECT(o) FROM PatientFoto o"),
    // NamedQueries using Fields.
    @javax.persistence.NamedQuery(name="findAllPatientFotoByPatientId",
        query="SELECT OBJECT(o) FROM PatientFoto o WHERE o.patientId = :patientId")
})

@Entity
@Table(name = "patient_foto", schema = "patient")
public class PatientFoto extends GECAMedEntityBean implements Serializable {

	private static final long serialVersionUID = 1L;
	
	private byte[] data;
	private Integer patientId;
	
	/**
	 * Get the data.
	 *
	 * @return The data.
	 */
	@javax.persistence.Column(name = "data")
	public byte[] getData() {
		return data;
	}

	/**
	 * Set the data.
	 *
	 * @param data The data.
	 */
	public void setData(byte[] data) {
		this.data = data;
	}

	/**
	 * Get the patientId.
	 *
	 * @return The patientId.
	 */
	@javax.persistence.Column(name = "patient_id")
	public Integer getPatientId() {
		return patientId;
	}

	/**
	 * Set the patientId.
	 *
	 * @param filename The patientId.
	 */
	public void setPatientId(Integer patientId) {
		this.patientId = patientId;
	}

}
