/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.entity.interfaces;

import java.io.Serializable;
import java.util.Date;


/**
 * Data Bean to represent different Object Types in the Hospitalisation View.  
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: HospitalisationElement.java,v $
 * <br>Revision 1.10  2008-09-25 09:43:10  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.9  2008-01-17 09:22:36  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class HospitalisationElement implements Serializable, Comparable<HospitalisationElement>{

	private static final long serialVersionUID = 1L;
	private Date date;
	private Integer physicianID;
	private String description;
	private Integer id;
	private Integer periodID;
	private Integer type = 0;
	private boolean verified = false;
	private boolean rx = false;
	
	private String toolTip;
	
	public static final int HOSPITALISATION = 2;
	public static final int ACCIDENT = 3;
	public static final int HOSPITALISATION_PERIOD_A = 4;
	public static final int HOSPITALISATION_PERIOD_1 = 8;
	public static final int HOSPITALISATION_PERIOD_2 = 16;
	public static final int PASSAGE = 24;
	public static final int PRESCRIPTION = 32;
	public static final int REPORT = 64;

	public HospitalisationElement(Integer id, Date date, Integer physician, String description, Integer type) {
		this.id = id;
		this.date = date;
		this.physicianID = physician;
		this.description = description;
		this.type = type;
	}
	


	public int compareTo(HospitalisationElement o) {
		if (this.date.before(o.date)) {
			return -1;
		} else if (this.date.after(o.date)) {
			return 1;
		} else 
			return (this.type - o.type);
	}


	/**
	 * @return Returns the date.
	 */
	public Date getDate() {
		return date;
	}


	/**
	 * @param date The date to set.
	 */
	public void setDate(Date date) {
		this.date = date;
	}


	/**
	 * @return Returns the description.
	 */
	public String getDescription() {
		return description;
	}


	/**
	 * @param description The description to set.
	 */
	public void setDescription(String description) {
		this.description = description;
	}


	/**
	 * @return Returns the physician.
	 */
	public Integer getPhysicianID() {
		return physicianID;
	}


	/**
	 * @param physician The physician to set.
	 */
	public void setPhysicianID(Integer physician) {
		this.physicianID = physician;
	}


	/**
	 * @return Returns the type.
	 */
	public Integer getType() {
		return type;
	}


	/**
	 * @param type The type to set.
	 */
	public void setType(Integer type) {
		this.type = type;
	}


	/**
	 * @return Returns the id.
	 */
	public Integer getId() {
		return id;
	}


	/**
	 * @param id The id to set.
	 */
	public void setId(Integer id) {
		this.id = id;
	}

	/**
	 * @return the periodID
	 */
	public Integer getPeriodID() {
		return periodID;
	}

	/**
	 * @param periodID the periodID to set
	 */
	public void setPeriodID(Integer periodID) {
		this.periodID = periodID;
	}

	/**
	 * @return the status
	 */
	public boolean isVerified() {
		return verified;
	}

	/**
	 * @param status the status to set
	 */
	public void setVerified(boolean status) {
		this.verified = status;
	}
	
	/**
	 * @return the status
	 */
	public boolean isRx() {
		return rx;
	}

	/**
	 * @param status the status to set
	 */
	public void setRx(boolean rx) {
		this.rx = rx;
	}



	/**
	 * @return the toolTip
	 */
	public String getToolTip() {
		return toolTip;
	}



	/**
	 * @param toolTip the toolTip to set
	 */
	public void setToolTip(String toolTip) {
		this.toolTip = toolTip;
	}
	
	public String toString() {
		return "HospitalisationElement:  " + getType() + " "  + getDate() + "\r\n" + getDescription() + "\r\n";
	}


}
