/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.session.beans;

import java.util.Collection;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.HospitalisationClass;
import lu.tudor.santec.gecamed.patient.ejb.session.interfaces.HospitalisationClassInterface;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

@Stateless
@Remote (HospitalisationClassInterface.class)
public class HospitalisationClassBean implements HospitalisationClassInterface
	{
	private static final long serialVersionUID = 1L;
	
	@PersistenceContext (unitName="gecam")
	EntityManager m_EntityManager;

//***************************************************************************
//* Class Primitives                                                        *
//***************************************************************************

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************

//---------------------------------------------------------------------------

public HospitalisationClass getHospitalisationClassByID (Integer p_ID) throws Exception 
	{
	HospitalisationClass l_Hospitalisation;
	
	l_Hospitalisation = m_EntityManager.find(HospitalisationClass.class, p_ID);
	return l_Hospitalisation;
	}

//---------------------------------------------------------------------------

public void setHospitalisationClass (HospitalisationClass p_Hospitalisation) throws Exception 
	{
	m_EntityManager.persist (p_Hospitalisation);
	}

//---------------------------------------------------------------------------

@SuppressWarnings("unchecked")
public Collection <HospitalisationClass> getAllHospitalisationClasses() throws Exception 
	{
	Collection 	l_Hospitalisations;
	
	l_Hospitalisations = m_EntityManager.createNamedQuery ("getAllHospitalisationClasses").getResultList();
   
    return l_Hospitalisations;
	}

//---------------------------------------------------------------------------

public HospitalisationClass getHospitalisationClassByAcronym (String p_Acronym) throws Exception 
	{
	HospitalisationClass l_Hospitalisation;
	
	l_Hospitalisation = (HospitalisationClass) m_EntityManager.createNamedQuery ("getHospitalisationClassByAcronym")
	                              					  .setParameter("acronym", p_Acronym)
	                              					  .getSingleResult();
   
    return l_Hospitalisation;
	}

//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
