/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.session.interfaces;

import java.util.Collection;
import java.util.List;
import java.util.Locale;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.HospitalPrescriptionPage;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Passage;
import lu.tudor.santec.gecamed.patient.ejb.entity.interfaces.HospitalisationElement;

@Remote
public interface HospitalisationBeanInterface {

	//***************************************************************************
	//* methods for Hospitalisation                                                              *
	//***************************************************************************
	
	public List<HospitalisationElement> getHospitalisationHistory(Integer patientId, Locale locale)
	throws Exception;
	
	public abstract Passage getPassageById (Integer passageId) throws Exception;
	
	public void setPassageVerified(Integer passageID, Boolean verified) throws Exception;
	
	public void setPassageRx(Integer passageID, Boolean rx) throws Exception;

	
	public byte[] getHospitalReport(Integer id);

	public Collection<HospitalPrescriptionPage> getHospitalPrescriptionPages(Integer id);
	
}
