/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * 
 */
package lu.tudor.santec.gecamed.patient.ejb.session.interfaces;

/**
 * Interface to offer the permissions of the patient module
 * to both, the server and the clients
 * 
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: IPatientPermissions.java,v $
 * <br>Revision 1.5  2011-11-15 13:47:08  ferring
 * <br>Right to change the amount of acts added to the role Accounting.
 * <br>Right is checked in ActRenderer.
 * <br>
 * <br>Revision 1.4  2009-01-26 13:21:32  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:39  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.1  2006/12/06 07:49:54  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2006/11/17 13:46:41  heinemann
 * <br>initial checkin
 * <br>
 */
public interface IPatientPermissions {
	
	// History
	public static final String VIEW_HISTORY = "PatientModule.viewHistory";
	public static final String EDIT_HISTORY = "PatientModule.editHistory";
	// Consultation
	public static final String VIEW_CONSULTATION = "PatientModule.viewConsultation";
	public static final String EDIT_CONSULTATION = "PatientModule.editConsultation";
	public static final String CREATE_CONSULTATION = "PatientModule.createConsultation";
	// Adminstrative
	public static final String VIEW_ADMINISTRATIVE = "PatientModule.viewAdministrative";
	public static final String EDIT_ADMINISTRATIVE = "PatientModule.editAdministrative";
	// Anamnesis
	public static final String VIEW_ANAMNESIS = "PatientModule.viewAnamnesis";
	public static final String EDIT_ANAMNESIS = "PatientModule.editAnamnesis";
	// Memos
	public static final String VIEW_OWN_MEMOS = "PatientModule.viewOwnMemos";
	public static final String EDIT_OWN_MEMOS = "PatientModule.editOwnMemos";
	public static final String VIEW_ALL_MEMOS = "PatientModule.viewAllMemos";
	public static final String EDIT_ALL_MEMOS = "PatientModule.editAllMemos";
	// Patient
	public static final String CREATE_PATIENT = "PatientModule.createPatients";
	public static final String DELETE_PATIENT = "PatientModule.deletePatients";
	// Hospitalisation
	public static final String EDIT_HOSPITALISATION = "PatientModule.editHospitalisations";
	// prescription
	public static final String CREATE_PRESCRIPTION = "PatientModule.createPrescription";
	// billing
	public static final String CHANGE_AMOUNT_OF_RATE = "BillingModule.changeAmount";

}
