/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.session.interfaces;

import java.util.Collection;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Insurance;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.InsurancePlan;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************

/**
* The InsuranceInterface 
* @author nmac
* @created 06/04/19
*
*/

@Remote
public interface InsuranceInterface 
	{
	public Insurance getInsuranceByID (Integer p_ID) throws Exception;
	
	public Insurance[] getAllInsurancesAsArray () throws Exception;
//	public Insurance[] getThirdPartyPayingInsurancesAsArray () throws Exception;
	public Insurance[] getPrimaryInsurancesAsArray () throws Exception;
	public InsurancePlan[] getAllInsurancePlansAsArray() throws Exception;
	
	public Collection<Insurance> getAllInsurances () throws Exception;
//	public Collection<Insurance> getThirdPartyPayingInsurances () throws Exception;
//	public Collection<Insurance> getPrimaryInsurances () throws Exception;
//	public Collection<Insurance> getPrivateInsurances () throws Exception;
//	public Collection<Insurance> getUCMAffiliatedInsurances () throws Exception;
	public Collection<Insurance> getDisbandedInsurances ();
	public Collection<Insurance> findInsurancesByAcronym(String acronym) throws Exception;
	public Insurance getInsuranceByAcronym (String acronym);

	
	public void	setInsurance (Insurance p_Insurance) throws Exception;

	public void save(Insurance insurance);
	
	
//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
