/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.ejb.session.interfaces;

import java.util.Collection;
import java.util.List;

import javax.ejb.Remote;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientMemo;
import lu.tudor.santec.gecamed.usermanagement.ejb.entity.beans.GecamedUser;

//***************************************************************************
//* Interface Definition and Members                                        *
//***************************************************************************


/**
 * Session Bean Interface to manages the Memos attachet to teh patient 
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: PatientMemoInterface.java,v $
 * <br>Revision 1.5  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-01-17 09:52:33  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
@Remote
public interface PatientMemoInterface
	{

	/**
	 * returns the number of memos for the patient
	 * @param p_ID
	 * @return
	 * @throws Exception
	 */
	public Long getMemoCountByPatientID(Integer p_ID) throws Exception ;

	/**
	 * fetches all memos for the patient
	 * @param patientID
	 * @return
	 * @throws Exception
	 */
	public Collection<PatientMemo> getMemosByPatientID (Integer patientID) throws Exception;

	/**
	 * fetches all memos for the patient and specified author
	 * @param author
	 * @return
	 * @throws Exception
	 */
	public Collection<PatientMemo> getMemosByAuthor (GecamedUser author) throws Exception;

	/**
	 * saves the specified memo
	 * @param p_Memo
	 * @return
	 * @throws Exception
	 */
	public PatientMemo	saveMemo (PatientMemo p_Memo) throws Exception;

	/**
	 * delete the specified memo
	 * @param p_Memo
	 * @throws Exception
	 */
	public void	deleteMemo (PatientMemo p_Memo) throws Exception;

	/**
	 * gets all memos marked as warning
	 * @param patientId
	 * @return
	 */
	public List<PatientMemo> getWarningMemos(Integer patientId);

//***************************************************************************
//* End of Class															*
//***************************************************************************
	}
