package lu.tudor.santec.gecamed.patient.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import lu.tudor.santec.gecamed.core.gui.GECAMedLists;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialog;
import lu.tudor.santec.gecamed.core.gui.widgets.NamedComponent;
import lu.tudor.santec.gecamed.office.ejb.entity.beans.Physician;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

public class EmptyIncidentDialog extends GECAMedBaseDialog {

    private static final long serialVersionUID = 1L;
    private MainFrame mainFrame;
    protected boolean retVal;
    private IncidentPanel incidentPanel;

    public EmptyIncidentDialog() {
	super(MainFrame.getInstance(), Translatrix.getTranslationString("dossier.emptyincidentCreate"), true);
	this.mainFrame = MainFrame.getInstance();
	
	this.incidentPanel = new IncidentPanel();
	this.addMainPanel(incidentPanel);
	
	this.pack();
	
	this.okButton.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		retVal = true;
		
	    }
	});
	
    }
    
	public void showDialog() {
		this.retVal = false;
		this.incidentPanel.loadPhysicians();
		this.incidentPanel.textField.setText(Translatrix.getTranslationString("dossier.emptyincidentReason"));
		
		this.setLocationRelativeTo(mainFrame);
		this.setVisible(true);
	}
    
	    public Physician getPhysician() {
		try {
    		    Physician p = (Physician) incidentPanel.physicianList.getSelectedValue();
		    return p;
		} catch (Exception e) {
		    return null;
		}
	    }
	    
	    public String getText() {
		return incidentPanel.textField.getText();
	    }
	
    
	class IncidentPanel extends JPanel {
	    
	    private static final long serialVersionUID = 1L;
	    private JTextArea textField;
	    private JList physicianList;
	    private DefaultListModel physicianListModel;

	    public IncidentPanel() {
		
		CellConstraints cc = new CellConstraints();
		
		this.physicianListModel = new DefaultListModel();
		this.physicianList = new JList(physicianListModel);
		this.textField = new JTextArea(4,60);
		
		this.setLayout(new FormLayout(
			"3dlu, 150dlu:grow, 3dlu",
			"3dlu, fill:70dlu:grow, 3dlu, fill:70dlu:grow, 3dlu"
		));
		
	        JScrollPane jsp = new JScrollPane(this.physicianList);
	        jsp.setOpaque(false);
	        jsp.getViewport().setOpaque(false);
	        this.add(new NamedComponent(Translatrix.getTranslationString("core.physician"), jsp), cc.xy(2,2)); 
	        
	        this.add(new NamedComponent(Translatrix.getTranslationString("patient.incident.soap.s"),this.textField), cc.xy(2,4));
		this.setOpaque(false);
		
	    }
	    
	    protected void loadPhysicians() {
		this.physicianListModel.clear();
		Collection<Physician> onlinePhys = MainFrame.getOnlinePhysicians(MainFrame.getCurrentSiteId());
		if (onlinePhys != null && onlinePhys.size() > 0) {
		    for (Physician physician : onlinePhys) {
			this.physicianListModel.addElement(physician);
		    }
		    this.physicianListModel.addElement("-----------");		    
		}
		Physician[] allPhysicians = GECAMedLists.getArray(Physician.class);
		if (allPhysicians != null)
		    for (Physician physician : allPhysicians) {
		    	this.physicianListModel.addElement(physician);
		    }
		this.physicianList.setSelectedIndex(0);
	    }
	}
	
}
