/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui;

import lu.tudor.santec.gecamed.core.gui.utils.DefaultComboBoxRenderer;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.HospitalisationClass;
import lu.tudor.santec.i18n.Translatrix;


/**
 * a renderer for Insurance objects in comboboxes
 *
 * @author Nico MACK
 */

//***************************************************************************
//* Class Definition and Members                                            *
//***************************************************************************

public class HospitalisationClassComboBoxRenderer extends DefaultComboBoxRenderer
{
	private boolean m_OnlyAcronym;
	private boolean m_Localized;
	
//***************************************************************************
//* Class Constants                                                         *
//***************************************************************************
	
    private static final long serialVersionUID = 1L;

//***************************************************************************
//* Constructor(s)                                                          *
//***************************************************************************

public HospitalisationClassComboBoxRenderer (boolean p_OnlyAcronym,
										   boolean p_Localized)
	{
	m_OnlyAcronym = p_OnlyAcronym;
	m_Localized   = p_Localized;
	}

//***************************************************************************
//* Class Body                                                              *
//***************************************************************************
//---------------------------------------------------------------------------

protected String getRenderString (Object p_Object)
    {
	HospitalisationClass	l_Class;
    String					l_String = "";
    String 					l_Key;
	
    if (p_Object instanceof HospitalisationClass)
    		{
    		l_Class = (HospitalisationClass) p_Object;
    
    		if (m_OnlyAcronym == true) 
    			l_String = l_Class.getAcronym();
    		else 
    			l_String = l_Class.getName();
    		
    		if (m_Localized)
    			{
    			l_Key = "HospitalisationClass." + l_Class.getAcronym();
    			if (!l_Key.equals(Translatrix.getTranslationString(l_Key))) {
    				// only, if the translation exists
    				l_String = Translatrix.getTranslationString(l_Key);
    			} else {
    				l_String = l_Class.getName();
    			}
    			}
    		}
    
    return l_String;
    }

//***************************************************************************
//* End of Class															*
//***************************************************************************
}
