/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui;

import java.awt.Color;

import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.patient.gui.patientexport.PatientExportPanel;
import lu.tudor.santec.gecamed.patient.gui.patientlist.PatientListPanel;
import lu.tudor.santec.gecamed.patient.gui.patientlist.PatientSearchSettingsPlugin;
import lu.tudor.santec.i18n.Translatrix;

/**
 * Module to show a list of all patients with the possibility to search by keywords.
 * See package patientlist for details of the components
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 21.01.2008
 * 14:28:10
 *
 *
 * @version
 * <br>$Log: PatientListModule.java,v $
 * <br>Revision 1.26  2013-06-10 08:22:14  ferring
 * <br>eSante POC
 * <br>
 * <br>Revision 1.25  2013-03-05 14:48:24  troth
 * <br>Add ProgressBar in export dialog.
 * <br>
 * <br>Revision 1.24  2013-02-25 10:32:17  troth
 * <br>Add function to add patients from the patientsearch tab the patientexport tab.
 * <br>
 * <br>Revision 1.23  2013-01-23 16:50:50  troth
 * <br>add new GUI for the MM Export tab the PatientExportPanel.
 * <br>
 * <br>Revision 1.22  2012-10-19 16:24:42  troth
 * <br>First version of GECAMed launcher.
 * <br>
 * <br>Revision 1.21  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.20  2008-05-27 09:09:11  hermen
 * <br>fixed search RETURN key behavior
 * <br>
 * <br>Revision 1.19  2008-05-27 08:23:50  hermen
 * <br>fixed search in dialog and added new setting
 * <br>
 * <br>Revision 1.18  2008-04-14 08:11:58  hermen
 * <br>added option to use big fonts for patient seatrch and reorganized search settings
 * <br>
 * <br>Revision 1.17  2008-03-27 12:34:53  weitz
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.16  2008-02-27 08:24:29  heinemann
 * <br>added initModule call
 * <br>
 * <br>Revision 1.15  2008-01-21 14:58:42  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public class PatientListModule extends GECAMedModule {

	private static final long serialVersionUID = 1L;
	
	public PatientListPanel patientListPanel;
	
	private PatientExportPanel patientExportPanel;
	
	public PatientSearchSettingsPlugin patientListSettingsPlugin;

	private PatientManagerModule patientManagerModule;
	
	public static final String MODULE_NAME = "PatientList";
	
	private static PatientListModule patientListModule;
	
	private static final int PATIENT_SEARCH_TAB = 0;
	
	private static final int PATIENT_EXPORT_TAB = 1;
	
	private static int selectedTab = PATIENT_SEARCH_TAB;
	// load module icons
	private static final ImageIcon PATIENT_SEARCH_ICON = PatientManagerModule.getIcon(PatientManagerModule.PATIENTS);
	
	private static final ImageIcon PATIENT_EXPORT_ICON = PatientManagerModule.getIcon(PatientManagerModule.PATIENT_EXPORT);

	
	/**
	 * @param patientManagerModule
	 */
	public PatientListModule(PatientManagerModule patientManagerModule) {
		/* ================================================== */
		super(MODULE_NAME, PATIENT_SEARCH_ICON,Color.WHITE);
        // add the ResourceBundle for: lu.tudor.santec.gecam.client.gui.pm
        Translatrix.addBundle("lu.tudor.santec.gecamed.patient.gui.resources.Translatrix");
        this.patientManagerModule = patientManagerModule;
        
        // static reference
        patientListModule = this;
		/* ================================================== */
	}

	
	/* (non-Javadoc)
	 * @see lu.tudor.santec.gecamed.core.gui.GECAMedModule#initModule()
	 */
	@Override
	protected void initModule() {
		/* ====================================================== */
		this.setOpaque(false);

        this.patientListSettingsPlugin = new PatientSearchSettingsPlugin();
        addSettingsPlugin(patientListSettingsPlugin);
        
		this.patientListPanel = new PatientListPanel(this, patientManagerModule);
		this.patientExportPanel = new PatientExportPanel(this, patientManagerModule);
		
		// add a tabbedPane = new JTabbedPane();
		JTabbedPane tabbedPane = new JTabbedPane();
		tabbedPane = new JTabbedPane();
		tabbedPane.setOpaque(false);
		tabbedPane.setBackground(GECAMedColors.c_GECAMedBackground);
		tabbedPane.add(this.patientListPanel, PATIENT_SEARCH_TAB);
		tabbedPane.add(this.patientExportPanel, PATIENT_EXPORT_TAB); // TODO activated ExportPanel 
		
		tabbedPane.setTitleAt(0, Translatrix.getTranslationString("list.patientList"));
		tabbedPane.setTitleAt(1, Translatrix.getTranslationString("patientExport.tabTitle")); // TODO activated ExportPanel
		tabbedPane.addChangeListener(new ChangeListener() {
			
			// switch between the Tabs and set the icon, title ,components and buttons
			public void stateChanged(ChangeEvent e)
			{
				if(selectedTab == PATIENT_SEARCH_TAB)
				{
					titlePanel.setIcon(PATIENT_EXPORT_ICON);
					titlePanel.setTopic(Translatrix.getTranslationString("patientExport.headerTitle"));
//					titlePanel.setHeaderComponent(); // not need at this time
					titlePanel.remove(patientListPanel.getSearchComponent());
					titlePanel.removeAllButtons();
					selectedTab = PATIENT_EXPORT_TAB;
				}else{
					titlePanel.setIcon(PATIENT_SEARCH_ICON);
					titlePanel.setTopic(Translatrix.getTranslationString(MODULE_NAME));
					titlePanel.setHeaderComponent(patientListPanel.getSearchComponent());
					patientListPanel.getClearAction().add();
					patientListPanel.getReloadAction().add();
					selectedTab = PATIENT_SEARCH_TAB;
				}
			}
		});
		
//		enableMenuPanel(tabbedPane.getSelectedIndex());
		
		this.setContentPanel(tabbedPane);

		this.titlePanel.setHeaderComponent(this.patientListPanel.getSearchComponent());
		/* ====================================================== */
	}

	@Override
	public void preparetoShowup() {
	}

	@Override
	public void afterShowup() {
		if (this.patientListPanel != null )
			this.patientListPanel.setFocus();
	}

	public static PatientListModule getInstance() {
	    return patientListModule;
	}
	
	public PatientExportPanel getPatientExportPanel()
	{
		return this.patientExportPanel;
	}


	public void research ()
	{
		this.patientListPanel.searchPatients(true, false);
	}
}
