/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: PatientManagerIconNames.java,v $
 * <br>Revision 1.26  2013-12-17 12:55:19  ferring
 * <br>icon names corrected
 * <br>
 * <br>Revision 1.25  2013-12-04 16:36:55  troth
 * <br>Add EPSOS button to patient view to open the epsos website.
 * <br>
 * <br>Revision 1.24  2013-12-04 16:01:14  troth
 * <br>Add EPSOS button to patient view to open the epsos website.
 * <br>
 * <br>Revision 1.23  2013-12-04 13:15:01  troth
 * <br>Add EPSOS button to patient view to open the epsos website.
 * <br>
 * <br>Revision 1.22  2013-07-10 16:28:43  troth
 * <br>Add lab talon button in patient view.
 * <br>
 * <br>Revision 1.21  2013-01-23 16:50:50  troth
 * <br>add new GUI for the MM Export tab the PatientExportPanel.
 * <br>
 * <br>Revision 1.20  2012-10-03 12:24:33  troth
 * <br>Implement ticket #1000.
 * <br>
 * <br>Revision 1.19  2012-07-12 15:50:32  troth
 * <br>Implementation of Ticket #1003.
 * <br>
 * <br>Revision 1.18  2012-03-05 10:09:14  troth
 * <br>Add new MedLogin Button in patient panel on the functionbar.
 * <br>
 * <br>Revision 1.17  2011-02-28 15:41:45  troth
 * <br>To provide smaller resolutions for the user interface add the navigation bar icons and function bar icons to the user setting "use small icons"
 * <br>
 * <br>Revision 1.16  2009-10-30 09:58:55  hermen
 * <br>added departed status to patient
 * <br>
 * <br>Revision 1.15  2009-03-16 14:17:27  hermen
 * <br>added patient incident statistics
 * <br>
 * <br>Revision 1.14  2009-02-27 15:25:56  hermen
 * <br>added button to create an empty incident for a patient visit
 * <br>
 * <br>Revision 1.13  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.12  2008-09-04 14:54:22  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.11  2008-07-07 12:07:57  heinemann
 * <br>complete - # 156: Add feedback to password dialog for superman mode
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/156
 * <br>
 * <br>Revision 1.10  2008-07-04 15:49:32  heinemann
 * <br>omplete - # 134: Antecedents cacher
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/134
 * <br>
 * <br>Revision 1.9  2008-07-04 13:38:17  heinemann
 * <br>Complete - task 5: Create Icon for History List Views
 * <br>
 * <br>Revision 1.8  2008-06-17 09:29:45  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2008-06-03 12:59:11  weitz
 * <br>*letter package, release candidate
 * <br>
 * <br>Revision 1.6  2008-04-09 12:38:23  hermen
 * <br>fixed icons and translations
 * <br>
 * <br>Revision 1.5  2008-04-07 16:56:06  mack
 * <br>Removed physician icon name because it already is now defined GECAMedIconNames
 * <br>
 * <br>Revision 1.4  2008-03-27 12:34:53  weitz
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-03-06 15:34:26  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-02-27 08:24:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-01-21 14:58:42  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.patient.gui;

/**
 * Interface to sepparate the icon constants from the main PatientManagerModule class
 * 
 * 
 * @author martin.heinemann@tudor.lu
 * 21.01.2008
 * 12:44:36
 *
 *
 * @version
 * <br>$Log: PatientManagerIconNames.java,v $
 * <br>Revision 1.26  2013-12-17 12:55:19  ferring
 * <br>icon names corrected
 * <br>
 * <br>Revision 1.25  2013-12-04 16:36:55  troth
 * <br>Add EPSOS button to patient view to open the epsos website.
 * <br>
 * <br>Revision 1.24  2013-12-04 16:01:14  troth
 * <br>Add EPSOS button to patient view to open the epsos website.
 * <br>
 * <br>Revision 1.23  2013-12-04 13:15:01  troth
 * <br>Add EPSOS button to patient view to open the epsos website.
 * <br>
 * <br>Revision 1.22  2013-07-10 16:28:43  troth
 * <br>Add lab talon button in patient view.
 * <br>
 * <br>Revision 1.21  2013-01-23 16:50:50  troth
 * <br>add new GUI for the MM Export tab the PatientExportPanel.
 * <br>
 * <br>Revision 1.20  2012-10-03 12:24:33  troth
 * <br>Implement ticket #1000.
 * <br>
 * <br>Revision 1.19  2012-07-12 15:50:32  troth
 * <br>Implementation of Ticket #1003.
 * <br>
 * <br>Revision 1.18  2012-03-05 10:09:14  troth
 * <br>Add new MedLogin Button in patient panel on the functionbar.
 * <br>
 * <br>Revision 1.17  2011-02-28 15:41:45  troth
 * <br>To provide smaller resolutions for the user interface add the navigation bar icons and function bar icons to the user setting "use small icons"
 * <br>
 * <br>Revision 1.16  2009-10-30 09:58:55  hermen
 * <br>added departed status to patient
 * <br>
 * <br>Revision 1.15  2009-03-16 14:17:27  hermen
 * <br>added patient incident statistics
 * <br>
 * <br>Revision 1.14  2009-02-27 15:25:56  hermen
 * <br>added button to create an empty incident for a patient visit
 * <br>
 * <br>Revision 1.13  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.12  2008-09-04 14:54:22  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.11  2008-07-07 12:07:57  heinemann
 * <br>complete - # 156: Add feedback to password dialog for superman mode
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/156
 * <br>
 * <br>Revision 1.10  2008-07-04 15:49:32  heinemann
 * <br>omplete - # 134: Antecedents cacher
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/134
 * <br>
 * <br>Revision 1.9  2008-07-04 13:38:17  heinemann
 * <br>Complete - task 5: Create Icon for History List Views
 * <br>
 * <br>Revision 1.8  2008-06-17 09:29:45  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2008-06-03 12:59:11  weitz
 * <br>*letter package, release candidate
 * <br>
 * <br>Revision 1.6  2008-04-09 12:38:23  hermen
 * <br>fixed icons and translations
 * <br>
 * <br>Revision 1.5  2008-04-07 16:56:06  mack
 * <br>Removed physician icon name because it already is now defined GECAMedIconNames
 * <br>
 * <br>Revision 1.4  2008-03-27 12:34:53  weitz
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-03-06 15:34:26  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2008-02-27 08:24:38  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-01-21 14:58:42  heinemann
 * <br>code cleanup and java doc
 * <br>
 *   
 */
public interface PatientManagerIconNames {
	/* ******************************************************************
	 *   Fields for icons
	 */

    public static final String PATIENT 						 = "patient.png";
    public static final String PATIENT_VISITED 				 = "patient_visited.png";
    public static final String PATIENT_NEW 					 = "patient_new_action.png";
    public static final String PATIENTS 					 = "patientsearch.png";
    public static final String PATIENT_EXPORT				 = "patientsearch.png"; // TODO other icon
    public static final String PATIENT_FILE 				 = "patient_file.png";
    public static final String PATIENT_FOTO  				 = "patient_foto.png";
    public static final String PATIENT_NEXT  				 = "next_patient.png";
    public static final String PATIENT_PREVIOUS 			 = "previous_patient.png";
    public static final String COPY_PATIENT 				 = "copypatient.png";
    public static final String COPY_FROM_PATIENT 			 = "copyfrompatient.png";

    public static final String PATIENT_ADMINSTRATIVE_MODULES = "administrative_modules.png";
	public static final String PATIENT_MODULES 				 = "patient_modules.png";

    public static final String ADDRESS_PRIVAT 			 	 = "privat.png";
    public static final String ADDRESS_WORK 				 = "work.png";
    public static final String ADDRESS_BILLING 				 = "billing.png";
    public static final String ADDRESS_HIS 					 = "hospitalisation.png";
	public static final String PATIENT_ADMINSTRATIVE 		 = "patient_adminstrative.png";

    // dossier
    public static final String VIEW_STATISTICS  			 = "viewmag.png";
    public static final String NO_PREVIEW 					 = "no_preview.png";
    public static final String LEAF_DEFAULT 				 = "template_source.png";

    // html editor
    public static final String EDIT_CUT 					 = "editcut.png";
    public static final String EDIT_COPY 					 = "editcopy.png";
    public static final String EDIT_PASTE 					 = "editpaste.png";
    public static final String TEXT_BOLD 					 = "text_bold.png";
    public static final String TEXT_ITALIC 					 = "text_italic.png";
    public static final String TEXT_UNDER 					 = "text_under.png";
    public static final String TEXT_LEFT 					 = "text_left.png";
    public static final String TEXT_RIGHT 					 = "text_right.png";
    public static final String TEXT_CENTER					 = "text_center.png";

//    // incident

    public static final String FINDING 						 = "finding.png";
 
    public static final String IMPORTANT 					 = "important.png";
    public static final String NOT_IMPORTANT				 = "notimportant.png";

    public static final String ACCIDENT 					 = "accident.png";

    public static final String FEMALE  						 = "female.png";
    public static final String MALE 							 = "male.png";


    public static final String ADD 							 = "button_add_line.png";
    public static final String LINK 						 = "link.png";
    public static final String LINK_NOT 					 = "link_not.png";
    public static final String LINK_SPACE 					 = "link_space.png";


    public static final String INCIDENT_DEFAULT 			 = "incident_default.png";
    public static final String INCIDENT_CLOSED 				 = "incident_closed.png";
    public static final String INCIDENT_WORK 				 = "incident_work.png";
    public static final String INCIDENT_IMPORTANT			 = "incident_important.png";
//
    public static final String HOSPITALISATION 				 = "hospitalisation.png";
//

    public static final String HOSPITALISATION_PERIODE_AMBULATORY = "ambulatory.png";
    public static final String HOSPITALISATION_PERIODE_FIRSTCLASS = "firstclass.png";
    public static final String HOSPITALISATION_PERIODE_SECONDCLASS = "secondclass.png";

    public static final String EMPTY_ICON 					 = "emptyicon.png";
    public static final String EMPTY_ICON16 				 = "emptyicon.png";
    public static final String HOSP_PASSAGE 				 = "hosp_passage.png";
    public static final String REPORT16 					 = "report16.png";
    public static final String HOSP_REPORT 					 = "hosp_report.png";
	public static final String HOSP_PRESCRIPTION 			 = "hosp_prescription.png";
	public static final String RX 							 = "radiology.png";

    public static final String ANAMNESIS 					 = "anamnesis.png";

    public static final String MEASUREMENT 					 = "designer.png";
    
    public static final String IDTAG	 					 = "idtag.png";

//    //  mimetypes
//    public static final String MIME_DIAGNOSIS 				 = "mime_diagnosis2.png";
//    public static final String MIME_FILE 					 = "mime_file.png";
//    public static final String MIME_EMPTY  					 = "mime_empty.png";
//    public static final String MIME_IMAGE 					 = "mime_image.png";
//    public static final String MIME_PDF 					 = "mime_pdf.png";
//    public static final String MIME_PRESCRIPTION 			 = "mime_prescription2.png";
    
    
    public static final String MIME_AUDIO	= "mime_audio.png";
    public static final String MIME_FORMULA	= "mime_formula.png";
    public static final String MIME_IMAGE	= "mime_image.png";
    public static final String MIME_LETTER	= "mime_letter.png";
    public static final String MIME_PDF		= "mime_pdf.png";
    public static final String MIME_SPREAD	= "mime_spreadsheet.png";
    public static final String MIME_TEXT	= "mime_text.png";
    public static final String MIME_VIDEO	= "mime_video.png";
    public static final String MIME_UNKNOWN	= "mime_unknown.png";
    public static final String MIME_WORD	= "mime_word.png";
    public static final String MIME_WRITER	= "mime_writer.png";

    
    public static final String BUTTON_OK 					= "button_ok.png";
    public static final String BUTTON_CANCEL 				= "button_cancel.png";
    public static final String BUTTON_RUNNING 				= "button_running.png";
    public static final String BUTTON_ADD_LINE 				= "button_add_line.png";
    public static final String BUTTON_DELETE_LINE 			= "button_delete_line.png";

    public static final String PASSAGE_UNVERIFIED 			= "passage_unverified.png";
    public static final String PASSAGE_VERIFIED 			= "passage_verified.png";

    public static final String ARROW_DOUBLE_UP 				= "arrowdoubleup.png";
    public static final String ARROW_DOUBLE_DOWN 			= "arrowdoubledown.png";

    public static final String MODIFY 						= "work.png";

    public static final String CHILD 						= "child.png";

    public static final String WARNING_LOCKED 				= "locked_warning.png";
    public static final String QUESTION 					= "question.png";
    
    public static final String E_KOMPASS 					= "ekompass.png";
    public static final String E_RISK 						= "erisk.png";
	
    public static final String ADD_FILE 					= "add_file.png";
    
    public static final String LOCKED						= "locked.png";
    public static final String UNLOCKED						= "unlocked.png";
    
    public static final String MEDLOGIN						= "medlogin.png";
    public static final String MEDLOGIN_ICON				= "medlogin_icon.png";
    
    public static final String CYBERLAB						= "cyberlab_ketterthill.png";
    public static final String CYBERLAB_ICON				= "cyberlab_ketterthill_icon.png";
    
    public static final String LABTALON_ICON				= "resmed_icon.png";
    
    public static final String LAB_BUTTON					= "labButton.png";
    
    public static final String EPSOS_ICON_24				= "epSOS_24.png";
    public static final String EPSOS_ICON_16				= "epSOS_16.png";
    
	/* ------------------------------------------------------ */
    // icons for consultation
    public static final String SOAP_S = "s.png";
    public static final String SOAP_O = "o.png";
    public static final String SOAP_A = "a.png";
    public static final String SOAP_P = "p.png";

    public static final String ACCIDENT_SMALL = "accident_small.png";

    /* ------------------------------------------------------- */
    // icons for simple view
    public static final String BW_ADDRESS 	= "bw_address.png";
    public static final String BW_PHONE   	= "bw_phone.png";
    public static final String BW_JOB 		= "bw_job.png";
    public static final String BW_BIRTH 	= "bw_birth.png";
    
    public static final String LAST_VISIT 	= "last_visit.png";
    public static final String UCM 			= "ucm.png";
    
    public static final String ADD_NEW		= "add.png";
    public static final String PHONE        = "phone.png";
    public static final String BILLING_ALT  = "billing_alt.png";
    
    public static final String OPEN_INVOICE = "open_invoice.png";
    
    public static final String OPEN_PATIENT_IN_TAB = "open_patient_in_tab.png";
    
    public static final String ADD_PATIENT_TO_EXPORT = "add.png"; //TODO other icon
    // history lists
    public static final String HISTORY_LISTS = "history_lists.png";
    
    // settings
    public static final String VIEW_ROW 		= "view_row.png";
    public static final String VIEW_COLUMN 		= "view_column.png";
    
    public static final String WAITINGROOM 		= "waitingroombutton.png";
    public static final String WAITINGROOM_SMALL = "waitingroombutton_small.png";
	public static final String TEMPLATE			= "template.png";
	
	public static final String PUBLIC 			= "public.png";
	public static final String PRIVATE			= "private.png";
	
	public static final String ICON_STATISTIC = "statistic.png";
	
	public static final String ICON_DEPARTED = "departed.png";
	
	public static final String CHECKBOX_SELECTED = "checkbox_selected.png";
	public static final String CHECKBOX_NOT_SELECTED = "checkbox_not_selected.png";
	
}
