/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui;

import java.awt.Component;
import java.util.Vector;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;

/**
 * creates a Navigationbar with PatientButtonPanels
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 */
public class PatientNaviBar extends JPanel {

	private static final long serialVersionUID = 1L;
	public static final int TOP = 1;
	public static final int BOTTOM = 2;
	private CellConstraints cc;
	private FormLayout layout;
	private int pos = 2;
	
	private Vector<JComponent> components = new Vector<JComponent>();
	
	
	/**
	 * 
	 */
	public PatientNaviBar() {
		/* ================================================== */
		this.setOpaque(false);
		this.layout = new FormLayout("1dlu, pref:grow, 1dlu", "1dlu, pref:grow");
		//this.layout = new FormLayout("1dlu, 60dlu, 1dlu", "1dlu, pref:grow");
		this.setLayout(layout);	
		this.cc = new CellConstraints();
		
		
		this.setBorder(BorderFactory.createRaisedBevelBorder());
		/* ================================================== */
	}
	
	/**
	 * @param width the width of the panel
	 */
	public PatientNaviBar(int width) {
		/* ================================================== */
		this.setOpaque(false);
		this.layout = new FormLayout("1dlu, " + width + "dlu, 1dlu", "1dlu, pref:grow");
		this.setLayout(layout);	
		this.cc = new CellConstraints();
		
		
		this.setBorder(BorderFactory.createRaisedBevelBorder());
		/* ================================================== */
	}
	
	/**
	 * Adds a panel to the navi bar
	 * 
	 * @param buttonPanel
	 * @param alignment PatientNaviBar.TOP or PatientNaviBar.BOTTOM
	 */
	public void addButtonPanel(JComponent buttonPanel, int alignment) {
		/* ================================================== */
		addButtonPanel(buttonPanel, alignment, false);
		/* ================================================== */
	}
	
	/**
	 * Adds a panel to the navi bar
	 * 
	 * @param buttonPanel
	 * @param alignment  PatientNaviBar.TOP or PatientNaviBar.BOTTOM
	 * @param alwaysEnabled if true, the panel will be always enabled.
	 */
	public void addButtonPanel(JComponent buttonPanel, int alignment, boolean alwaysEnabled) {
		if (alignment == TOP) {
			this.layout.insertRow(pos, new RowSpec("pref"));
			this.add(buttonPanel, cc.xy(2, pos));
			pos++;
			this.layout.insertRow(pos, new RowSpec("3dlu"));
			pos++;
		} else {
			this.layout.appendRow(new RowSpec("pref"));
			this.add(buttonPanel, cc.xy(2, layout.getRowCount()));
			this.layout.appendRow(new RowSpec("3dlu"));
		}
		if (!alwaysEnabled)
			this.components.add(buttonPanel);
	}
	
	
	/**
	 * @param b
	 */
	public void enablePanels(boolean b) {
		/* ================================================== */
		for (JComponent c : this.components)
			enableSubPanel(c, b);
		/* ================================================== */
	}
	
	
	/**
	 * To understand the recursion, you have to understand the recursion.
	 * 
	 * @param parent
	 * @param b
	 */
	private void enableSubPanel(JComponent parent, boolean b) {
		/* ================================================== */
		parent.setEnabled(b);
		if (parent.getComponents() != null)
			for (Component sc : parent.getComponents()) {
				sc.setEnabled(b);
				if (sc instanceof JComponent)
					enableSubPanel((JComponent) sc, b);
			}
				
		/* ================================================== */
	}
	
	
//	/**
//	 * creates a Demo PatientNaviBar 
//	 * @param args
//	 */
//	public static void main(String[] args) {
//		JFrame jf = new JFrame("PatientNaviBar Demo");
//		jf.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
//		
//		PatientNaviBar bar = new PatientNaviBar();
//		
//		Vector<AbstractButton> v = new Vector<AbstractButton>();
//		v.add(new JToggleButton("A"));
//		v.add(new JToggleButton("B"));
//		v.add(new JToggleButton("C"));
//		v.add(new JToggleButton("D"));
//		v.add(new JToggleButton("E"));
//		v.add(new JToggleButton("F"));
//		bar.addButtonPanel(new PatientButtonPanel("Navigation", Color.CYAN, 3,  v), TOP);
//		
//		Vector<AbstractButton> v1 = new Vector<AbstractButton>();
//		v1.add(new JButton("Verschreibung"));
//		v1.add(new JButton("Trait Chron."));
//		v1.add(new JButton("Transfer"));
//		bar.addButtonPanel(new PatientButtonPanel("Funktionen", Color.GREEN, 1, v1), TOP);
//		
//		Vector<AbstractButton> v2 = new Vector<AbstractButton>();
//		v2.add(new JButton("C1"));
//		v2.add(new JButton("V1"));
//		v2.add(new JButton("345"));
//		v2.add(new JButton("456"));
//		v2.add(new JButton("dfg"));
//		v2.add(new JButton("768"));
//		v2.add(new JButton("gfh"));
//		v2.add(new JButton("234"));
//		v2.add(new JButton("klö"));
//		v2.add(new JButton("fgh"));
//		v2.add(new JButton("sdf"));
//		v2.add(new JButton("gh"));
//		bar.addButtonPanel(new PatientButtonPanel("Facturation", Color.RED, 2, v2), BOTTOM);
//		
//		Vector<AbstractButton> v3 = new Vector<AbstractButton>();
//		v3.add(new JToggleButton("1 Peter Maier"));
//		v3.add(new JToggleButton("2 Karl Hans"));
//		v3.add(new JToggleButton("3 Ranseier Karl"));
//		v3.add(new JToggleButton("4 Graf Steffi"));
//		bar.addButtonPanel(new PatientButtonPanel("Clients", Color.YELLOW, 1, v3), BOTTOM);
//		
//		jf.add(bar);
//		jf.setSize(160,600);
//		jf.setVisible(true);
//	}
	
	
	
	
}
