/*****************************************************************************
 *                                                                           *
 *  Copyright (c) 2010 by SANTEC/TUDOR www.santec.tudor.lu                   *
 *                                                                           *
 *                                                                           *
 *  This library is free software; you can redistribute it and/or modify it  *
 *  under the terms of the GNU Lesser General Public License as published    *
 *  by the Free Software Foundation; either version 2 of the License, or     *
 *  (at your option) any later version.                                      *
 *                                                                           *
 *  This software is distributed in the hope that it will be useful, but     *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of               *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU        *
 *  Lesser General Public License for more details.                          *
 *                                                                           *
 *  You should have received a copy of the GNU Lesser General Public         *
 *  License along with this library; if not, write to the Free Software      *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA  *
 *                                                                           *
 *****************************************************************************/
package lu.tudor.santec.gecamed.patient.gui;

import java.awt.Dimension;
import java.util.Collection;

import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedTab;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.IncidentEntry;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.usermanagement.gui.settings.UserSettingsPlugin;

import org.apache.log4j.Logger;

/**
 * Classes that extendas this class represent a submodule of the patient module.
 * They are displayed inside the patient module and can place a button in the navigation
 * bar on the right of the screen.
 * 
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: PatientViewTab.java,v $
 * <br>Revision 1.12  2013-12-27 18:09:16  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.11  2013-07-15 06:18:35  ferring
 * <br>logging changed
 * <br>
 * <br>Revision 1.10  2011-02-28 15:41:45  troth
 * <br>To provide smaller resolutions for the user interface add the navigation bar icons and function bar icons to the user setting "use small icons"
 * <br>
 * <br>Revision 1.9  2010-11-23 13:30:17  ferring
 * <br>checking on java version, before enabling the form editor tools
 * <br>
 * <br>Revision 1.8  2010-09-20 13:38:37  troth
 * <br>add delete function on (right-click) history popupmenu for S.O.A.P. entries and measurements
 * <br>
 * <br>Revision 1.7  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.6  2008-06-05 10:14:18  hermen
 * <br>set Focus to panel if it gets visible
 * <br>
 * <br>Revision 1.5  2008-03-12 10:30:06  hermen
 * <br>changed PatientViewTab to abstract and added getName() method
 * <br>
 * <br>Revision 1.4  2008-01-21 14:58:42  heinemann
 * <br>code cleanup and java doc
 * <br>
 * <br>Revision 1.3  2007/04/17 14:51:26  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.2  2007/03/02 08:28:38  hermen
 * <br>initial checkin after the merge of PatientModuleRebuild with the main HEAD
 * <br>
 * <br>Revision 1.1.2.3  2006/12/14 13:06:08  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1.2.2  2006/12/14 09:16:55  hermen
 * <br>made smaller
 * <br>
 * <br>Revision 1.1.2.1  2006/12/06 07:49:55  heinemann
 * <br>*** empty log message ***
 * <br>
 */
public abstract class PatientViewTab extends GECAMedTab {

	private static final long serialVersionUID = 1L;
	
	protected PermanentlyDisableableToggleButton button = new PermanentlyDisableableToggleButton();

	/** the logger Object for this class */
	private static Logger logger = Logger.getLogger(PatientViewTab.class.getName());

	
	/**
	 * returns the name of this tab, should be a static String.
	 * @return the name of this tab
	 */
	public abstract String getName();
	

	public void setPatient(Patient patient) {
		System.out.println("setPatient not implemented in Class: " + this.getClass().getSimpleName());
	}


	public JToggleButton getButton() {
		return button;
	}


	/**
	 * @param tabToolTip The tabToolTip to set.
	 */
	public void setTabToolTip(String tabToolTip) {

		this.button.setToolTipText(tabToolTip);
		super.setTabToolTip(tabToolTip);
	}

	/**
	 * @param tabToolTip The tabToolTip to set.
	 */
	public void setTitle(String tabToolTip) {

		this.button.setToolTipText(tabToolTip);
		super.setTitle(tabToolTip);
	}


	/**
	 * sets the icon of the Tab
	 * @param tabIcon The Icon to set.
	 */
	public void setIcon(ImageIcon tabIcon) {
		try {
			if((Boolean) MainFrame.getInstance().userSettings.getValue(UserSettingsPlugin.SMALL_ICONS))
				tabIcon = IconFetcher.scaleIcon(tabIcon, GECAMedIconNames.SMALLPIX);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		this.button.setIcon(tabIcon);
		this.button.setPreferredSize(new Dimension(tabIcon.getIconHeight() +2, tabIcon.getIconHeight() +2));
		super.setIcon(tabIcon);
	}
	
	
	public void enableTab() {
		this.button.setEnabled(true); 
		super.enableTab();
	}
	
	
	public void disableTab() {
		this.button.setEnabled(false);
		super.disableTab();
	}
	
	
	public Collection<JComponent> getActionComponents() {
		/* ====================================================== */
		logger.info("getActionComponent not implemented in " + this.getClass());
		return null;
		/* ====================================================== */
	}


	/**
	 * fired after the Panel got visible
	 */
	public void afterShowup() {
	    // overide me if you want to...
	}

	
	/**
	 * fired after a incident entry was deleted
	 * @param entry deleted incident entry
	 */
	public void incidentEntryDeleted(IncidentEntry entry){
	    // overide me if you want to...
	}
	
	
	public void setPermanentlyDisabled (boolean flag)
	{
		button.setPermanentlyDisabled(flag);
	}
}
