/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: DuplicateSSNDialog.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-21 14:03:27  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2007/04/20 11:35:55  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/04/19 07:00:29  heinemann
 * <br>duplicate ssn numbers will now produce a warning
 * <br>
 *
 */
package lu.tudor.santec.gecamed.patient.gui.administrative;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;

/**
 * @author martin.heinemann@tudor.lu
 * 18.04.2007
 * 14:50:19
 *
 *
 * @version
 * <br>$Log: DuplicateSSNDialog.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-21 14:03:27  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2007/04/20 11:35:55  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2007/04/19 07:00:29  heinemann
 * <br>duplicate ssn numbers will now produce a warning
 * <br>
 *
 */
public class DuplicateSSNDialog extends JDialog implements MouseListener {


	private static final long serialVersionUID = 1L;

	private static DuplicateSSNDialog instance = new DuplicateSSNDialog();

	private JLabel infoLabel;

	private JButton okButton;

	private JButton cancelButton;

	private JPanel centerPanel;

	private JLabel cenNorthLabel;

	private JList<Patient> patientList;

	private AbstractAction continueAction;

	private Patient selectedPatient;

	private AbstractAction openAction;

	private DefaultListModel<Patient> listModel;



	private DuplicateSSNDialog() {
		/* ================================================== */
		super(MainFrame.getInstance(), true);

		initComponent();
		initAction();
		/* ================================================== */
	}

	public static DuplicateSSNDialog getInstace() {
		/* ================================================== */
		return instance;
		/* ================================================== */
	}

	/**
	 * @return
	 */
	public Patient getSelectedPatient() {
		/* ================================================== */
		return this.selectedPatient;
		/* ================================================== */
	}


	/**
	 * Init action for buttons and list
	 */
	private void initAction() {
		/* ================================================== */
		/* ------------------------------------------------------- */
		// the JList
//		this.patientList.addListSelectionListener(this);
		this.patientList.addMouseListener(this);
		this.patientList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		/* ------------------------------------------------------- */

		this.continueAction = new AbstractAction(Translatrix.getTranslationString("patient.ssn.continue"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.WARNING)) {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
				// set the selected patient to null
				selectedPatient = null;
				DuplicateSSNDialog.this.setVisible(false);

				/* ====================================================== */
			}
		};
		/* ------------------------------------------------------- */
		this.openAction = new AbstractAction(Translatrix.getTranslationString("patient.ssn.open"),
				GECAMedModule.getSmallIcon(GECAMedIconNames.OK)) {

			private static final long serialVersionUID = 1L;

			public void actionPerformed(ActionEvent e) {
				/* ====================================================== */
				if (patientList.getSelectedIndex() > -1) {
					// set the patient
					selectedPatient = (Patient) patientList.getSelectedValue();
					DuplicateSSNDialog.this.setVisible(false);
				}
				/* ====================================================== */
			}
		};

		okButton.setAction(openAction);
		cancelButton.setAction(continueAction);

		/* ------------------------------------------------------- */
		// define dialog wide key mappings
		KeyStroke strokeEsc = KeyStroke.getKeyStroke("ESCAPE");

		((JPanel) this.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.put(strokeEsc, "continue");
		((JPanel) this.getContentPane()).getActionMap().put("continue", continueAction);


		KeyStroke strokeEnter = KeyStroke.getKeyStroke("ENTER");

		((JPanel) this.getContentPane()).getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT)
					.put(strokeEnter, "open");
		((JPanel) this.getContentPane()).getActionMap().put("open", openAction);

		/* ================================================== */
	}


	/* (non-Javadoc)
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e) {
		/* ====================================================== */
		if (SwingUtilities.isLeftMouseButton(e)
				&& e.getClickCount() == 2) {
			this.openAction.actionPerformed(null);
		}
		/* ====================================================== */
	}

	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}


	/**
	 *
	 */
	private void initComponent() {
		/* ====================================================== */
		this.setLayout(new BorderLayout(0, 10));
		this.getContentPane().setBackground(Color.WHITE);

		this.add(new JLabel("  "), BorderLayout.WEST);
		this.add(new JLabel(" "), BorderLayout.EAST);
		/* ------------------------------------------------------- */
		// in the north --> info label
		this.infoLabel = new JLabel();
		infoLabel.setIcon(GECAMedModule.getMediumIcon(GECAMedIconNames.WARNING));
		infoLabel.setHorizontalTextPosition(SwingConstants.RIGHT);
		infoLabel.setText(Translatrix.getTranslationString("patient.ssn.duplicateHeader"));
		infoLabel.setFont(new Font(infoLabel.getFont().getFontName(),infoLabel.getFont().getStyle(), 18));
		infoLabel.setOpaque(false);

		/* ------------------------------------------------------- */
		this.add(infoLabel, BorderLayout.NORTH);
		/* ------------------------------------------------------- */
		// in the south --> Buttons
		this.okButton = new JButton();
		this.cancelButton = new JButton();

		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addGlue();
		bb.addGridded(cancelButton);
		bb.addRelatedGap();
		bb.addGridded(okButton);
		bb.getPanel().setOpaque(false);
		/* ------------------------------------------------------- */
		// a panel to make a gap between the dialog border and the buttons
		JPanel gapPanel = new JPanel(new BorderLayout(5,5));
		gapPanel.setOpaque(false);
		gapPanel.add(bb.getPanel(), BorderLayout.CENTER);
		gapPanel.add(new JLabel(""), BorderLayout.SOUTH);
		gapPanel.add(new JLabel(""), BorderLayout.EAST);
		/* ------------------------------------------------------- */
		this.add(gapPanel, BorderLayout.SOUTH);
		/* ------------------------------------------------------- */


		/* ------------------------------------------------------- */
		/* ------------------------------------------------------- */
		// in the center --> panel
		this.centerPanel = new JPanel(new BorderLayout());
		this.centerPanel.setOpaque(false);
		this.centerPanel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
		/* ------------------------------------------------------- */
		// in the north --> text
		this.cenNorthLabel = new JLabel(Translatrix.getTranslationString("patient.ssn.openDuplicateQuestion")+"<br><br>");
		/* ------------------------------------------------------- */
		// listmodel
		this.listModel = new DefaultListModel<Patient>();
		this.patientList = new JList<Patient>(listModel);
		/* ------------------------------------------------------- */
		JScrollPane scroll = new JScrollPane(this.patientList);
		scroll.getViewport().setOpaque(false);
		scroll.setOpaque(false);
		/* ------------------------------------------------------- */
		this.centerPanel.add(cenNorthLabel, BorderLayout.NORTH);
		this.centerPanel.add(scroll, BorderLayout.CENTER);

		this.centerPanel.add(new JLabel(" "), BorderLayout.EAST);
//		this.centerPanel.add(new JLabel(" "), BorderLayout.WEST);
		/* ------------------------------------------------------- */
		/* ------------------------------------------------------- */
		// assemble the parent panel
		this.add(centerPanel, BorderLayout.CENTER);
		/* ====================================================== */
	}

	/**
	 * Show the dialog
	 *
	 * @param data
	 */
	public void showDialog(List<Patient> data) {
		/* ================================================== */
		this.selectedPatient = null;
		if (data == null || data.size() < 1)
			return;
		/* ------------------------------------------------------- */
//		listModel.setData(data);
		listModel.removeAllElements();
		for (Patient patient : data) {
			listModel.addElement(patient);		
		}
		/* ------------------------------------------------------- */
		// select the first item
		patientList.setSelectedIndex(0);
		patientList.requestFocus();
		/* ------------------------------------------------------- */
		// show
		this.pack();
		MainFrame.showDialogCentered(this);
		/* ================================================== */
	}

}
