/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.administrative;

import java.awt.Component;
import java.util.List;

import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;

/**
 * Interface for all administrative patient data panels
 * 
 *
 * @version
 * <br>$Log: IPatientDataPanel.java,v $
 * <br>Revision 1.6  2009-05-29 13:51:21  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-04-16 14:24:28  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.3  2008-01-21 14:03:27  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public interface IPatientDataPanel {

    /**
     * retrieves the filled patient object from the panel 
     * @param patient the patient object
     */
    public void getPatient(Patient patient) ;
    
    /**
     * sets the patient object to the panel
     * @param patient the patient object
     * @param editable should the panel be editable
     */
    public void setPatient(Patient patient, boolean editable) ;
    
    /**
     * @return
     */
    public List<Component> getComponentsForFocus();

    public boolean isFilledOK();
    
	
}
