/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
/**
 * @author Martin Heinemann martin.heinemann@tudor.lu
 *
 *
 *
 * @version
 * <br>$Log: PatientBasicAdminInfoPanel.java,v $
 * <br>Revision 1.10  2013-12-27 18:08:02  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.9  2010-03-12 14:13:17  hermen
 * <br>icon cleanup
 * <br>
 * <br>Revision 1.8  2009-05-29 13:51:21  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2009-01-07 08:54:15  hermen
 * <br>small bugfixes
 * <br>
 * <br>Revision 1.6  2008-10-16 14:53:07  heinemann
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/220
 * <br>a new patient is alway "modified" even if nothing has changed
 * <br>
 * <br>focus handling problem
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-06-09 11:54:18  hermen
 * <br>fixed patient panel rights
 * <br>
 * <br>Revision 1.3  2008-06-05 10:14:18  hermen
 * <br>set Focus to panel if it gets visible
 * <br>
 * <br>Revision 1.2  2008-06-04 12:54:01  hermen
 * <br>fixed copy patient address to assure address
 * <br>
 * <br>Revision 1.1  2008-04-16 14:24:28  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-04-15 16:01:03  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
package lu.tudor.santec.gecamed.patient.gui.administrative;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JSeparator;

import lu.tudor.santec.gecamed.core.gui.widgets.HeaderedPanel;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientAddress;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author martin.heinemann@tudor.lu
 * 15.04.2008
 * 15:34:52
 *
 *
 * @version
 * <br>$Log: PatientBasicAdminInfoPanel.java,v $
 * <br>Revision 1.10  2013-12-27 18:08:02  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.9  2010-03-12 14:13:17  hermen
 * <br>icon cleanup
 * <br>
 * <br>Revision 1.8  2009-05-29 13:51:21  hermen
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.7  2009-01-07 08:54:15  hermen
 * <br>small bugfixes
 * <br>
 * <br>Revision 1.6  2008-10-16 14:53:07  heinemann
 * <br>http://santec.tudor.lu/trac/gecamed/ticket/220
 * <br>a new patient is alway "modified" even if nothing has changed
 * <br>
 * <br>focus handling problem
 * <br>
 * <br>Revision 1.5  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.4  2008-06-09 11:54:18  hermen
 * <br>fixed patient panel rights
 * <br>
 * <br>Revision 1.3  2008-06-05 10:14:18  hermen
 * <br>set Focus to panel if it gets visible
 * <br>
 * <br>Revision 1.2  2008-06-04 12:54:01  hermen
 * <br>fixed copy patient address to assure address
 * <br>
 * <br>Revision 1.1  2008-04-16 14:24:28  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2008-04-15 16:01:03  heinemann
 * <br>*** empty log message ***
 * <br>
 *   
 */
public class PatientBasicAdminInfoPanel extends HeaderedPanel implements IPatientDataPanel {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private PatientAdminPanel patientEditPanel;
	private PatientGeneralDataPanel generalTop;
	private PatientGeneralDataBottomPanel generalBottom;
	private PatientAddressInfo addressPanel;

	public PatientBasicAdminInfoPanel (PatientAdminPanel patientEditPanel) {
		/* ================================================== */
		this.setOpaque(false);
        this.patientEditPanel = patientEditPanel;
        this.buildPanel();
		/* ================================================== */
	}
	
	private void buildPanel() {
		/* ====================================================== */
        this.setLayout(new FormLayout("3dlu, fill:100dlu:grow, 3dlu", "2dlu,fill:pref,2dlu,fill:pref,2dlu,bottom:5dlu,2dlu,fill:pref,2dlu"));
        // ===============================================================
        // set the header infos, text and icon
        //
        // ===============================================================
        this.setHeader(Translatrix.getTranslationString("pm.generalInfo")+":");
//        this.setHeaderIcon(PatientManagerModule.getMediumIcon(PatientManagerModule.PATIENT_ADMINSTRATIVE));
        
        // ================================================================
        this.generalTop = new PatientGeneralDataPanel(this.patientEditPanel);
        this.generalBottom = new PatientGeneralDataBottomPanel( this.patientEditPanel);
        this.addressPanel = new PatientAddressInfo(				this.patientEditPanel);
       /* ------------------------------------------------------- */
        CellConstraints cc = new CellConstraints();
        this.add(generalTop,    cc.xy(2, 2));
        this.add(addressPanel,  cc.xy(2, 4));
        this.add(new JSeparator(), cc.xy(2, 6));
        this.add(generalBottom, cc.xy(2, 8));
		/* ====================================================== */
	}

 
//	/**
//	 * 
//	 */
//	private void installFocusTraversalPolicy() {
//		/* ================================================== */
//		GECAMedFocusTraversalPolicy policy = new GECAMedFocusTraversalPolicy();
//		/* ------------------------------------------------------- */
//		for (JComponent c: generalTop.getComponentsForFocus()) {
//			/* ------------------------------------------------------- */
//			policy.add(c);
//			/* ------------------------------------------------------- */
//		}
//		/* ------------------------------------------------------- */
//		for (JComponent c: generalBottom.getComponentsForFocus()) {
//			/* ------------------------------------------------------- */
//			policy.add(c);
//			/* ------------------------------------------------------- */
//		}
//		MainFrame.getInstance().setFocusTraversalPolicy(policy);
//		/* ================================================== */
//	}
	
	
	public void getPatient(Patient patient) {
		/* ====================================================== */
		generalTop.getPatient(patient);
		addressPanel.getPatient(patient);
		generalBottom.getPatient(patient);
		/* ====================================================== */
	}

	public void setPatient(Patient patient, boolean editable) {
		/* ====================================================== */
		generalTop.setPatient(patient, editable);
		generalBottom.setPatient(patient, editable);
		addressPanel.setPatient(patient, editable);
		/* ====================================================== */
	}



	public List<Component> getComponentsForFocus() {
		/* ====================================================== */
		List<Component> list = new ArrayList<Component>();
		
		list.addAll(generalTop.getComponentsForFocus());
		list.addAll(addressPanel.getComponentsForFocus());
		list.addAll(generalBottom.getComponentsForFocus());
		
		return list;
		/* ====================================================== */
	}
	
	public void getAddress(PatientAddress address) {
	    this.addressPanel.getAddress(address);
	}

	public void getFocus() {
	    try {
		this.generalTop.getFocus();
	    } catch (Exception e) {}
	}

	public boolean isFilledOK() {
	    if (! generalTop.isFilledOK())
		return false;
	    if (! generalBottom.isFilledOK())
		return false;
	    if (! addressPanel.isFilledOK())
		return false;
	    return true;
	}
}
