package lu.tudor.santec.gecamed.patient.gui.administrative;

import java.util.List;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

import lu.tudor.santec.gecamed.core.gui.widgets.GECAMedBaseDialogImpl;
import lu.tudor.santec.gecamed.patient.ejb.session.beans.PatientAdminBean;
import lu.tudor.santec.gecamed.patient.utils.PatientNameFormat;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * @author jens.ferring(at)tudor.lu
 * 
 * @version
 * <br>$Log: PatientNameFormatTask.java,v $
 * <br>Revision 1.1  2013-03-26 10:25:49  ferring
 * <br>Option added in admin settings, to format the patient names
 * <br>
 */

public class PatientNameFormatTask extends GECAMedBaseDialogImpl implements Runnable
{
	/* ======================================== */
	// 		CONSTANTS
	/* ======================================== */
	
	private static final long	serialVersionUID	= 8214625853179427700L;
	
	
	
	/* ======================================== */
	// 		MEMBERS
	/* ======================================== */
	
	private List<PatientNameFormat> options;
	
	private Thread					task;
	
	private JLabel					description;
	
	private JProgressBar			progressBar;
	
	
	
	/* ======================================== */
	// 		CONSTRUCTORS
	/* ======================================== */
	
	public PatientNameFormatTask (JDialog owner, List<PatientNameFormat> options)
	{
		super(owner,
				Translatrix.getTranslationString("AdministrativeElementsPlugin.formatPatientNameProgressTitle"), 
				OK_BUTTON_MODE);
		
		this.options	= options;
		initialize();
	}
	
	
	
	/* ======================================== */
	// 		CLASS BODY
	/* ======================================== */
	
	private void initialize ()
	{
		CellConstraints	cc	= new CellConstraints();
//		setModalityType(ModalityType.MODELESS);
		
		description	= new JLabel();
		description.setOpaque(false);
		
		progressBar	= new JProgressBar();
		progressBar.setValue(progressBar.getMaximum());
		progressBar.setOpaque(false);
		
		mainPanel.setLayout(new FormLayout("5px, f:p, 5px", 
				" 5px,f:p," +	// description
				"15px,f:p," +	// progress bar
				"10px"));
		mainPanel.add(description, cc.xy(2, 2));
		mainPanel.add(progressBar, cc.xy(2, 4));
		setResizingOptions(RESIZING_NONE);
	}
	
	
	public void run ()
	{
		// perform the task
		PatientAdminBean.getInstance().formatPatientNames(options);
		
		// finished ...
		progressBar.setIndeterminate(false);
		description.setText(Translatrix.getTranslationString(
				"AdministrativeElementsPlugin.formatPatientNameProgressSuccessMessage"));
		okButton.setEnabled(true);
		pack();
		setLocationRelativeTo(getOwner());
	}
	
	
	public void start ()
	{
		if (task != null && task.isAlive())
			return;

		// prepare the dialog
		okButton.setEnabled(false);
		description.setText(Translatrix.getTranslationString(
				"AdministrativeElementsPlugin.formatPatientNameProgressMessage"));
		progressBar.setIndeterminate(true);
		
		// show the dialog
		pack();
		setLocationRelativeTo(getOwner());
		
		task	= new Thread(this);
		task.start();
		
		setVisible(true);
	}
	
	
	@Override
	public void okActionCalled ()
	{
		if (!task.isAlive())
			super.okActionCalled();
	}
	
	
	@Override
	public void closeActionCalled ()
	{
		if (!task.isAlive())
			super.closeActionCalled();
	}
}
