/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.administrative;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

import lu.tudor.santec.gecamed.core.gui.GECAMedIconNames;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.IconFetcher;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * A dialog to select a relation
 * 
 * 
 * @author martin.heinemann@tudor.lu
 *
 *
 * @version
 * <br>$Log: RelationSelector.java,v $
 * <br>Revision 1.6  2013-12-27 18:07:55  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.5  2008-10-21 09:53:34  hermen
 * <br>fixed patient slot bug
 * <br>enhanced logging
 * <br>code cleanup
 * <br>
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-21 14:03:27  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 * <br>Revision 1.2  2006/09/26 14:30:28  heinemann
 * <br>*** empty log message ***
 * <br>
 * <br>Revision 1.1  2006/09/21 13:40:10  heinemann
 * <br>*** empty log message ***
 * <br>
 */
public class RelationSelector implements KeyListener {

	
	/* ********************************************************************
	 *   Class Members
	 */
	public static final int RELATION_UNDEFINED = 0;
	
	public static final int RELATION_SPOUSE = 1;
	public static final int RELATION_CHILD = 2;
	public static final int RELATION_PARENT = 3;
	
	private static RelationSelector instance = new RelationSelector();
	private JPanel content;

	private JRadioButton rbtnSpouse;

	private JRadioButton rbtnChild;

	private JRadioButton rbtnParent;

	private JDialog dia;
	
	private int result;

	private ButtonGroup group;

	private JButton cancelButton;

	private JButton okButton;

	private RelationSelector () {
		/* ====================================================== */
		buildPanel();
		/* ====================================================== */
	}
	
	/**
	 * @return
	 */
	public static RelationSelector getInstance() {
		/* ====================================================== */
		return instance;
		/* ====================================================== */
	}
	
	
	
	public void showSelector(boolean b) {
		/* ====================================================== */
		if (b) {
			/* ------------------------------------------------------ */
			this.dia = new JDialog(MainFrame.getInstance(),Translatrix.getTranslationString("pm.relation.title"), true);
			dia.add(content);
			dia.pack();
			
			group.setSelected(rbtnChild.getModel(), true);
			
			MainFrame.showDialogCentered(dia);
			/* ------------------------------------------------------ */
		} else
			dia.setVisible(b);
		/* ====================================================== */
	}
	
	
	
	
	/**
	 * Build the panel
	 */
	private void buildPanel() {
		/* ====================================================== */
		
		this.content = new JPanel(new BorderLayout());
		content.setBackground(Color.WHITE);
		
		// a panel for the upper content, everything, except the buttons
		JPanel mainContent = new JPanel(new BorderLayout());
		mainContent.setBackground(Color.WHITE);
		
		mainContent.setBorder(new TitledBorder(Translatrix.getTranslationString("pm.relation.title")));
		
		JPanel internPanel = new JPanel(new GridLayout(0 ,1));
		internPanel.setBorder(new EmptyBorder(0, 50, 0, 50));
		/* ------------------------------------------------------ */
		this.rbtnSpouse = new JRadioButton("(1) "+ Translatrix.getTranslationString("pm.relation.spouse"));
		this.rbtnChild = new JRadioButton("(2) "+Translatrix.getTranslationString("pm.relation.child"));
		this.rbtnParent = new JRadioButton("(3) "+Translatrix.getTranslationString("pm.relation.parent"));
		/* ------------------------------------------------------ */
		this.group = new ButtonGroup();
		group.add(rbtnSpouse);
		group.add(rbtnChild);
		group.add(rbtnParent);
		/* ------------------------------------------------------ */
		internPanel.add(rbtnSpouse);
		internPanel.add(rbtnChild);
		internPanel.add(rbtnParent);
		
		
		rbtnChild.setBackground(Color.WHITE);
		rbtnParent.setBackground(Color.WHITE);
		rbtnSpouse.setBackground(Color.WHITE);
		
		internPanel.setBackground(Color.WHITE);
		/* ------------------------------------------------------ */
		mainContent.add(internPanel, BorderLayout.CENTER);
		/* ------------------------------------------------------ */
		// infoLabel
		JLabel infoLabel = new JLabel(Translatrix.getTranslationString("pm.relation.introduction.to.selector"));
		infoLabel.setIcon(GECAMedModule.getMediumIcon(GECAMedIconNames.INFO));
		infoLabel.setVerticalTextPosition(JLabel.TOP);
		infoLabel.setHorizontalTextPosition(JLabel.RIGHT);
		infoLabel.setBorder(new TitledBorder(""));
		infoLabel.setFont(new Font("Arial", Font.PLAIN, 10));
		infoLabel.setBackground(Color.WHITE);
		mainContent.add(infoLabel, BorderLayout.NORTH);
		
		/* ------------------------------------------------------ */
		// functionallity
		rbtnChild.addKeyListener(this);
		rbtnParent.addKeyListener(this);
		rbtnSpouse.addKeyListener(this);
		
		content.addKeyListener(this);
		internPanel.addKeyListener(this);
		infoLabel.addKeyListener(this);
		
		rbtnChild.requestFocus();
		
		/* ------------------------------------------------------ */
		// bottom
		JLabel bottomLabel = new JLabel(Translatrix.getTranslationString("pm.relation.introduction.to.selector.footer"));
		bottomLabel.setVerticalTextPosition(JLabel.TOP);
		bottomLabel.setHorizontalTextPosition(JLabel.RIGHT);
		bottomLabel.setBorder(new TitledBorder(""));
		bottomLabel.setFont(new Font("Arial", Font.PLAIN, 10));
		bottomLabel.setBackground(Color.WHITE);
		mainContent.add(bottomLabel, BorderLayout.SOUTH);
		
		/* ------------------------------------------------------ */
		// button panel
		this.cancelButton = new JButton(Translatrix.getTranslationString("patient.cancel"),
				IconFetcher.getSmallIcon(PatientManagerModule.class, PatientManagerModule.CANCEL));
		
		this.okButton = new JButton(Translatrix.getTranslationString("patient.ok"),
			IconFetcher.getSmallIcon(PatientManagerModule.class, PatientManagerModule.OK));
		cancelButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				/* ============================================= */
				result = RELATION_UNDEFINED;
				dia.setVisible(false);
				/* ============================================= */
			}
		});

		
		okButton.addActionListener(new ActionListener() {

			public void actionPerformed(ActionEvent e) {
				/* ============================================= */
				if (rbtnChild.isSelected())
					result = RELATION_CHILD;
				else if (rbtnParent.isSelected())
					result = RELATION_PARENT;
				else if (rbtnSpouse.isSelected())
					result = RELATION_SPOUSE;
				dia.setVisible(false);
				/* ============================================= */
			}
			
		});
		
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addGridded(okButton);
		bb.addGridded(cancelButton);
		
		JPanel metaButtonPanel = new JPanel(new FormLayout("fill:pref:grow,fill:pref,fill:pref:grow", "fill:pref"));
		CellConstraints cc = new CellConstraints();
		metaButtonPanel.add(bb.getPanel(), cc.xy(2, 1));
		/* ------------------------------------------------------ */
		// assemble the main panel
		content.add(mainContent, BorderLayout.CENTER);
		// the buttons
		content.add(metaButtonPanel, BorderLayout.SOUTH);
		
		
		/* ====================================================== */
	}

	public void keyTyped(KeyEvent e) {}

	public void keyPressed(KeyEvent e) {}

	/* (non-Javadoc)
	 * @see java.awt.event.KeyListener#keyReleased(java.awt.event.KeyEvent)
	 */
	public void keyReleased(KeyEvent e) {
		/* ============================================= */
		if (e.getKeyCode() == KeyEvent.VK_UP) {
			if (rbtnParent.isSelected())
				rbtnChild.setSelected(true);
			else if (rbtnChild.isSelected())
				rbtnSpouse.setSelected(true);
			return;
		} else if(e.getKeyCode() == KeyEvent.VK_DOWN) {
			if (rbtnSpouse.isSelected())
				rbtnChild.setSelected(true);
			else if (rbtnChild.isSelected())
				rbtnParent.setSelected(true);
			return;
		}
		
		
		if (e.getKeyCode() == KeyEvent.VK_1)
			result = RELATION_SPOUSE;
		else if (e.getKeyCode() == KeyEvent.VK_2)
			result = RELATION_CHILD;
		else if (e.getKeyCode() == KeyEvent.VK_3)
			result = RELATION_PARENT;
		else if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
			result = RELATION_UNDEFINED;
		else if (e.getKeyCode() == KeyEvent.VK_ENTER) {
			/* ------------------------------------------------------ */
			if (rbtnChild.isSelected())
				result = RELATION_CHILD;
			else if (rbtnParent.isSelected())
				result = RELATION_PARENT;
			else if (rbtnSpouse.isSelected())
				result = RELATION_SPOUSE;
			/* ------------------------------------------------------ */
		} else
			return;
		
		
		this.showSelector(false);
		/* ============================================= */
	}
	
	
	
	/**
	 * Returns the result from the selection
	 * 
	 * @return
	 */
	public int getResult() {
		/* ====================================================== */
		return this.result;
		/* ====================================================== */
	}
	
}
