/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.certificate;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;

import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import lu.tudor.santec.gecamed.core.gui.GECAMedColors;
import lu.tudor.santec.gecamed.core.gui.GECAMedModule;
import lu.tudor.santec.gecamed.core.gui.MainFrame;
import lu.tudor.santec.gecamed.core.gui.utils.GECAMedGuiUtils;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Incident;
import lu.tudor.santec.gecamed.patient.gui.PatientManagerModule;
import lu.tudor.santec.i18n.Translatrix;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.toedter.calendar.JDateChooser;

/**
 * Dialog to choose the day and time of the "i was at the doctor" certificate that will be printed.
 * 
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: CertificateDialog.java,v $
 * <br>Revision 1.4  2009-02-25 13:26:09  hermen
 * <br>added siteID to incidents and invoices
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:16:33  hermen
 * <br>*** empty log message ***
 * <br>
 *
 */
public class CertificateDialog extends JDialog implements ActionListener, ComponentListener {

	private static final long serialVersionUID = 1L;
	private JRadioButton morningButton;
	private JRadioButton afternoonButton;
	private JDateChooser dateChooser;
	private JButton okButton;
	private JButton cancelButton;
	private boolean retVal;
	private JComboBox cbIncidents;
	private DefaultComboBoxModel cbModell;

	public CertificateDialog() {
		super(MainFrame.getInstance(), Translatrix.getTranslationString("patient.certificate.printCertificate"), true);
		this.setLayout(new FormLayout(
				"2dlu, pref, 2dlu, fill:pref:grow",
				"2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref:grow, 2dlu, pref, 2dlu"));
		
		this.getContentPane().setBackground(GECAMedColors.c_GECAMedBackground);
		
		this.addComponentListener(this);
		
		CellConstraints cc = new CellConstraints();
		
		ButtonGroup bg = new ButtonGroup();
		morningButton = new JRadioButton(Translatrix.getTranslationString("patient.certificate.morning"));
		this.morningButton.setOpaque(false);
		bg.add(morningButton);
		this.add(morningButton, cc.xyw(2,2,3));
		
		afternoonButton = new JRadioButton(Translatrix.getTranslationString("patient.certificate.afternoon"));
		this.afternoonButton.setOpaque(false);
		bg.add(afternoonButton);
		this.add(afternoonButton, cc.xyw(2,4,3));

		morningButton.setSelected(true);
		
		this.add(new JLabel(Translatrix.getTranslationString("patient.certificate.Date")), cc.xy(2,6));
		
		dateChooser = GECAMedGuiUtils.getDateChooser(false);
		this.add(dateChooser, cc.xy(4,6));
		
		this.cbModell = new DefaultComboBoxModel();
		this.cbIncidents = new JComboBox(cbModell);
		cbIncidents.setRenderer(new DefaultListCellRenderer() {
			private static final long serialVersionUID = 1L;
			public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
				Incident i = (Incident) value;
				return super.getListCellRendererComponent(list, 
						i.getAccidentNr() + (i.getAccidentDate()!=null?" (" + i.getAccidentDate() + ")":"") 
						, index, isSelected,
						cellHasFocus);
			}
		});
		this.add(new JLabel(Translatrix.getTranslationString("patient.certificate.Accident")), cc.xy(2,8));
		this.add(cbIncidents, cc.xy(4,8));
		
		ButtonBarBuilder bb = new ButtonBarBuilder();
		bb.addGlue();
		cancelButton = new JButton(Translatrix.getTranslationString("core.cancel"));
		cancelButton.addActionListener(this);
		bb.addGridded(cancelButton);
		bb.addRelatedGap();
		okButton = new JButton(Translatrix.getTranslationString("core.ok"));
		okButton.addActionListener(this);
		okButton.addKeyListener(new KeyAdapter() {
			@Override
			public void keyReleased(KeyEvent e) {
				if (e.getKeyCode() == KeyEvent.VK_ENTER) {
					retVal = true;
					setVisible(false);
				}
			}
		});
		bb.addGridded(okButton);
		
		JPanel bPanel = bb.getPanel();
		bPanel.setOpaque(false);
		this.add(bPanel, cc.xyw(2,10,3));

		this.setSize(300, 170);
	}
	
	/**
	 * initializes and shows the dialog.
	 * @return
	 */
	public boolean showDialog() {
		retVal = false;
		Calendar c = new GregorianCalendar();
		this.dateChooser.setDate(c.getTime());
		if (c.get(Calendar.HOUR_OF_DAY) <= 12) {
			this.morningButton.setSelected(true);
		} else {
			this.afternoonButton.setSelected(true);
		}
		
		cbModell.removeAllElements();
		Incident i = new Incident();
		i.setAccidentNr(Translatrix.getTranslationString("patient.certificate.noAccident"));
		i.setAccidentDate(null);
		i.setSiteId(MainFrame.getCurrentSiteId());
		cbModell.addElement(i);
		cbIncidents.setSelectedIndex(0);
		Collection<Incident> incidents = PatientManagerModule.getPatientAccidents(GECAMedModule.getCurrentPatient().getId());
		for (Iterator iter = incidents.iterator(); iter.hasNext();) {
			Incident element = (Incident) iter.next();
			cbModell.addElement(element);
		}
		this.setLocationRelativeTo(MainFrame.getInstance());
		this.setVisible(true);
		return retVal;
	}

	/* (non-Javadoc)
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		if (e.getSource().equals(this.cancelButton)) {
			this.setVisible(false);
		} else if (e.getSource().equals(this.okButton)) {
			retVal = true;
			setVisible(false);
		}
	}
	
	/**
	 * returns the choosen date
	 * @return
	 */
	public Date getDate() {
		return dateChooser.getDate();
	}
	
	/**
	 * returns if ismorning has been choosen
	 * @return
	 */
	public boolean isMorning() {
		return this.morningButton.isSelected();
	}
	
	/**
	 * returns the selected accident
	 * @return
	 */
	public Incident getAccident() {
		return (Incident) this.cbIncidents.getSelectedItem();
	}

	public void componentHidden(ComponentEvent e) {}
	public void componentMoved(ComponentEvent e) {}
	public void componentResized(ComponentEvent e) {}
	/* (non-Javadoc)
	 * @see java.awt.event.ComponentListener#componentShown(java.awt.event.ComponentEvent)
	 */
	public void componentShown(ComponentEvent e) {
		this.okButton.requestFocusInWindow();
	}
	
}

