/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.connector;

import com.jacob.com.Dispatch;
import com.jacob.com.Variant;

/**
 * interface to the erisk applications via Java Com Bridge jacob
 *
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: IEriskInterfaceEvents.java,v $
 * <br>Revision 1.4  2013-12-27 18:09:25  donak
 * <br>Cleanup of imports
 * <br>
 * <br>Revision 1.3  2008-09-25 09:43:07  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:21  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class IEriskInterfaceEvents extends Dispatch {

	public static final String componentName = "pfizer_erisk_components.IEriskInterfaceEvents";

	public IEriskInterfaceEvents() {
		super(componentName);
	}

	/**
	* This constructor is used instead of a case operation to
	* turn a Dispatch object into a wider object - it must exist
	* in every wrapper class whose instances may be returned from
	* method calls wrapped in VT_DISPATCH Variants.
	*/
	public IEriskInterfaceEvents(Dispatch d) {
		// take over the IDispatch pointer
		m_pDispatch = d.m_pDispatch;
		// null out the input's pointer
		d.m_pDispatch = 0;
	}

	public IEriskInterfaceEvents(String compName) {
		super(compName);
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param lastParam an input-parameter of type String
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int onConsultationSaved(String lastParam) {
		return Dispatch.call(this, "OnConsultationSaved", lastParam).toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int onLoading() {
		return Dispatch.call(this, "OnLoading").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int onReady() {
		return Dispatch.call(this, "OnReady").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int onQuit() {
		return Dispatch.call(this, "OnQuit").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @param errorCode an input-parameter of type int
	 * @param lastParam an input-parameter of type String
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int onError(int errorCode, String lastParam) {
		return Dispatch.call(this, "OnError", new Variant(errorCode), lastParam).toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int onBatchStart() {
		return Dispatch.call(this, "OnBatchStart").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int onBatchNext() {
		return Dispatch.call(this, "OnBatchNext").toInt();
	}

	/**
	 * Wrapper for calling the ActiveX-Method with input-parameter(s).
	 * @return the result is of type int
	 */
	@SuppressWarnings("deprecation")
	public int onBatchStatus() {
		return Dispatch.call(this, "OnBatchStatus").toInt();
	}

}
