/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

/**
 * constants used for Kmehr
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmConstants.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-21 14:57:21  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public interface KmConstants {

	public static final String VERSION = "1.0";
	
	public static final String ID_KMEHR = "ID-KMEHR";
	public static final String ID_PATIENT = "ID-PATIENT";
	public static final String ID_INSURANCE = "ID-INSURANCE";
	public static final String ID_IHCPARTY = "ID-HCPARTY";
	
	public static final String LOCAL = "LOCAL";
	
	public static final String CD_STANDARD = "CD-STANDARD";
	public static final String CD_SEX = "CD-SEX";
	public static final String CD_ADDRESS = "CD-ADDRESS";
	public static final String CD_COUNTRY = "CD-COUNTRY";
	public static final String CD_TELECOM = "CD-TELECOM";
	public static final String CD_TRANSACTION = "CD-TRANSACTION";
	public static final String CD_HCPARTY = "CD-HCPARTY";
	public static final String CD_ITEM = "CD-ITEM";
	
	public static final String TRANSACTION_REQUEST = "request";

	
}
