/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

import org.jdom.Element;

/**
 * class that represents an Kmehr hcpartay object
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmHCParty.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:22  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class KmHCParty implements KmConstants{

	private static final String HCPARTY = "hcparty";
	private static final String FIRSTNAME = "firstname";
	private static final String FAMILYNAME = "familyname";
	private static final String NAME = "name";
	
	public  static final String PERSPHYSICIAN = "persphysician";
	public static final String APPLICATION = "application";
	private String name;
	private String id;
	private String type;
	private String firstname;
	private String familyname;
	
	/**
	 * creates the Kmehr xml element
	 * @param type
	 * @param id
	 * @param name
	 */
	public KmHCParty(String type, String id, String name) {
		this(type, id, name, null, null);
	}
	
	/**
	 * creates the Kmehr xml element
	 * @param type
	 * @param id
	 * @param firstname
	 * @param familyname
	 */
	public KmHCParty(String type, String id, String firstname, String familyname) {
		this(type, id, null, firstname, familyname);
	}
	
	
	private KmHCParty(String type, String id, String name, String firstname, String familyname) {
		this.name = name;
		this.id = id;
		this.type = type;
		this.firstname = firstname;
		this.familyname = familyname;
	}

	
	/**
	 * returns the Kmehr xml element
	 * @return
	 */
	public Element getElement() {
		Element hcparty = new Element(HCPARTY);
		hcparty.addContent(KmID.create(ID_IHCPARTY, id));
		hcparty.addContent(KmCD.create(CD_HCPARTY, type));
		if (name != null) {
		    Element eName = new Element(NAME);
		    eName.setText(name);
		    hcparty.addContent(eName);
		}
		if (firstname != null) {
		    Element eFirstName = new Element(FIRSTNAME);
		    eFirstName.setText(firstname);
		    hcparty.addContent(eFirstName);
		}
		if (familyname != null) {
		    Element eFamilyName = new Element(FAMILYNAME);
		    eFamilyName.setText(familyname);
		    hcparty.addContent(eFamilyName);
		}
	    return hcparty;
	}
	
}

