/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

import java.util.Date;

import org.jdom.Element;

/**
 * class that represents an Kmehr header object
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmHeader.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:21  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class KmHeader  implements KmConstants{

	private static final String HEADER = "header";
	private static final String SENDER = "sender";
	private static final String RECIPIENT = "recipient";
	
	private Element header;
	private Element sender;
	private Element recipient;
	
	public KmHeader(String id) {
		header = new Element(HEADER);
	    header.addContent(KmStandart.create());
	    header.addContent(KmID.create(ID_KMEHR, id));
	    header.addContent(KmDate.create(new Date()));
	    header.addContent(KmTime.create(new Date()));
	    
	    sender = new Element(SENDER);
	    header.addContent(sender);	
	    
	    recipient = new Element(RECIPIENT);
	    header.addContent(recipient);	
	    
	}
	
	public void addSender(Element hcpartySender) {
		sender.addContent(hcpartySender);
	}
	
	public void addRecipient(Element hcpartyRecipient) {
		recipient.addContent(hcpartyRecipient);
	}
	
	/**
	 * returns the Kmehr xml element
	 * @return
	 */
	public Element getElement() {
		return header;
	}
	
	public void addItem(Element item) {
		header.addContent(item);
	}
	
}

