/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

import java.util.Date;

import org.jdom.Element;

/**
 * class that represents an Kmehr item object
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmItem.java,v $
 * <br>Revision 1.3  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.2  2008-01-21 14:57:22  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class KmItem  implements KmConstants{

	private static final String ITEM = "item";
	private static final String CONTENT = "content";

	
	public static final String TYPE_TECHNICAL = "technical";
	
	public static final String SEX = "SEX";
	
	public static final String ITEMDEF_ERISK = "ITEMDEF_ERISK";
	
	private Element item;
	private Element content;
	private static int itemNr = 1;
	
	public KmItem(String type, String itemdef, String name) {
		item = new Element(ITEM);
	    item.addContent(KmID.create(KmID.ID_KMEHR, itemNr  +""));
	    item.addContent(KmID.create(KmID.LOCAL, itemdef, name));
	    item.addContent(KmCD.create(CD_ITEM, type));
	    content = new Element(CONTENT);
	    item.addContent(content);
	    
	    item.addContent(KmDate.create(new Date()));
	    item.addContent(KmTime.create(new Date()));
	   
	    itemNr++;
	}
	
	/**
	 * returns the Kmehr xml element
	 * @return
	 */
	public Element getElement() {
		return item;
	}
	
	public void addContent(Element contentElement) {
		content.addContent(contentElement);
	}
	
	public static void resetItemNr() {
		itemNr = 1;
	}
}

