/*******************************************************************************
 * This file is part of GECAMed.
 * 
 * GECAMed is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License (L-GPL) as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * GECAMed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License (L-GPL)
 * along with GECAMed.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * GECAMed is Copyrighted by the Centre de Recherche Public Henri Tudor (http://www.tudor.lu)
 * (c) CRP Henri Tudor, Luxembourg, 2008
 *******************************************************************************/
package lu.tudor.santec.gecamed.patient.gui.erisk.kmehr;

import java.util.Iterator;

import lu.tudor.santec.gecamed.core.ejb.entity.beans.Language;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.Patient;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientAddress;
import lu.tudor.santec.gecamed.patient.ejb.entity.beans.PatientPhone;

import org.jdom.Element;

/**
 * class that represents an Kmehr patient object
 * take a look at: 
 * http://www.chu-charleroi.be/kmehr/htm/kmehr.htm
 * 
 * @author Johannes Hermen johannes.hermen(at)tudor.lu
 *
 * @version
 * <br>$Log: KmPatient.java,v $
 * <br>Revision 1.4  2008-09-25 09:43:06  heinemann
 * <br>fixed copyrights
 * <br>
 * <br>Revision 1.3  2008-01-21 14:57:21  hermen
 * <br>updated Javadoc and refactured code
 * <br>
 *
 */
public class KmPatient  implements KmConstants{

	private static final String PATIENT = "patient";
	private static final String INSURANCE = "insurance";
	private static final String LANGUAGE = "language";
	private static final String FIRST_NAME = "firstname";
	private static final String FAMILY_NAME = "familyname";
	private static final String BIRTHDATE = "birthdate";
	private static final String SEX = "sex";
	
	
	/**
	 * creates the Kmehr xml element
	 * @param p
	 * @return
	 */
	public static Element create(Patient p) {
		Element patient = new Element(PATIENT);

		patient.addContent(KmID.create(KmID.ID_PATIENT, null));
		patient.addContent(KmID.create(KmID.LOCAL, "EPR", null));
		
		Element insurance = new Element(INSURANCE);
		insurance.addContent(KmID.create(KmID.ID_INSURANCE,
				(p.getInsurance()!= null?p.getInsurance().getAcronym():null)));
		
		patient.addContent(insurance);
		
		Element language = new Element(LANGUAGE);
		language.setText(matchLanguage(p.getLanguage()));
		patient.addContent(language);
		
		Element firstName = new Element(FIRST_NAME);
		firstName.setText(p.getFirstName());
		patient.addContent(firstName);
		
		Element familyName = new Element(FAMILY_NAME);
		familyName.setText(p.getSurName());
		patient.addContent(familyName);
		
		Element birthDate = new Element(BIRTHDATE);
		birthDate.addContent(KmDate.create(p.getBirthDate()));
		patient.addContent(birthDate);
		
		Element sex = new Element(SEX);
		sex.addContent(KmCD.create(KmCD.CD_SEX, p.getGender()));
		patient.addContent(sex);
		
		for (Iterator iter = p.getAddress().iterator(); iter.hasNext();) {
			PatientAddress pa = (PatientAddress) iter.next();
			patient.addContent(KmAddress.create(pa));			
		}
		
		for (Iterator iter = p.getPhones().iterator(); iter.hasNext();) {
			PatientPhone pp = (PatientPhone) iter.next();
			patient.addContent(KmTelecom.create(pp));
		}
		
		if (p.getEmail() != null && ! p.getEmail().equals(""))
			patient.addContent(KmTelecom.create(KmTelecom.EMAIL, p.getEmail()));
		
		return patient;
	}
	
	
	private static String matchLanguage(String lang) {
		if (lang == null) 
			return "";
		else if (lang.equals(Language.ENGLISH))
			return "en"; 
		else if (lang.equals(Language.LUXEMBOURGISH))
			return "lu"; 
		else if (lang.equals(Language.FRENCH))
			return "fr"; 
		else if (lang.equals(Language.GERMAN))
			return "de"; 
		try {
			return lang.substring(0,2); 			
		} catch (Exception e) {
		}
		return "";
	}
	
	
	
	
}
